/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.script.ScriptEngine;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.plugins.scripting.ScriptEngineProvider;
import org.openstreetmap.josm.plugins.scripting.ui.ScriptEngineCellRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ScriptEngineSelectionDialog
extends JDialog {
    private JList lstEngines;
    private JButton btnOK;
    private ScriptEngine selectedEngine;
    private ScriptEngineProvider model;
    private OKAction actOK;

    public static ScriptEngine select(Component parent) {
        if (parent == null) {
            parent = Main.parent;
        }
        ScriptEngineSelectionDialog dialog = new ScriptEngineSelectionDialog(parent);
        dialog.setVisible(true);
        return dialog.selectedEngine;
    }

    public static ScriptEngine select() {
        return ScriptEngineSelectionDialog.select(Main.parent);
    }

    public ScriptEngineSelectionDialog(Component parent) {
        super(JOptionPane.getFrameForComponent(parent), true);
        this.build();
    }

    protected JPanel buildInfoPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        HtmlPanel info = new HtmlPanel();
        info.setText("<html>" + I18n.tr((String)"Please select a scripting engine to execute the selected script.") + "</html>");
        pnl.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        pnl.add((Component)info, "Center");
        return pnl;
    }

    protected JPanel buildControlButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        this.actOK = new OKAction();
        this.btnOK = new SideButton((Action)this.actOK);
        pnl.add(this.btnOK);
        this.btnOK.setFocusable(true);
        CancelAction actCancel = new CancelAction();
        SideButton btn = new SideButton((Action)actCancel);
        pnl.add((Component)btn);
        btn.setFocusable(true);
        btn = new SideButton((Action)new ContextSensitiveHelpAction(HelpUtil.ht((String)"/Plugins/Scripting#SelectScriptingEngine")));
        pnl.add((Component)btn);
        btn.setFocusable(true);
        this.getRootPane().registerKeyboardAction(this.actOK, KeyStroke.getKeyStroke(10, 128), 2);
        this.getRootPane().registerKeyboardAction(actCancel, KeyStroke.getKeyStroke(27, 0), 2);
        return pnl;
    }

    protected JPanel buildScriptEngineListPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.model = ScriptEngineProvider.getInstance();
        this.lstEngines = new JList(this.model);
        this.lstEngines.setCellRenderer(new ScriptEngineCellRenderer());
        pnl.add((Component)this.lstEngines, "Center");
        this.lstEngines.setSelectionMode(0);
        this.lstEngines.setSelectedIndex(0);
        this.lstEngines.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ScriptEngineSelectionDialog.this.actOK.execute();
                }
            }
        });
        return pnl;
    }

    protected void build() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.buildInfoPanel(), "North");
        c.add((Component)this.buildScriptEngineListPanel(), "Center");
        c.add((Component)this.buildControlButtonPanel(), "South");
        this.lstEngines.getSelectionModel().addListSelectionListener((OKAction)this.btnOK.getAction());
        this.lstEngines.registerKeyboardAction(this.actOK, KeyStroke.getKeyStroke(10, 0), 0);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.btnOK.requestFocusInWindow();
            WindowGeometry.centerInWindow((Component)this.getParent(), (Dimension)new Dimension(250, 300)).applySafe((Window)this);
        }
        super.setVisible(visible);
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr((String)"Cancel"));
            this.putValue("ShortDescription", I18n.tr((String)"cancel"));
            this.putValue("SmallIcon", ImageProvider.get((String)"cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ScriptEngineSelectionDialog.this.selectedEngine = null;
            ScriptEngineSelectionDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction
    implements ListSelectionListener {
        public OKAction() {
            this.putValue("Name", I18n.tr((String)"OK"));
            this.putValue("ShortDescription", I18n.tr((String)"Accept the selected scripting engine"));
            this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
        }

        public void execute() {
            int selIndex = ScriptEngineSelectionDialog.this.lstEngines.getSelectedIndex();
            ScriptEngineSelectionDialog.this.selectedEngine = selIndex < 0 ? null : ScriptEngineSelectionDialog.this.model.getScriptEngine(selIndex);
            ScriptEngineSelectionDialog.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.execute();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(ScriptEngineSelectionDialog.this.lstEngines.getSelectedIndex() >= 0);
        }
    }
}

