/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ScriptEngineSelectionDialog
extends JDialog {
    private JList lstEngines;
    private JButton btnOK;
    private ScriptEngine selectedEngine;
    private ScriptEngineListModel model;
    private OKAction actOK;

    public static ScriptEngine select(Component parent) {
        if (parent == null) {
            parent = Main.parent;
        }
        ScriptEngineSelectionDialog dialog = new ScriptEngineSelectionDialog(parent);
        dialog.setVisible(true);
        return dialog.selectedEngine;
    }

    public static ScriptEngine select() {
        return ScriptEngineSelectionDialog.select(Main.parent);
    }

    public ScriptEngineSelectionDialog(Component parent) {
        super(JOptionPane.getFrameForComponent(parent), true);
        this.build();
    }

    protected JPanel buildInfoPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        HtmlPanel info = new HtmlPanel();
        info.setText("<html>" + I18n.tr((String)"Please select a scripting engine to execute the selected script.") + "</html>");
        pnl.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        pnl.add((Component)info, "Center");
        return pnl;
    }

    protected JPanel buildControlButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        this.actOK = new OKAction();
        this.btnOK = new SideButton((Action)this.actOK);
        pnl.add(this.btnOK);
        this.btnOK.setFocusable(true);
        CancelAction actCancel = new CancelAction();
        SideButton btn = new SideButton((Action)actCancel);
        pnl.add((Component)btn);
        btn.setFocusable(true);
        btn = new SideButton((Action)new ContextSensitiveHelpAction(HelpUtil.ht((String)"/Plugins/Scripting#SelectScriptingEngine")));
        pnl.add((Component)btn);
        btn.setFocusable(true);
        this.getRootPane().registerKeyboardAction(this.actOK, KeyStroke.getKeyStroke(10, 128), 2);
        this.getRootPane().registerKeyboardAction(actCancel, KeyStroke.getKeyStroke(27, 0), 2);
        return pnl;
    }

    protected JPanel buildScriptEngineListPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.model = new ScriptEngineListModel();
        this.lstEngines = new JList(this.model);
        this.lstEngines.setCellRenderer(new ScriptEngineCellRenderer());
        pnl.add((Component)this.lstEngines, "Center");
        this.lstEngines.setSelectionMode(0);
        this.lstEngines.setSelectedIndex(0);
        this.lstEngines.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ScriptEngineSelectionDialog.this.actOK.execute();
                }
            }
        });
        return pnl;
    }

    protected void build() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.buildInfoPanel(), "North");
        c.add((Component)this.buildScriptEngineListPanel(), "Center");
        c.add((Component)this.buildControlButtonPanel(), "South");
        this.lstEngines.getSelectionModel().addListSelectionListener((OKAction)this.btnOK.getAction());
        this.lstEngines.registerKeyboardAction(this.actOK, KeyStroke.getKeyStroke(10, 0), 0);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.btnOK.requestFocusInWindow();
            WindowGeometry.centerInWindow((Component)this.getParent(), (Dimension)new Dimension(250, 300)).applySafe((Window)this);
        }
        super.setVisible(visible);
    }

    private static class ScriptEngineCellRenderer
    implements ListCellRenderer {
        private final JLabel lbl = new JLabel();

        protected String getDisplayName(ScriptEngineFactory factory) {
            return I18n.tr((String)"{1} (with engine {0})", (Object[])new Object[]{factory.getEngineName(), factory.getLanguageName()});
        }

        protected String getTooltipText(ScriptEngineFactory factory) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<strong>").append(I18n.tr((String)"Name:")).append("</strong> ").append(factory.getEngineName()).append("<br>");
            sb.append("<strong>").append(I18n.tr((String)"Version:")).append("</strong> ").append(factory.getEngineVersion()).append("<br>");
            sb.append("<strong>").append(I18n.tr((String)"Language:")).append("</strong> ").append(factory.getLanguageName()).append("<br>");
            sb.append("<strong>").append(I18n.tr((String)"Language version:")).append("</strong> ").append(factory.getLanguageVersion()).append("<br>");
            sb.append("<strong>").append(I18n.tr((String)"MIME-Types:")).append("</strong> ");
            List<String> types = factory.getMimeTypes();
            for (int i = 0; i < types.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(types.get(i));
            }
            sb.append("<br>");
            sb.append("</html>");
            return sb.toString();
        }

        protected void renderColors(boolean selected) {
            if (!selected) {
                this.lbl.setForeground(UIManager.getColor("List.foreground"));
                this.lbl.setBackground(UIManager.getColor("List.background"));
            } else {
                this.lbl.setForeground(UIManager.getColor("List.selectionForeground"));
                this.lbl.setBackground(UIManager.getColor("List.selectionBackground"));
            }
        }

        public ScriptEngineCellRenderer() {
            this.lbl.setOpaque(true);
            this.lbl.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.lbl.setIcon(ImageProvider.get((String)"script-engine"));
        }

        public Component getListCellRendererComponent(JList list, Object obj, int index, boolean isSelected, boolean cellHasFocus) {
            ScriptEngineFactory factory = (ScriptEngineFactory)obj;
            this.renderColors(isSelected);
            this.lbl.setText(this.getDisplayName(factory));
            this.lbl.setToolTipText(this.getTooltipText(factory));
            return this.lbl;
        }
    }

    private static class ScriptEngineListModel
    extends AbstractListModel {
        private List<ScriptEngineFactory> factories;

        public ScriptEngineListModel() {
            ScriptEngineManager mgr = new ScriptEngineManager(this.getClass().getClassLoader());
            this.factories = new ArrayList<ScriptEngineFactory>(mgr.getEngineFactories());
            Collections.sort(this.factories, new Comparator<ScriptEngineFactory>(){

                @Override
                public int compare(ScriptEngineFactory f1, ScriptEngineFactory f2) {
                    return f1.getEngineName().compareTo(f2.getEngineName());
                }
            });
        }

        public ScriptEngine getScriptEngine(int i) {
            ScriptEngine engine = this.factories.get(i).getScriptEngine();
            return engine;
        }

        @Override
        public Object getElementAt(int i) {
            return this.factories.get(i);
        }

        @Override
        public int getSize() {
            return this.factories.size();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr((String)"Cancel"));
            this.putValue("ShortDescription", I18n.tr((String)"cancel"));
            this.putValue("SmallIcon", ImageProvider.get((String)"cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ScriptEngineSelectionDialog.this.selectedEngine = null;
            ScriptEngineSelectionDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction
    implements ListSelectionListener {
        public OKAction() {
            this.putValue("Name", I18n.tr((String)"OK"));
            this.putValue("ShortDescription", I18n.tr((String)"Accept the selected scripting engine"));
            this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
        }

        public void execute() {
            int selIndex = ScriptEngineSelectionDialog.this.lstEngines.getSelectedIndex();
            ScriptEngineSelectionDialog.this.selectedEngine = selIndex < 0 ? null : ScriptEngineSelectionDialog.this.model.getScriptEngine(selIndex);
            ScriptEngineSelectionDialog.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.execute();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(ScriptEngineSelectionDialog.this.lstEngines.getSelectedIndex() >= 0);
        }
    }
}

