/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class HelpAwareOptionPane {
    private static List<JButton> createOptionButtons(ButtonSpec[] options, String helpTopic) {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        if (options == null) {
            JButton b = new JButton(I18n.tr((String)"OK"));
            b.setIcon(ImageProvider.get((String)"ok"));
            b.setToolTipText(I18n.tr((String)"Click to close the dialog"));
            b.setFocusable(true);
            buttons.add(b);
        } else {
            for (ButtonSpec spec : options) {
                JButton b = new JButton(spec.text);
                b.setIcon(spec.icon);
                b.setToolTipText(spec.tooltipText == null ? "" : spec.tooltipText);
                if (helpTopic != null) {
                    HelpUtil.setHelpContext((JComponent)b, (String)helpTopic);
                }
                b.setFocusable(true);
                buttons.add(b);
            }
        }
        return buttons;
    }

    private static JButton createHelpButton(final String helpTopic) {
        JButton b = new JButton(I18n.tr((String)"Help"));
        b.setIcon(ImageProvider.get((String)"help"));
        b.setToolTipText(I18n.tr((String)"Show help information"));
        HelpUtil.setHelpContext((JComponent)b, (String)helpTopic);
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpBrowser.setUrlForHelpTopic((String)helpTopic);
            }
        };
        b.addActionListener(a);
        b.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
        b.getActionMap().put("enter", a);
        return b;
    }

    public static int showOptionDialog(Component parentComponent, Object msg, String title, int messageType, Icon icon, final ButtonSpec[] options, final ButtonSpec defaultOption, String helpTopic) {
        final List<JButton> buttons = HelpAwareOptionPane.createOptionButtons(options, helpTopic);
        if (helpTopic != null) {
            buttons.add(HelpAwareOptionPane.createHelpButton(helpTopic));
        }
        JButton defaultButton = null;
        if (options != null && defaultOption != null) {
            for (int i = 0; i < options.length; ++i) {
                if (options[i] != defaultOption) continue;
                defaultButton = buttons.get(i);
                break;
            }
        }
        if (msg instanceof String) {
            msg = new JLabel((String)msg);
        }
        final JOptionPane pane = new JOptionPane(msg, messageType, -1, icon, buttons.toArray(), defaultButton);
        pane.getValue();
        final JDialog dialog = new JDialog((Window)JOptionPane.getFrameForComponent(parentComponent), title, Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setContentPane(pane);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                pane.setValue(-1);
                super.windowClosed(e);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                if (defaultOption != null && options != null && options.length > 0) {
                    int i;
                    for (i = 0; i < options.length && options[i] != defaultOption; ++i) {
                    }
                    if (i >= options.length) {
                        ((JButton)buttons.get(0)).requestFocusInWindow();
                    }
                    ((JButton)buttons.get(i)).requestFocusInWindow();
                } else {
                    ((JButton)buttons.get(0)).requestFocusInWindow();
                }
            }
        });
        dialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "close");
        dialog.getRootPane().getActionMap().put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pane.setValue(-1);
                dialog.setVisible(false);
            }
        });
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                DefaultAction action = new DefaultAction(dialog, pane, i);
                buttons.get(i).addActionListener(action);
                buttons.get(i).getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
                buttons.get(i).getActionMap().put("enter", action);
            }
        } else {
            DefaultAction action = new DefaultAction(dialog, pane, 0);
            buttons.get(0).addActionListener(action);
            buttons.get(0).getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
            buttons.get(0).getActionMap().put("enter", action);
        }
        dialog.pack();
        WindowGeometry.centerOnScreen((Dimension)dialog.getSize()).applySafe((Window)dialog);
        if (helpTopic != null) {
            HelpUtil.setHelpContext((JComponent)dialog.getRootPane(), (String)helpTopic);
        }
        dialog.setVisible(true);
        return (Integer)pane.getValue();
    }

    public static int showOptionDialog(Component parentComponent, Object msg, String title, int messageType, String helpTopic) {
        return HelpAwareOptionPane.showOptionDialog(parentComponent, msg, title, messageType, null, null, null, helpTopic);
    }

    public static void showMessageDialogInEDT(final Component parentComponent, final Object msg, final String title, final int messageType, final String helpTopic) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpAwareOptionPane.showOptionDialog(parentComponent, msg, title, messageType, null, null, null, helpTopic);
            }
        });
    }

    private static class DefaultAction
    extends AbstractAction {
        private JDialog dialog;
        private JOptionPane pane;
        private int value;

        public DefaultAction(JDialog dialog, JOptionPane pane, int value) {
            this.dialog = dialog;
            this.pane = pane;
            this.value = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.pane.setValue(this.value);
            this.dialog.setVisible(false);
        }
    }

    public static class ButtonSpec {
        public String text;
        public Icon icon;
        public String tooltipText;
        public String helpTopic;

        public ButtonSpec(String text, Icon icon, String tooltipText, String helpTopic) {
            this.text = text;
            this.icon = icon;
            this.tooltipText = tooltipText;
            this.helpTopic = helpTopic;
        }
    }
}

