/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.macro;

import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.plugins.macro.MacroPlugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RunMacroDialog
extends JDialog {
    private JTextField tfMacroFile;

    public RunMacroDialog(JFrame owner) {
        super((Frame)owner, true);
        this.build();
    }

    protected JPanel buildInfoPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        HtmlPanel info = new HtmlPanel();
        info.setText("<html>" + I18n.tr((String)"Enter or select a macro file and click on <strong>Run</strong>.") + "</html>");
        pnl.add((Component)info, "Center");
        return pnl;
    }

    protected JPanel buildControlButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        pnl.add((Component)new SideButton((Action)new CancelAction()));
        pnl.add((Component)new SideButton((Action)new ContextSensitiveHelpAction(HelpUtil.ht((String)"/Plugin/Macro#Run"))));
        return pnl;
    }

    protected JPanel buildMacroFileInputPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        pnl.add((Component)new JLabel(I18n.tr((String)"File:")), gc);
        this.tfMacroFile = new JTextField();
        this.tfMacroFile.setToolTipText(I18n.tr((String)"Enter a macro file"));
        gc.gridx = 1;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        pnl.add((Component)this.tfMacroFile, gc);
        gc.gridx = 2;
        gc.gridy = 0;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        pnl.add((Component)new JButton(new SelectMacroFileAction()), gc);
        return pnl;
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.buildInfoPanel(), "North");
        pnl.add((Component)this.buildMacroFileInputPanel(), "Center");
        pnl.add((Component)this.buildControlButtonPanel(), "South");
        return pnl;
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildContentPanel(), "Center");
        this.setTitle(I18n.tr((String)"Run a macro"));
        this.setSize(400, 200);
    }

    private class SelectMacroFileAction
    extends AbstractAction {
        public SelectMacroFileAction() {
            this.putValue("Name", I18n.tr((String)"..."));
            this.putValue("ShortDescription", I18n.tr((String)"Open file selection dialog"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    }

    private class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("Name", I18n.tr((String)"Run"));
            this.putValue("ShortDescription", I18n.tr((String)"Run the macro"));
        }

        protected void warnMacroFileDoesntExist(File f) {
        }

        protected void warnMacroFileIsntReadable(File f) {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String fileName = RunMacroDialog.this.tfMacroFile.getText().trim();
            File f = new File(fileName);
            if (!f.exists() || !f.isFile()) {
                this.warnMacroFileDoesntExist(f);
                return;
            }
            if (!f.canRead()) {
                this.warnMacroFileIsntReadable(f);
                return;
            }
            GroovyScriptEngine engine = new GroovyScriptEngine((ResourceConnector)MacroPlugin.getInstance());
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr((String)"Cancel"));
            this.putValue("ShortDescription", I18n.tr((String)"Cancel"));
            this.putValue("SmallIcon", ImageProvider.get((String)"cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            RunMacroDialog.this.setVisible(false);
        }
    }
}

