/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.macro;

import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;

public class MacroPlugin
extends Plugin
implements ResourceConnector {
    private static MacroPlugin instance;

    public static MacroPlugin getInstance() {
        return instance;
    }

    public MacroPlugin(PluginInformation info) {
        super(info);
        instance = this;
    }

    protected void installMacroMenu() {
        JMenu mnuMacro = new JMenu("Macro");
        Main.main.menu.add(mnuMacro);
        mnuMacro.add(new RunMacroAction());
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.installMacroMenu();
        }
    }

    public URLConnection getResourceConnection(String name) throws ResourceException {
        URL url = ((Object)((Object)this)).getClass().getResource("/macros/" + name);
        if (url == null) {
            throw new ResourceException(MessageFormat.format("macro ''{0}'' not found", name));
        }
        try {
            return url.openConnection();
        }
        catch (IOException e) {
            throw new ResourceException(MessageFormat.format("failed to access macro ''{0}''", name), (Throwable)e);
        }
    }

    private static class RunMacroAction
    extends AbstractAction {
        public RunMacroAction() {
            this.putValue("Name", "Run");
            this.putValue("ShortDescription", "Run sample macro");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ScriptEngineManager manager = new ScriptEngineManager(this.getClass().getClassLoader());
            for (ScriptEngineFactory fac : manager.getEngineFactories()) {
                System.out.println(fac.getEngineName());
            }
            ScriptEngine engine = manager.getEngineByName("groovy");
            if (engine == null) {
                System.out.println("Fatal: didn't find script engine 'groovy'");
                return;
            }
            InputStream is = this.getClass().getResourceAsStream("/macros/listLayers.groovy");
            if (is == null) {
                System.out.println("Fatal: did not find macro '/macros/listLayers.groovy'");
                return;
            }
            try {
                InputStreamReader reader = new InputStreamReader(is, "UTF-8");
                engine.eval(reader);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
    }
}

