/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.contouralign;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaySlice {
    private Way w;
    private int start;
    private int end;
    private boolean inDirection;

    private static WaySlice buildFromClosedWay(Way way, List<Node> nodes) {
        int high;
        int low;
        if (nodes.size() < 3) {
            return null;
        }
        for (low = 1; low <= way.getNodesCount() - 2 && !nodes.contains(way.getNode(low)); ++low) {
        }
        for (high = way.getNodesCount() - 2; high >= 1 && !nodes.contains(way.getNode(high)); --high) {
        }
        if (nodes.contains(way.getNode(0))) {
            return new WaySlice(way, low, high, false);
        }
        return new WaySlice(way, low, high, true);
    }

    private static WaySlice buildFromOpenWay(Way way, List<Node> nodes) {
        int high;
        int low;
        if (nodes.size() < 2) {
            return null;
        }
        for (low = 0; low <= way.getNodesCount() - 1 && !nodes.contains(way.getNode(low)); ++low) {
        }
        for (high = way.getNodesCount() - 1; high >= 0 && !nodes.contains(way.getNode(high)); --high) {
        }
        return new WaySlice(way, low, high, true);
    }

    private static <T> List<T> unique(List<T> l) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T v : l) {
            if (v == null || ret.contains(v)) continue;
            ret.add(v);
        }
        return ret;
    }

    public static WaySlice build(Way way, List<Node> nodes) {
        CheckParameterUtil.ensureParameterNotNull((Object)way, (String)"way");
        CheckParameterUtil.ensureParameterNotNull(nodes, (String)"nodes");
        nodes = WaySlice.unique(nodes);
        nodes.retainAll(way.getNodes());
        if (nodes.containsAll(way.getNodes())) {
            return null;
        }
        WaySlice ws = null;
        ws = way.isClosed() ? WaySlice.buildFromClosedWay(way, nodes) : WaySlice.buildFromOpenWay(way, nodes);
        if (ws == null || ws.hasSlings()) {
            return null;
        }
        return ws;
    }

    private WaySlice(Way w, int start, int end, boolean inDirection) {
        this.w = w;
        this.start = start;
        this.end = end;
        this.inDirection = inDirection;
    }

    public Way getWay() {
        return this.w;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isInDirection() {
        return this.inDirection;
    }

    protected boolean hasSlings() {
        int i;
        HashSet<Node> nodeSet = new HashSet<Node>();
        if (this.w.isClosed()) {
            if (this.inDirection) {
                for (i = this.start; i <= this.end; ++i) {
                    nodeSet.add(this.w.getNode(i));
                }
            } else {
                for (i = this.start; i > 0; --i) {
                    nodeSet.add(this.w.getNode(i));
                }
                for (i = this.w.getNodesCount() - 1; i >= this.end; --i) {
                    nodeSet.add(this.w.getNode(i));
                }
            }
        } else {
            for (i = this.start; i <= this.end; ++i) {
                nodeSet.add(this.w.getNode(i));
            }
        }
        HashSet<Node> seen = new HashSet<Node>();
        for (int i2 = 0; i2 < (this.w.isClosed() ? this.w.getNodesCount() - 1 : this.w.getNodesCount()); ++i2) {
            Node n = this.w.getNode(i2);
            if (seen.contains(n)) {
                return true;
            }
            if (!nodeSet.contains(n)) continue;
            seen.add(n);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<way-slide ").append("forway=").append(this.w.getPrimitiveId()).append(", start=").append(this.start).append(", end=").append(this.end).append(", isInDirection=").append(this.inDirection).append(">");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + (this.inDirection ? 1231 : 1237);
        result = 31 * result + this.start;
        result = 31 * result + (this.w == null ? 0 : this.w.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WaySlice other = (WaySlice)obj;
        if (this.end != other.end) {
            return false;
        }
        if (this.inDirection != other.inDirection) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return !(this.w == null ? other.w != null : !this.w.equals((Object)other.w));
    }
}

