/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.contourmerge;

import javax.swing.Action;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.contourmerge.ContourMergeMode;
import org.openstreetmap.josm.plugins.contourmerge.ContourMergeModelManager;
import org.openstreetmap.josm.plugins.contourmerge.ContourMergeView;

public class ContourMergePlugin
extends Plugin {
    private ContourMergeMode mode;
    private static boolean modeEnabled;

    public ContourMergePlugin(PluginInformation info) {
        super(info);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame == null) {
            ContourMergeModelManager.getInstance().unwireFromJOSM();
            ContourMergeView.getInstance().unwireFromJOSM();
        } else {
            this.mode = new ContourMergeMode(newFrame);
            newFrame.addMapMode(new IconToggleButton((Action)((Object)this.mode)));
            ContourMergeModelManager.getInstance().wireToJOSM();
            ContourMergeView.getInstance().wireToJOSM();
        }
    }

    public static ContourMergeModelManager getModelManager() {
        return ContourMergeModelManager.getInstance();
    }

    public static ContourMergeView getView() {
        return ContourMergeView.getInstance();
    }

    public static boolean isEnabled() {
        return modeEnabled;
    }

    public static void setEnabled(boolean enabled) {
        modeEnabled = enabled;
    }
}

