/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.contouralign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.contouralign.WaySlice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContourAlignModel
extends Observable
implements MapView.EditLayerChangeListener,
SelectionChangedListener {
    private WaySlice targetSlice;
    private WaySlice sourceSlice;

    public void wireToJOSM() {
        MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        DataSet.addSelectionListener((SelectionChangedListener)this);
    }

    public void unwireFromJOSM() {
        MapView.removeEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        DataSet.removeSelectionListener((SelectionChangedListener)this);
    }

    public boolean canAlignContour() {
        return this.targetSlice != null && this.sourceSlice != null;
    }

    protected void setTargetSlice(WaySlice targetSlice) {
        if (this.targetSlice == null ^ targetSlice == null) {
            this.setChanged();
        } else if (this.targetSlice != null && !this.targetSlice.equals(targetSlice)) {
            this.setChanged();
        }
        this.targetSlice = targetSlice;
    }

    protected void setSourceSlice(WaySlice sourceSlice) {
        if (this.sourceSlice == null ^ sourceSlice == null) {
            this.setChanged();
        } else if (this.sourceSlice != null && !this.sourceSlice.equals(sourceSlice)) {
            this.setChanged();
        }
        this.sourceSlice = sourceSlice;
    }

    protected void insertTargetSlice(List<Node> nodes, int pos) {
        if (this.targetSlice.isInDirection()) {
            for (int i = this.targetSlice.getEnd(); i >= this.targetSlice.getStart(); --i) {
                nodes.add(pos, this.targetSlice.getWay().getNode(i));
            }
        } else {
            int i;
            for (i = this.targetSlice.getStart(); i > 0; --i) {
                nodes.add(pos, this.targetSlice.getWay().getNode(i));
            }
            for (i = this.targetSlice.getWay().getNodesCount() - 1; i > this.targetSlice.getEnd(); --i) {
                nodes.add(pos, this.targetSlice.getWay().getNode(i));
            }
        }
    }

    protected List<Node> buildAlignedSourceNodeList() {
        ArrayList<Object> newSourceNodes = new ArrayList<Node>(this.sourceSlice.getWay().getNodes());
        if (this.sourceSlice.isInDirection()) {
            for (int i = this.sourceSlice.getStart(); i <= this.sourceSlice.getEnd(); ++i) {
                newSourceNodes.remove(this.sourceSlice.getStart());
            }
            this.insertTargetSlice(newSourceNodes, this.sourceSlice.getStart());
        } else {
            ArrayList temp = new ArrayList();
            for (int i = this.sourceSlice.getStart(); i <= this.sourceSlice.getEnd(); ++i) {
                temp.add(newSourceNodes.get(i));
            }
            newSourceNodes = temp;
            this.insertTargetSlice(newSourceNodes, this.sourceSlice.getStart());
            newSourceNodes.add(newSourceNodes.get(0));
        }
        return newSourceNodes;
    }

    public Command buildAlignContourCommands() {
        if (!this.canAlignContour()) {
            return null;
        }
        List<Node> newSourceNodes = this.buildAlignedSourceNodeList();
        Way clone = new Way(this.sourceSlice.getWay());
        clone.setNodes(newSourceNodes);
        ChangeCommand cmd = new ChangeCommand((OsmPrimitive)this.sourceSlice.getWay(), (OsmPrimitive)clone);
        return cmd;
    }

    protected List<Way> deriveWaysFromSelectedNodes(List<Node> nodes) {
        ArrayList<Way> ways = new ArrayList<Way>();
        for (Node n : nodes) {
            ways.addAll(OsmPrimitive.getFilteredList((Collection)n.getReferrers(), Way.class));
        }
        HashSet<Way> temp = new HashSet<Way>();
        Iterator it = ways.iterator();
        while (it.hasNext()) {
            Way w = (Way)it.next();
            if (temp.contains(it)) {
                it.remove();
                continue;
            }
            temp.add(w);
        }
        return ways;
    }

    public void initFromJOSMSelection(Collection<OsmPrimitive> sel) {
        if (sel == null) {
            this.reset();
            return;
        }
        List<Way> ways = OsmPrimitive.getFilteredList(sel, Way.class);
        List nodes = OsmPrimitive.getFilteredList(sel, Node.class);
        if (ways.isEmpty()) {
            ways = this.deriveWaysFromSelectedNodes(nodes);
        }
        if (ways.size() != 2) {
            this.reset();
            return;
        }
        Way source = ways.get(0);
        Way target = ways.get(1);
        if (!this.checkCandidateWay(source) || !this.checkCandidateWay(target)) {
            this.reset();
            return;
        }
        WaySlice sourceSlice = WaySlice.build((Way)source, (Collection)nodes);
        WaySlice targetSlice = WaySlice.build((Way)target, (Collection)nodes);
        if (sourceSlice == null || targetSlice == null) {
            this.reset();
            return;
        }
        this.clearChanged();
        this.setTargetSlice(targetSlice);
        this.setSourceSlice(sourceSlice);
        this.notifyObservers();
    }

    protected void reset() {
        this.clearChanged();
        this.setTargetSlice(null);
        this.setSourceSlice(null);
        this.notifyObservers();
    }

    protected boolean checkCandidateWay(Way way) {
        return way != null && !way.isIncomplete() && !way.isDeleted();
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (newLayer == null) {
            this.initFromJOSMSelection(null);
        } else {
            this.initFromJOSMSelection(newLayer.data.getSelected());
        }
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        ArrayList<OsmPrimitive> ways = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : newSelection) {
            if (!(osmPrimitive instanceof Way)) continue;
            ways.add(osmPrimitive);
        }
        this.initFromJOSMSelection(ways);
    }
}

