/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.List;
import java.util.Locale;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Pair;

public class OsmUtils {
    private static String cachedLocale = null;

    private OsmUtils() {
    }

    public static double getMinimumDistanceToWay(LatLon coor, Way w) {
        if (coor == null || w == null) {
            return Double.POSITIVE_INFINITY;
        }
        double minDist = Double.MAX_VALUE;
        List x = w.getNodePairs(true);
        for (Pair pair : x) {
            LatLon bp;
            LatLon ap = ((Node)pair.a).getCoor();
            double dist = OsmUtils.findMinimum(ap, bp = ((Node)pair.b).getCoor(), coor);
            if (!(dist < minDist)) continue;
            minDist = dist;
        }
        return minDist;
    }

    private static double findMinimum(LatLon a, LatLon b, LatLon c) {
        CheckParameterUtil.ensureParameterNotNull((Object)c, (String)"c");
        CheckParameterUtil.ensureParameterNotNull((Object)b, (String)"b");
        CheckParameterUtil.ensureParameterNotNull((Object)a, (String)"a");
        LatLon mid = new LatLon((a.lat() + b.lat()) / 2.0, (a.lon() + b.lon()) / 2.0);
        double ac = a.greatCircleDistance(c);
        double bc = b.greatCircleDistance(c);
        double mc = mid.greatCircleDistance(c);
        double min = Math.min(Math.min(ac, mc), bc);
        if (min < 5.0) {
            return min;
        }
        if (mc < ac && mc < bc) {
            if (ac > bc) {
                return OsmUtils.findMinimum(b, mid, c);
            }
            return OsmUtils.findMinimum(a, mid, c);
        }
        return Math.min(ac, bc);
    }

    public static boolean getValuesFromRelation(OSMAddress address) {
        if (address == null) {
            return false;
        }
        boolean hasValuesFromRel = false;
        OsmPrimitive addrNode = address.getOsmObject();
        for (OsmPrimitive osm : addrNode.getReferrers()) {
            Relation r;
            if (!(osm instanceof Relation) || !TagUtils.isAssociatedStreetRelation(r = (Relation)osm)) continue;
            for (RelationMember rm : r.getMembers()) {
                String streetName;
                OsmPrimitive street;
                if (!TagUtils.isStreetMember(rm) || !TagUtils.hasHighwayTag(street = rm.getMember()) || StringUtils.isNullOrEmpty(streetName = TagUtils.getNameValue(street))) continue;
                address.setDerivedValue("addr:street", streetName);
                hasValuesFromRel = true;
                break;
            }
            if (TagUtils.hasAddrCityTag((OsmPrimitive)r)) {
                address.setDerivedValue("addr:city", TagUtils.getAddrCityValue((OsmPrimitive)r));
                hasValuesFromRel = true;
            }
            if (TagUtils.hasAddrCountryTag((OsmPrimitive)r)) {
                address.setDerivedValue("addr:country", TagUtils.getAddrCountryValue((OsmPrimitive)r));
                hasValuesFromRel = true;
            }
            if (!TagUtils.hasAddrPostcodeTag((OsmPrimitive)r)) continue;
            address.setDerivedValue("addr:postcode", TagUtils.getAddrPostcodeValue((OsmPrimitive)r));
            hasValuesFromRel = true;
        }
        return hasValuesFromRel;
    }

    public static boolean getValuesFromAddressInterpolation(OSMAddress address) {
        if (address == null) {
            return false;
        }
        OsmPrimitive osmAddr = address.getOsmObject();
        for (OsmPrimitive osm : osmAddr.getReferrers()) {
            Way w;
            if (!(osm instanceof Way) || !TagUtils.hasAddrInterpolationTag((OsmPrimitive)(w = (Way)osm))) continue;
            OsmUtils.applyDerivedValue(address, w, "addr:postcode");
            OsmUtils.applyDerivedValue(address, w, "addr:city");
            OsmUtils.applyDerivedValue(address, w, "addr:country");
            OsmUtils.applyDerivedValue(address, w, "addr:street");
            OsmUtils.applyDerivedValue(address, w, "addr:state");
            return true;
        }
        return false;
    }

    public static String getLocale() {
        if (cachedLocale == null) {
            Locale l = Locale.getDefault();
            cachedLocale = l.toString();
        }
        return cachedLocale;
    }

    public static void zoomAddresses(List<OSMAddress> addressList) {
        CheckParameterUtil.ensureParameterNotNull(addressList, (String)"addressList");
        if (Main.map == null && Main.map.mapView == null) {
            return;
        }
        BoundingXYVisitor bbox = new BoundingXYVisitor();
        for (OSMAddress source : addressList) {
            OsmPrimitive osm = source.getOsmObject();
            Bounds b = new Bounds(osm.getBBox().getTopLeft(), osm.getBBox().getBottomRight());
            bbox.visit(b);
        }
        Main.map.mapView.zoomTo(bbox.getBounds());
    }

    private static void applyDerivedValue(OSMAddress address, Way w, String tag) {
        CheckParameterUtil.ensureParameterNotNull((Object)address, (String)"address");
        CheckParameterUtil.ensureParameterNotNull((Object)w, (String)"way");
        if (!address.hasTag(tag) && TagUtils.hasTag((OsmPrimitive)w, tag)) {
            address.setDerivedValue(tag, w.get(tag));
        }
    }
}

