/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.io.Serializable;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class RelationMemberModel
implements Serializable {
    private String role;
    private SimplePrimitiveId target;

    public RelationMemberModel(String role, PrimitiveId target) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)target, (String)"target");
        this.role = role == null ? "" : role;
        this.target = new SimplePrimitiveId(target.getUniqueId(), target.getType());
    }

    public RelationMemberModel(RelationMember member) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)member, (String)"member");
        this.role = member.getRole();
        this.setTarget(member.getMember().getPrimitiveId());
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role == null ? "" : role;
    }

    public PrimitiveId getTarget() {
        return this.target;
    }

    public void setTarget(PrimitiveId target) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)target, (String)"target");
        this.target = new SimplePrimitiveId(target.getUniqueId(), target.getType());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationMemberModel other = (RelationMemberModel)obj;
        if (this.role == null ? other.role != null : !this.role.equals(other.role)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals((Object)other.target));
    }
}

