/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.ConflictAddCommand;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.data.osm.history.RelationMember;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import reverter.DataSetCommandMerger;
import reverter.OsmServerMultiObjectReader;
import reverter.corehacks.ChangesetDataSet;
import reverter.corehacks.OsmServerChangesetReader;

public class ChangesetReverter {
    public final int changesetId;
    public final Changeset changeset;
    public final RevertType revertType;
    private final OsmDataLayer layer;
    private final DataSet ds;
    private final ChangesetDataSet cds;
    private DataSet nds;
    private final HashSet<PrimitiveId> missing = new HashSet();
    private final HashSet<HistoryOsmPrimitive> created = new HashSet();
    private final HashSet<HistoryOsmPrimitive> updated = new HashSet();
    private final HashSet<HistoryOsmPrimitive> deleted = new HashSet();

    private void addIfMissing(PrimitiveId id) {
        OsmPrimitive p = this.ds.getPrimitiveById(id);
        if (p == null || p.isIncomplete()) {
            this.missing.add(id);
        }
    }

    private void addMissingHistoryIds(Iterable<HistoryOsmPrimitive> primitives) {
        for (HistoryOsmPrimitive p : primitives) {
            this.addIfMissing(p.getPrimitiveId());
            if (p.getType() != OsmPrimitiveType.WAY) continue;
            Iterator iterator = ((HistoryWay)p).getNodes().iterator();
            while (iterator.hasNext()) {
                long nd = (Long)iterator.next();
                this.addIfMissing((PrimitiveId)new SimplePrimitiveId(nd, OsmPrimitiveType.NODE));
            }
        }
    }

    private void addMissingIds(Iterable<OsmPrimitive> primitives) {
        for (OsmPrimitive p : primitives) {
            this.addIfMissing((PrimitiveId)p);
            if (p.getType() != OsmPrimitiveType.WAY) continue;
            for (Node nd : ((Way)p).getNodes()) {
                this.addIfMissing((PrimitiveId)nd);
            }
        }
    }

    private boolean CheckOsmChangeEntry(ChangesetDataSet.ChangesetDataSetEntry entry) {
        if (this.revertType == RevertType.FULL) {
            return true;
        }
        if (this.revertType == RevertType.SELECTION_WITH_UNDELETE && entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.DELETED) {
            return true;
        }
        OsmPrimitive p = this.ds.getPrimitiveById(entry.getPrimitive().getPrimitiveId());
        if (p == null) {
            return false;
        }
        return p.isSelected();
    }

    public ChangesetReverter(int changesetId, RevertType revertType, ProgressMonitor monitor) throws OsmTransferException {
        this.changesetId = changesetId;
        this.layer = Main.main.getEditLayer();
        this.ds = this.layer.data;
        this.revertType = revertType;
        OsmServerChangesetReader csr = new OsmServerChangesetReader();
        monitor.beginTask("", 2);
        try {
            this.changeset = csr.readChangeset(changesetId, monitor.createSubTaskMonitor(1, false));
            this.cds = csr.downloadChangeset(changesetId, monitor.createSubTaskMonitor(1, false));
        }
        finally {
            monitor.finishTask();
        }
        Iterator<ChangesetDataSet.ChangesetDataSetEntry> it = this.cds.iterator();
        while (it.hasNext()) {
            ChangesetDataSet.ChangesetDataSetEntry entry = it.next();
            if (!this.CheckOsmChangeEntry(entry)) continue;
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.CREATED) {
                this.created.add(entry.getPrimitive());
                continue;
            }
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.UPDATED) {
                this.updated.add(entry.getPrimitive());
                continue;
            }
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.DELETED) {
                this.deleted.add(entry.getPrimitive());
                continue;
            }
            throw new AssertionError();
        }
    }

    public void checkMissingCreated() {
        this.addMissingHistoryIds(this.created);
    }

    public void checkMissingUpdated() {
        this.addMissingHistoryIds(this.updated);
    }

    public void checkMissingDeleted() {
        this.addMissingHistoryIds(this.deleted);
    }

    public void downloadObjectsHistory(ProgressMonitor progressMonitor) throws OsmTransferException {
        OsmServerMultiObjectReader rdr = new OsmServerMultiObjectReader();
        progressMonitor.beginTask("Downloading objects history", this.updated.size() + this.deleted.size() + 1);
        try {
            for (HistoryOsmPrimitive entry : this.updated) {
                rdr.ReadObject(entry.getPrimitiveId(), this.cds.getEarliestVersion(entry.getPrimitiveId()) - 1, progressMonitor.createSubTaskMonitor(1, true));
                if (!progressMonitor.isCancelled()) continue;
                return;
            }
            for (HistoryOsmPrimitive entry : this.deleted) {
                rdr.ReadObject(entry.getPrimitiveId(), this.cds.getEarliestVersion(entry.getPrimitiveId()) - 1, progressMonitor.createSubTaskMonitor(1, true));
                if (!progressMonitor.isCancelled()) continue;
                return;
            }
            this.nds = rdr.parseOsm(progressMonitor.createSubTaskMonitor(1, true));
            for (OsmPrimitive p : this.nds.allPrimitives()) {
                if (!p.isIncomplete()) {
                    this.addMissingIds(Collections.singleton(p));
                    continue;
                }
                if (this.ds.getPrimitiveById(p.getPrimitiveId()) != null) continue;
                switch (p.getType()) {
                    case NODE: {
                        this.ds.addPrimitive((OsmPrimitive)new Node(p.getUniqueId()));
                        break;
                    }
                    case WAY: {
                        this.ds.addPrimitive((OsmPrimitive)new Way(p.getUniqueId()));
                        break;
                    }
                    case RELATION: {
                        this.ds.addPrimitive((OsmPrimitive)new Relation(p.getUniqueId()));
                    }
                }
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void downloadMissingPrimitives(ProgressMonitor monitor) throws OsmTransferException {
        if (!this.hasMissingObjects()) {
            return;
        }
        MultiFetchServerObjectReader rdr = new MultiFetchServerObjectReader();
        for (PrimitiveId id : this.missing) {
            switch (id.getType()) {
                case NODE: {
                    rdr.append(new Node(id.getUniqueId()));
                    break;
                }
                case WAY: {
                    rdr.append(new Way(id.getUniqueId()));
                    break;
                }
                case RELATION: {
                    rdr.append(new Relation(id.getUniqueId()));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        DataSet source = rdr.parseOsm(monitor);
        for (OsmPrimitive p : source.allPrimitives()) {
            if (p.isVisible() || p.isDeleted()) continue;
            p.setDeleted(true);
            p.setModified(false);
        }
        this.layer.mergeFrom(source);
        this.missing.clear();
    }

    private static Conflict<? extends OsmPrimitive> CreateConflict(OsmPrimitive p, boolean isMyDeleted) {
        switch (p.getType()) {
            case NODE: {
                return new Conflict((OsmPrimitive)((Node)p), (OsmPrimitive)new Node((Node)p), isMyDeleted);
            }
            case WAY: {
                return new Conflict((OsmPrimitive)((Way)p), (OsmPrimitive)new Way((Way)p), isMyDeleted);
            }
            case RELATION: {
                return new Conflict((OsmPrimitive)((Relation)p), (OsmPrimitive)new Relation((Relation)p), isMyDeleted);
            }
        }
        throw new AssertionError();
    }

    private static boolean hasEqualSemanticAttributes(OsmPrimitive current, HistoryOsmPrimitive history) {
        if (!current.getKeys().equals(history.getTags())) {
            return false;
        }
        switch (current.getType()) {
            case NODE: {
                return new LatLon(((Node)current).getCoor()).equals((Object)((HistoryNode)history).getCoords());
            }
            case WAY: {
                List currentNodes = ((Way)current).getNodes();
                List historyNodes = ((HistoryWay)history).getNodes();
                if (currentNodes.size() != historyNodes.size()) {
                    return false;
                }
                int i = 0;
                while (i < currentNodes.size()) {
                    if (((Node)currentNodes.get(i)).getId() != ((Long)historyNodes.get(i)).longValue()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case RELATION: {
                List currentMembers = ((Relation)current).getMembers();
                List historyMembers = ((HistoryRelation)history).getMembers();
                if (currentMembers.size() != historyMembers.size()) {
                    return false;
                }
                int i = 0;
                while (i < currentMembers.size()) {
                    org.openstreetmap.josm.data.osm.RelationMember currentMember = (org.openstreetmap.josm.data.osm.RelationMember)currentMembers.get(i);
                    RelationMember historyMember = (RelationMember)historyMembers.get(i);
                    if (!currentMember.getRole().equals(historyMember.getRole())) {
                        return false;
                    }
                    if (!currentMember.getMember().getPrimitiveId().equals(new SimplePrimitiveId(historyMember.getPrimitiveId(), historyMember.getPrimitiveType()))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        throw new AssertionError();
    }

    public List<Command> getCommands() {
        Iterator p;
        if (this.nds == null) {
            return null;
        }
        DataSetCommandMerger merger = new DataSetCommandMerger(this.nds, this.ds);
        LinkedList<Command> cmds = merger.getCommandList();
        HashSet<Object> toDelete = new HashSet<Object>();
        for (OsmPrimitive p2 : this.nds.allPrimitives()) {
            OsmPrimitive dp;
            if (p2.isVisible() || (dp = this.ds.getPrimitiveById((PrimitiveId)p2)) == null) continue;
            toDelete.add(dp);
        }
        for (HistoryOsmPrimitive id : this.created) {
            p = this.ds.getPrimitiveById(id.getPrimitiveId());
            if (p == null) continue;
            toDelete.add(p);
        }
        HashSet<Object> conflicted = new HashSet<Object>();
        for (Conflict conflict : merger.getConflicts()) {
            cmds.add((Command)new ConflictAddCommand(this.layer, conflict));
        }
        Iterator<ChangesetDataSet.ChangesetDataSetEntry> it = this.cds.iterator();
        while (it.hasNext()) {
            ChangesetDataSet.ChangesetDataSetEntry entry = it.next();
            if (!this.CheckOsmChangeEntry(entry)) continue;
            HistoryOsmPrimitive hp = entry.getPrimitive();
            OsmPrimitive dp = this.ds.getPrimitiveById(hp.getPrimitiveId());
            if (dp == null || dp.isIncomplete()) {
                throw new IllegalStateException(I18n.tr((String)"Missing merge target for {0} with id {1}", (Object[])new Object[]{hp.getType(), hp.getId()}));
            }
            if (hp.getVersion() == dp.getVersion() || !hp.isVisible() && !dp.isVisible() || ChangesetReverter.hasEqualSemanticAttributes(dp, hp)) continue;
            cmds.add((Command)new ConflictAddCommand(this.layer, ChangesetReverter.CreateConflict(dp, entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.CREATED)));
            conflicted.add(dp);
        }
        it = toDelete.iterator();
        block4: while (it.hasNext()) {
            p = (OsmPrimitive)it.next();
            if (p.isDeleted()) {
                it.remove();
                continue;
            }
            for (OsmPrimitive referrer : p.getReferrers()) {
                if (toDelete.contains(referrer) || this.nds.getPrimitiveById((PrimitiveId)referrer) != null) continue;
                if (!conflicted.contains(p)) {
                    cmds.add((Command)new ConflictAddCommand(this.layer, ChangesetReverter.CreateConflict((OsmPrimitive)p, true)));
                    conflicted.add(p);
                }
                it.remove();
                continue block4;
            }
        }
        List list = OsmPrimitive.getFilteredList(toDelete, Relation.class);
        if (!list.isEmpty()) {
            cmds.add((Command)new DeleteCommand((Collection)list));
        }
        if (!(list = OsmPrimitive.getFilteredList(toDelete, Way.class)).isEmpty()) {
            cmds.add((Command)new DeleteCommand((Collection)list));
        }
        if (!(list = OsmPrimitive.getFilteredList(toDelete, Node.class)).isEmpty()) {
            cmds.add((Command)new DeleteCommand((Collection)list));
        }
        return cmds;
    }

    public boolean hasMissingObjects() {
        return !this.missing.isEmpty();
    }

    public static enum RevertType {
        FULL,
        SELECTION,
        SELECTION_WITH_UNDELETE;

    }
}

