/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.mapdust.MapdustLayer;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.CreateIssueDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustInitialUpdateObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustRefreshObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandler;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandlerException;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapdustPlugin
extends Plugin
implements MapView.LayerChangeListener,
NavigatableComponent.ZoomChangeListener,
MouseListener,
MapdustRefreshObserver,
MapdustBugObserver,
MapdustInitialUpdateObserver {
    private MapdustGUI mapdustGUI;
    private MapdustLayer mapdustLayer;
    private List<MapdustBug> mapdustBugList;
    private boolean wasEmpty;

    public MapdustPlugin(PluginInformation info) {
        super(info);
        Main.pref.put("mapdust.pluginState", MapdustPluginState.ONLINE.getValue());
        Main.pref.put("mapdust.nickname", null);
        Main.pref.put("mapdust.modify", false);
    }

    public void mapFrameInitialized(MapFrame oldMapFrame, MapFrame newMapFrame) {
        if (newMapFrame == null) {
            MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
        } else {
            Shortcut shortcut = Shortcut.registerShortcut((String)"mapdust", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Open MapDust")}), (int)48, (int)2, (int)1);
            String name = "MapDust bug reports";
            String tooltip = "Activates the MapDust bug reporter plugin";
            this.mapdustGUI = new MapdustGUI(I18n.tr((String)name), "mapdust_icon.png", I18n.tr((String)tooltip), shortcut, 150, this);
            this.mapdustGUI.setBounds(newMapFrame.getBounds());
            this.mapdustGUI.addObserver(this);
            newMapFrame.addToggleDialog((ToggleDialog)this.mapdustGUI);
            MapView.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
            MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
            Main.map.mapView.addMouseListener((MouseListener)this);
        }
    }

    @Override
    public synchronized void updateData() {
        if (Main.map != null && Main.map.mapView != null) {
            try {
                this.mapdustBugList = this.getMapdustBugs();
                if (this.getMapdustGUI().isDialogShowing()) {
                    if (!(this.mapdustBugList != null && this.mapdustBugList.size() != 0 || this.wasEmpty)) {
                        this.updateView();
                        String waringMessage = "There is no MapDust bug in ";
                        waringMessage = waringMessage + "your visible area.";
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)waringMessage), I18n.tr((String)"Warning"), 2);
                        this.wasEmpty = true;
                    } else {
                        this.updateView();
                        this.wasEmpty = false;
                    }
                }
            }
            catch (MapdustServiceHandlerException e) {
                String errorMessage = "There was a Mapdust service error.";
                errorMessage = errorMessage + " Please try later.";
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage), I18n.tr((String)"Error"), 0);
                MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
                Main.map.mapView.removeLayer((Layer)this.mapdustLayer);
                Main.map.remove((Component)((Object)this.mapdustGUI));
            }
        }
    }

    @Override
    public synchronized void changedData(MapdustBug mapdustBug) {
        if (this.mapdustBugList == null) {
            this.mapdustBugList = new ArrayList<MapdustBug>();
        }
        if (this.getMapdustGUI().isDialogShowing() && Main.map != null && Main.map.mapView != null) {
            boolean wasActive = false;
            if (Main.map.mapView.getActiveLayer() == this.getMapdustLayer()) {
                wasActive = true;
            }
            this.updateMapdustBugList(mapdustBug);
            this.mapdustLayer.destroy();
            Main.main.removeLayer((Layer)this.mapdustLayer);
            this.mapdustLayer = null;
            this.updateView();
            if (wasActive) {
                Main.map.mapView.setActiveLayer((Layer)this.getMapdustLayer());
            }
        }
    }

    public void activeLayerChange(Layer arg0, Layer arg1) {
    }

    public void layerAdded(Layer layer) {
        if (layer instanceof MapdustLayer) {
            this.updateData();
        }
    }

    public void layerRemoved(Layer layer) {
        if (layer instanceof MapdustLayer) {
            MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
            MapView.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
            Main.map.mapView.removeLayer(layer);
            Main.map.remove((Component)((Object)this.mapdustGUI));
            if (this.mapdustGUI != null) {
                this.mapdustGUI.update(null, this);
            }
            this.mapdustLayer = null;
            this.wasEmpty = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.mapdustLayer != null && this.mapdustLayer.isVisible() && Main.map.mapView.getActiveLayer() == this.getMapdustLayer()) {
            Point p;
            MapdustBug nearestBug;
            if (event.getButton() == 3 && event.getClickCount() == 2) {
                String mapdustAddBug = Main.pref.get("mapdust.addBug");
                boolean addBug = Boolean.parseBoolean(mapdustAddBug);
                if (!addBug) {
                    this.mapdustGUI.getPanel().getBtnPanel().getBtnWorkOffline().setEnabled(false);
                    this.mapdustGUI.getPanel().getBtnPanel().getBtnRefresh().setEnabled(false);
                    this.mapdustGUI.getPanel().getBtnPanel().getBtnAddComment().setEnabled(false);
                    this.mapdustGUI.getPanel().getBtnPanel().getBtnFixBugReport().setEnabled(false);
                    this.mapdustGUI.getPanel().getBtnPanel().getBtnInvalidateBugReport().setEnabled(false);
                    this.mapdustGUI.getPanel().getBtnPanel().getBtnReOpenBugReport().setEnabled(false);
                    Main.pref.put("mapdust.modify", true);
                    MapdustBug selectedBug = this.mapdustGUI.getPanel().getSelectedBug();
                    if (selectedBug != null) {
                        Main.pref.put("selectedBug.status", selectedBug.getStatus().getValue());
                    } else {
                        Main.pref.put("selectedBug.status", "create");
                    }
                    String title = "Create bug report";
                    String iconName = "dialogs/open.png";
                    String messageText = "In order to create a new bug report you";
                    messageText = messageText + " need to provide your nickname and a brief";
                    messageText = messageText + " description for the bug.";
                    Point point = event.getPoint();
                    CreateIssueDialog dialog = new CreateIssueDialog(I18n.tr((String)title), iconName, I18n.tr((String)messageText), point, this);
                    dialog.setLocationRelativeTo(null);
                    dialog.getContentPane().setPreferredSize(dialog.getSize());
                    dialog.pack();
                    dialog.setVisible(true);
                } else {
                    Main.pref.put("mapdust.addBug", false);
                }
            }
            if (event.getButton() == 1 && (nearestBug = this.getNearestBug(p = event.getPoint())) != null) {
                this.mapdustLayer.setBugSelected(nearestBug);
                this.mapdustGUI.getPanel().setSelectedBug(nearestBug);
                Main.map.mapView.repaint();
            }
        }
    }

    private void updateView() {
        this.mapdustGUI.update(this.mapdustBugList, this);
        this.mapdustGUI.revalidate();
        if (this.mapdustLayer == null) {
            this.mapdustLayer = new MapdustLayer("MapDust", this.mapdustGUI, this.mapdustBugList);
            Main.main.addLayer((Layer)this.mapdustLayer);
            Main.map.mapView.moveLayer((Layer)this.mapdustLayer, 0);
            Main.map.mapView.addMouseListener((MouseListener)this);
            MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
            MapView.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
        } else {
            this.mapdustLayer.destroy();
            this.mapdustLayer.setMapdustGUI(this.mapdustGUI);
            this.mapdustLayer.setMapdustBugList(this.mapdustBugList);
            this.mapdustLayer.setBugSelected(null);
        }
        Main.map.mapView.revalidate();
        Main.map.repaint();
    }

    @Override
    public void initialUpdate() {
        if (this.containsOsmDataLayer()) {
            this.updateData();
        }
    }

    public void zoomChanged() {
        this.updateData();
    }

    private boolean containsOsmDataLayer() {
        boolean contains = false;
        List l = Main.map.mapView.getAllLayersAsList();
        for (Layer ll : l) {
            if (!(ll instanceof OsmDataLayer)) continue;
            contains = true;
        }
        return contains;
    }

    private void updateMapdustBugList(MapdustBug mapdustBug) {
        MapdustBug oldBug = null;
        for (MapdustBug bug : this.mapdustBugList) {
            if (!bug.getId().equals(mapdustBug.getId())) continue;
            oldBug = bug;
        }
        if (oldBug != null) {
            this.mapdustBugList.remove(oldBug);
            this.mapdustBugList.add(0, mapdustBug);
        } else {
            this.mapdustBugList.add(0, mapdustBug);
        }
    }

    private List<MapdustBug> getMapdustBugs() throws MapdustServiceHandlerException {
        MapView mapView = Main.map.mapView;
        Bounds bounds = new Bounds(mapView.getLatLon(0, mapView.getHeight()), mapView.getLatLon(mapView.getWidth(), 0));
        Double minLon = bounds.getMin().lon();
        Double minLat = bounds.getMin().lat();
        Double maxLon = bounds.getMax().lon();
        Double maxLat = bounds.getMax().lat();
        MapdustServiceHandler handler = new MapdustServiceHandler();
        List<MapdustBug> list = handler.getBugs(minLon, minLat, maxLon, maxLat);
        return list;
    }

    private MapdustBug getNearestBug(Point p) {
        double snapDistance = 10.0;
        double minDistanceSq = Double.MAX_VALUE;
        MapdustBug nearestBug = null;
        for (MapdustBug bug : this.mapdustBugList) {
            Point sp = Main.map.mapView.getPoint(bug.getLatLon());
            double dist = p.distanceSq(sp);
            if (minDistanceSq > dist && p.distance(sp) < snapDistance) {
                minDistanceSq = p.distanceSq(sp);
                nearestBug = bug;
                continue;
            }
            if (minDistanceSq != dist) continue;
            nearestBug = bug;
        }
        return nearestBug;
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public MapdustGUI getMapdustGUI() {
        return this.mapdustGUI;
    }

    public void setMapdustGUI(MapdustGUI mapdustGUI) {
        this.mapdustGUI = mapdustGUI;
    }

    public MapdustLayer getMapdustLayer() {
        return this.mapdustLayer;
    }

    public void setMapdustLayer(MapdustLayer mapdustLayer) {
        this.mapdustLayer = mapdustLayer;
    }

    public List<MapdustBug> getMapdustBugList() {
        return this.mapdustBugList;
    }

    public void setMapdustBugList(List<MapdustBug> mapdustBugList) {
        this.mapdustBugList = mapdustBugList;
    }
}

