/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust;

import java.awt.geom.Point2D;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;

public class MapdustDownloadThread
extends Thread {
    private static MapdustDownloadThread instance;
    private boolean downloadDone = false;
    private final long INTERVAL = TimeUnit.MINUTES.toMillis(30L);
    private MapdustPlugin plugin;
    private Point2D lastCenter;

    public MapdustDownloadThread() {
        this.setName("Downloading Mapdust data!");
        this.start();
    }

    public static synchronized MapdustDownloadThread getInstance() {
        if (instance == null) {
            instance = new MapdustDownloadThread();
        }
        return instance;
    }

    public void run() {
        try {
            while (true) {
                EastNorth currentCenter;
                if (Main.map != null && Main.map.mapView != null && (currentCenter = Main.map.mapView.getCenter()) != null && !currentCenter.equals(this.lastCenter)) {
                    this.downloadDone = false;
                    this.lastCenter = currentCenter;
                }
                String pluginState = Main.pref.get("mapdust.pluginState");
                boolean modify = Boolean.parseBoolean(Main.pref.get("mapdust.modify"));
                if (!this.downloadDone && this.plugin != null && pluginState.equals(MapdustPluginState.ONLINE.getValue()) && !modify) {
                    this.plugin.updateData();
                    this.downloadDone = true;
                }
                Thread.sleep(this.INTERVAL);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public MapdustPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(MapdustPlugin plugin) {
        this.plugin = plugin;
    }
}

