/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.alignways;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.alignways.AlignWaysRotateCommand;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSegmentMgr;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignWaysAction
extends JosmAction {
    private static final long serialVersionUID = -1540319652562985458L;

    public AlignWaysAction() {
        super(I18n.tr((String)"Align Way Segments"), "alignways", I18n.tr((String)"Makes a pair of selected way segments parallel by rotating one of them around a chosen pivot."), Shortcut.registerShortcut((String)"tools:alignways", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Align Ways")}), (int)73, (int)3), true);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        Command c;
        if (!this.isEnabled()) {
            return;
        }
        if (this.getCurrentDataSet() == null) {
            return;
        }
        Collection<Node> affectedNodes = AlignWaysSegmentMgr.getInstance(Main.map.mapView).getSelectedNodes();
        Command command = c = !Main.main.undoRedo.commands.isEmpty() ? (Command)Main.main.undoRedo.commands.getLast() : null;
        if (!(c instanceof AlignWaysRotateCommand && ((Object)affectedNodes).equals(((AlignWaysRotateCommand)c).getRotatedNodes()) || !this.actionValid((AlignWaysRotateCommand)(c = new AlignWaysRotateCommand()), affectedNodes))) {
            Main.main.undoRedo.add(c);
        }
        Main.map.mapView.repaint();
    }

    private boolean actionValid(AlignWaysRotateCommand c, Collection<Node> affectedNodes) {
        if (!c.areSegsAlignable()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select two segments that don''t share any nodes\n or put the pivot on their common node.\n"), I18n.tr((String)"AlignWayS: Alignment not possible"), 2);
            return false;
        }
        for (Node n : affectedNodes) {
            if (!n.getCoor().isOutSideWorld()) continue;
            c.undoCommand();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Aligning would result nodes outside the world.\n"), I18n.tr((String)"AlignWayS: Alignment not possible"), 2);
            return false;
        }
        return true;
    }
}

