/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustAddressPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustBugDetailsPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustCommentsPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustDescriptionPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustHelpPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObserver;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandler;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandlerException;
import org.openstreetmap.josm.plugins.mapdust.service.value.Address;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustComment;

public class MapdustBugPropertiesPanel
extends JPanel
implements MapdustBugDetailsObserver {
    private static final long serialVersionUID = 1L;
    private MapdustCommentsPanel commentsPanel;
    private MapdustBugDetailsPanel detailsPanel;
    private MapdustAddressPanel addressPanel;
    private MapdustDescriptionPanel descriptionPanel;
    private MapdustHelpPanel helpPanel;
    private JScrollPane cmpAddress;
    private JScrollPane cmpDetails;
    private JTabbedPane mainPanel;

    public MapdustBugPropertiesPanel(MapdustBug mapdustBug) {
        this.setLayout(new BorderLayout());
        this.setName("Bug Details");
        this.addComponents(mapdustBug);
    }

    public void showDetails(MapdustBug mapdustBug) {
        MapdustBug selectedBug = mapdustBug;
        if (mapdustBug != null && mapdustBug.getNumberOfComments() > 0) {
            Long id = mapdustBug.getId();
            selectedBug = this.getBug(id);
        }
        int index = -1;
        if (this.mainPanel != null) {
            index = this.mainPanel.getSelectedIndex();
            this.cmpDetails.remove(this.detailsPanel);
            this.mainPanel.remove(this.cmpDetails);
            this.mainPanel.remove(this.cmpAddress);
            this.mainPanel.remove(this.descriptionPanel);
            this.mainPanel.remove(this.commentsPanel);
            this.mainPanel.remove(this.helpPanel);
            this.remove(this.mainPanel);
        }
        this.createPanels(selectedBug);
        if (index != -1) {
            this.mainPanel.setSelectedIndex(index);
        }
    }

    private void addComponents(MapdustBug mapdustBug) {
        MapdustBug selectedBug = mapdustBug;
        if (mapdustBug != null) {
            if (mapdustBug.getNumberOfComments() > 0) {
                Long id = mapdustBug.getId();
                selectedBug = this.getBug(id);
            }
            this.createPanels(selectedBug);
        }
    }

    private void createPanels(MapdustBug mapdustBug) {
        this.detailsPanel = new MapdustBugDetailsPanel(mapdustBug);
        this.cmpDetails = ComponentUtil.createJScrollPane(this.detailsPanel, this.getBounds(), this.getBackground(), true, true);
        this.cmpDetails.setPreferredSize(new Dimension(100, 100));
        this.cmpDetails.setName("Bug Details");
        Address address = mapdustBug != null ? mapdustBug.getAddress() : null;
        LatLon coordinates = mapdustBug != null ? mapdustBug.getLatLon() : null;
        this.addressPanel = new MapdustAddressPanel(address, coordinates);
        this.cmpAddress = ComponentUtil.createJScrollPane(this.addressPanel, this.getBounds(), this.getBackground(), true, true);
        this.cmpAddress.setName("Address");
        this.cmpAddress.setPreferredSize(new Dimension(100, 100));
        String description = mapdustBug != null ? mapdustBug.getDescription() : "";
        this.descriptionPanel = new MapdustDescriptionPanel(description);
        MapdustComment[] comments = mapdustBug != null ? mapdustBug.getComments() : new MapdustComment[]{};
        this.commentsPanel = new MapdustCommentsPanel(comments);
        this.helpPanel = new MapdustHelpPanel();
        this.mainPanel = new JTabbedPane();
        this.mainPanel.setIgnoreRepaint(true);
        this.mainPanel.add((Component)this.cmpDetails, 0);
        this.mainPanel.add((Component)this.cmpAddress, 1);
        this.mainPanel.add((Component)this.descriptionPanel, 2);
        this.mainPanel.add((Component)this.commentsPanel, 3);
        this.mainPanel.add(this.helpPanel);
        this.add((Component)this.mainPanel, "Center");
    }

    private MapdustBug getBug(Long id) {
        MapdustBug bug = null;
        try {
            bug = new MapdustServiceHandler().getBug(id, null);
        }
        catch (MapdustServiceHandlerException mapdustServiceHandlerException) {
            // empty catch block
        }
        return bug;
    }
}

