/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.text.DateFormat;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapdustLayer
extends Layer {
    private MapdustGUI mapdustGUI;
    private List<MapdustBug> mapdustBugList;
    private MapdustBug bugSelected;

    public MapdustLayer(String name, MapdustGUI mapdustGUI, List<MapdustBug> mapdustBugList) {
        super(name);
        this.mapdustGUI = mapdustGUI;
        this.mapdustBugList = mapdustBugList;
        this.bugSelected = null;
    }

    public Icon getIcon() {
        ImageIcon layerIcon = ImageProvider.get((String)"dialogs/mapdust_icon16.png");
        return layerIcon;
    }

    public Object getInfoComponent() {
        String infoComponent = "Shows the Mapdust bug reporter issues.";
        return I18n.tr((String)infoComponent);
    }

    public Action[] getMenuEntries() {
        Action[] menuEntries = new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
        return menuEntries;
    }

    public String getToolTipText() {
        String toolTipText = "Shows Mapdust bug reporter issues.";
        return I18n.tr((String)toolTipText);
    }

    private ImageIcon getImageIcon(String iconType, String status, String bugType) {
        String iconName = "bugs/" + iconType + "/";
        iconName = iconName + status.toLowerCase() + "_";
        iconName = iconName + bugType;
        iconName = iconName + ".png";
        ImageIcon icon = ImageProvider.get((String)iconName);
        return icon;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        JToolTip tooltip = new JToolTip();
        if (this.mapdustBugList != null) {
            int height;
            int width;
            ImageIcon icon;
            String type;
            String status;
            Point p;
            LatLon ll;
            for (MapdustBug bug : this.mapdustBugList) {
                ll = bug.getLatLon();
                p = mv.getPoint(ll);
                status = bug.getStatus().getValue();
                type = bug.getType().getKey();
                icon = this.getImageIcon("normal", status, type);
                width = icon.getIconWidth();
                height = icon.getIconHeight();
                for (int i = 0; i < 2; ++i) {
                    g.drawImage(icon.getImage(), p.x - width / 2, p.y - height / 2, new ImageObserver(){

                        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                            return false;
                        }
                    });
                }
            }
            MapdustBug bug1 = this.getBugSelected();
            MapdustBug bugSelected = this.getMapdustGUI().getPanel().getSelectedBug();
            if (bugSelected == null && Main.map.mapView.getActiveLayer() == this) {
                bugSelected = bug1;
            }
            if (bugSelected != null) {
                ll = bugSelected.getLatLon();
                p = mv.getPoint(ll);
                status = bugSelected.getStatus().getValue();
                type = bugSelected.getType().getKey();
                icon = this.getImageIcon("selected", status, type);
                width = icon.getIconWidth();
                height = icon.getIconHeight();
                g.drawImage(icon.getImage(), p.x - width / 2, p.y - height / 2, new ImageObserver(){

                    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                        return false;
                    }
                });
                String text = this.buildTooltipText(bugSelected);
                tooltip.setTipText(text);
                tooltip.setFont(new Font("Times New Roman", 1, 12));
                tooltip.setBackground(Color.WHITE);
                tooltip.setForeground(Color.BLUE);
                tooltip.setLocation(p);
                tooltip.setFocusable(true);
                int tx = p.x + width / 4;
                int ty = p.y + height / 4;
                g.translate(tx, ty);
                Dimension d = tooltip.getUI().getPreferredSize(tooltip);
                d.width = Math.min(d.width, mv.getWidth() * 2 / 3);
                tooltip.setSize(d);
                tooltip.paint(g);
                g.translate(-tx, -ty);
            }
        }
    }

    public boolean isMergable(Layer layer) {
        return false;
    }

    public void mergeFrom(Layer layer) {
    }

    private String buildTooltipText(MapdustBug bug) {
        DateFormat df = DateFormat.getDateInstance(2, Locale.getDefault());
        String text = "<html>Type: " + bug.getType().getValue() + "<br/>";
        text = text + "Status: " + bug.getStatus().getValue() + "<br/>";
        text = text + "Address: " + bug.getAddress() + " <br/>";
        text = text + "Created by: " + bug.getNickname() + "<br/>";
        text = text + "Created on: " + df.format(bug.getDateCreated()) + "<br/>";
        text = text + "Last modified on: ";
        text = text + df.format(bug.getDateUpdated()) + "<br/>";
        text = text + "Comments: " + bug.getNumberOfComments();
        text = text + "</html>";
        return text;
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
    }

    public MapdustGUI getMapdustGUI() {
        return this.mapdustGUI;
    }

    public void setMapdustGUI(MapdustGUI mapdustGUI) {
        this.mapdustGUI = mapdustGUI;
    }

    public List<MapdustBug> getMapdustBugList() {
        return this.mapdustBugList;
    }

    public MapdustBug getBugSelected() {
        return this.bugSelected;
    }

    public void setBugSelected(MapdustBug bugSelected) {
        this.bugSelected = bugSelected;
    }

    public void setMapdustBugList(List<MapdustBug> mapdustBugList) {
        this.mapdustBugList = mapdustBugList;
    }
}

