/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery.wms;

import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.io.CacheFiles;
import org.openstreetmap.josm.plugins.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.imagery.wms.Grabber;
import org.openstreetmap.josm.plugins.imagery.wms.HTMLGrabber;
import org.openstreetmap.josm.plugins.imagery.wms.WMSGrabber;
import org.openstreetmap.josm.plugins.imagery.wms.WMSLayer;
import org.openstreetmap.josm.plugins.imagery.wms.io.WMSLayerExporter;
import org.openstreetmap.josm.plugins.imagery.wms.io.WMSLayerImporter;

public class WMSAdapter {
    CacheFiles cache = new CacheFiles("wmsplugin");
    public final StringProperty PROP_BROWSER = new StringProperty("imagery.wms.browser", "webkit-image {0}");
    public final IntegerProperty PROP_SIMULTANEOUS_CONNECTIONS = new IntegerProperty("imagery.wms.simultaneousConnections", 3);
    public final BooleanProperty PROP_OVERLAP = new BooleanProperty("imagery.wms.overlap", false);
    public final IntegerProperty PROP_OVERLAP_EAST = new IntegerProperty("imagery.wms.overlapEast", 14);
    public final IntegerProperty PROP_OVERLAP_NORTH = new IntegerProperty("imagery.wms.overlapNorth", 4);

    protected void initExporterAndImporter() {
        ExtensionFileFilter.exporters.add(new WMSLayerExporter());
        ExtensionFileFilter.importers.add(new WMSLayerImporter());
    }

    public WMSAdapter() {
        this.cache.setExpire(2419200, false);
        this.cache.setMaxSize(70, false);
        this.initExporterAndImporter();
    }

    public Grabber getGrabber(MapView mv, WMSLayer layer) {
        if (layer.getInfo().getImageryType() == ImageryInfo.ImageryType.HTML) {
            return new HTMLGrabber(mv, layer, this.cache);
        }
        if (layer.getInfo().getImageryType() == ImageryInfo.ImageryType.WMS) {
            return new WMSGrabber(mv, layer, this.cache);
        }
        throw new IllegalStateException("WMSAdapter.getGrabber() called for non-WMS layer type");
    }
}

