/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery.tms;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.imagery.ImageryLayer;
import org.openstreetmap.josm.plugins.imagery.ImageryPreferences;
import org.openstreetmap.josm.plugins.imagery.tms.TMSPreferences;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMSLayer
extends ImageryLayer
implements ImageObserver,
TileLoaderListener {
    boolean debug = false;
    protected MemoryTileCache tileCache;
    protected TileSource tileSource;
    protected TileLoader tileLoader;
    JobDispatcher jobDispatcher = JobDispatcher.getInstance();
    HashSet<Tile> tileRequestsOutstanding = new HashSet();
    public int currentZoomLevel;
    private Tile clickedTile;
    private JPopupMenu tileOptionMenu;
    JCheckBoxMenuItem autoZoomPopup;
    JCheckBoxMenuItem autoLoadPopup;
    Tile showMetadataTile;
    private Image attrImage;
    private String attrTermsUrl;
    private Rectangle attrImageBounds;
    private Rectangle attrToUBounds;
    private static final Font ATTR_FONT = new Font("Arial", 0, 10);
    private static final Font ATTR_LINK_FONT;
    protected boolean autoZoom;
    protected boolean autoLoad;
    Image lastScaledImage = null;
    Double lastImageScale = null;
    boolean az_disable = false;

    void out(String s) {
        Main.debug((String)s);
    }

    public synchronized void tileLoadingFinished(Tile tile, boolean success) {
        tile.setLoaded(true);
        Main.map.repaint(100L);
        this.tileRequestsOutstanding.remove(tile);
        if (this.sharpenLevel != 0) {
            tile.setImage(this.sharpenImage(tile.getImage()));
        }
        if (this.debug) {
            this.out("tileLoadingFinished() tile: " + tile + " success: " + success);
        }
    }

    public TileCache getTileCache() {
        return this.tileCache;
    }

    void clearTileCache() {
        if (this.debug) {
            this.out("clearing tile storage");
        }
        this.tileCache = new MemoryTileCache();
        this.tileCache.setCacheSize(200);
    }

    void redraw() {
        Main.map.repaint();
    }

    private void initTileSource(TileSource tileSource) {
        this.tileSource = tileSource;
        boolean requireAttr = tileSource.requiresAttribution();
        if (requireAttr) {
            this.attrImage = tileSource.getAttributionImage();
            if (this.attrImage == null) {
                System.out.println("Attribution image was null.");
            } else {
                System.out.println("Got an attribution image " + this.attrImage.getHeight(this) + "x" + this.attrImage.getWidth(this));
            }
            this.attrTermsUrl = tileSource.getTermsOfUseURL();
        }
        this.currentZoomLevel = this.getBestZoom();
        if (this.currentZoomLevel > this.getMaxZoomLvl()) {
            this.currentZoomLevel = this.getMaxZoomLvl();
        }
        if (this.currentZoomLevel < this.getMinZoomLvl()) {
            this.currentZoomLevel = this.getMinZoomLvl();
        }
        this.clearTileCache();
        this.tileLoader = new OsmFileCacheTileLoader((TileLoaderListener)this);
    }

    private double getPPDeg() {
        return (double)this.mv.getWidth() / (this.mv.getLatLon(this.mv.getWidth(), this.mv.getHeight() / 2).lon() - this.mv.getLatLon(0, this.mv.getHeight() / 2).lon());
    }

    private int getBestZoom() {
        double ret = Math.log(this.getPPDeg() * 360.0 / (double)this.tileSource.getTileSize()) / Math.log(2.0);
        System.out.println("Detected best zoom " + ret);
        return (int)Math.round(ret);
    }

    public TMSLayer(ImageryInfo info) {
        super(info);
        this.setBackgroundLayer(true);
        this.setVisible(true);
        TileSource source = TMSPreferences.getTileSource(info);
        if (source == null) {
            throw new IllegalStateException("cannot create TMSLayer with non-TMS ImageryInfo");
        }
        this.initTileSource(source);
        this.tileOptionMenu = new JPopupMenu();
        this.autoZoom = TMSPreferences.PROP_DEFAULT_AUTOZOOM.get();
        this.autoZoomPopup = new JCheckBoxMenuItem();
        this.autoZoomPopup.setAction(new AbstractAction(I18n.tr((String)"Auto Zoom")){

            public void actionPerformed(ActionEvent ae) {
                TMSLayer.this.autoZoom = !TMSLayer.this.autoZoom;
            }
        });
        this.autoZoomPopup.setSelected(this.autoZoom);
        this.tileOptionMenu.add(this.autoZoomPopup);
        this.autoLoad = TMSPreferences.PROP_DEFAULT_AUTOLOAD.get();
        this.autoLoadPopup = new JCheckBoxMenuItem();
        this.autoLoadPopup.setAction(new AbstractAction(I18n.tr((String)"Auto load tiles")){

            public void actionPerformed(ActionEvent ae) {
                TMSLayer.this.autoLoad = !TMSLayer.this.autoLoad;
            }
        });
        this.autoLoadPopup.setSelected(this.autoLoad);
        this.tileOptionMenu.add(this.autoLoadPopup);
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Load Tile")){

            public void actionPerformed(ActionEvent ae) {
                if (TMSLayer.this.clickedTile != null) {
                    TMSLayer.this.loadTile(TMSLayer.this.clickedTile);
                    TMSLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Show Tile Info")){

            public void actionPerformed(ActionEvent ae) {
                TMSLayer.this.out("info tile: " + TMSLayer.this.clickedTile);
                if (TMSLayer.this.clickedTile != null) {
                    TMSLayer.this.showMetadataTile = TMSLayer.this.clickedTile;
                    TMSLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Load All Tiles")){

            public void actionPerformed(ActionEvent ae) {
                TMSLayer.this.loadAllTiles(true);
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Increase zoom")){

            public void actionPerformed(ActionEvent ae) {
                TMSLayer.this.increaseZoomLevel();
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Decrease zoom")){

            public void actionPerformed(ActionEvent ae) {
                TMSLayer.this.decreaseZoomLevel();
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Snap to tile size")){

            public void actionPerformed(ActionEvent ae) {
                if (TMSLayer.this.lastImageScale == null) {
                    TMSLayer.this.out("please wait for a tile to be loaded before snapping");
                    return;
                }
                double new_factor = Math.sqrt(TMSLayer.this.lastImageScale);
                if (TMSLayer.this.debug) {
                    TMSLayer.this.out("tile snap: scale was: " + TMSLayer.this.lastImageScale + ", new factor: " + new_factor);
                }
                Main.map.mapView.zoomToFactor(new_factor);
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr((String)"Flush Tile Cache")){

            public void actionPerformed(ActionEvent ae) {
                System.out.print("flushing all tiles...");
                TMSLayer.this.clearTileCache();
                System.out.println("done");
            }
        }));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.map.mapView.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() == 3) {
                            TMSLayer.this.clickedTile = TMSLayer.this.getTileForPixelpos(e.getX(), e.getY());
                            TMSLayer.this.tileOptionMenu.show(e.getComponent(), e.getX(), e.getY());
                        } else if (e.getButton() == 1) {
                            if (!TMSLayer.this.tileSource.requiresAttribution()) {
                                return;
                            }
                            if (TMSLayer.this.attrImageBounds.contains(e.getPoint())) {
                                try {
                                    Desktop desktop = Desktop.getDesktop();
                                    desktop.browse(new URI(TMSLayer.this.tileSource.getAttributionLinkURL()));
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                                catch (URISyntaxException e1) {
                                    e1.printStackTrace();
                                }
                            } else if (TMSLayer.this.attrToUBounds.contains(e.getPoint())) {
                                try {
                                    Desktop desktop = Desktop.getDesktop();
                                    desktop.browse(new URI(TMSLayer.this.tileSource.getTermsOfUseURL()));
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                                catch (URISyntaxException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                    }
                });
                MapView.addLayerChangeListener((MapView.LayerChangeListener)new MapView.LayerChangeListener(){

                    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                    }

                    public void layerAdded(Layer newLayer) {
                    }

                    public void layerRemoved(Layer oldLayer) {
                        MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
                    }
                });
            }
        });
    }

    void zoomChanged() {
        if (this.debug) {
            this.out("zoomChanged(): " + this.currentZoomLevel);
        }
        this.jobDispatcher.cancelOutstandingJobs();
        this.tileRequestsOutstanding.clear();
    }

    int getMaxZoomLvl() {
        if (this.info.getMaxZoom() != 0) {
            return TMSPreferences.checkMaxZoomLvl(this.info.getMaxZoom(), this.tileSource);
        }
        return TMSPreferences.getMaxZoomLvl(this.tileSource);
    }

    int getMinZoomLvl() {
        return TMSPreferences.getMinZoomLvl(this.tileSource);
    }

    public boolean zoomIncreaseAllowed() {
        boolean zia;
        boolean bl = zia = this.currentZoomLevel < this.getMaxZoomLvl();
        if (this.debug) {
            this.out("zoomIncreaseAllowed(): " + zia + " " + this.currentZoomLevel + " vs. " + this.getMaxZoomLvl());
        }
        return zia;
    }

    public boolean increaseZoomLevel() {
        this.lastImageScale = null;
        if (this.zoomIncreaseAllowed()) {
            ++this.currentZoomLevel;
            if (this.debug) {
                this.out("increasing zoom level to: " + this.currentZoomLevel);
            }
        } else {
            System.err.println("current zoom lvl (" + this.currentZoomLevel + ") couldnt be increased. " + "MaxZoomLvl (" + this.getMaxZoomLvl() + ") reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    public boolean zoomDecreaseAllowed() {
        return this.currentZoomLevel > this.getMinZoomLvl();
    }

    public boolean decreaseZoomLevel() {
        int minZoom = this.getMinZoomLvl();
        this.lastImageScale = null;
        if (this.zoomDecreaseAllowed()) {
            if (this.debug) {
                this.out("decreasing zoom level to: " + this.currentZoomLevel);
            }
            --this.currentZoomLevel;
        } else {
            System.err.println("current zoom lvl couldnt be decreased. MinZoomLvl(" + minZoom + ") reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    synchronized Tile tempCornerTile(Tile t) {
        int zoom;
        int y;
        int x = t.getXtile() + 1;
        Tile tile = this.getTile(x, y = t.getYtile() + 1, zoom = t.getZoom());
        if (tile != null) {
            return tile;
        }
        return new Tile(this.tileSource, x, y, zoom);
    }

    synchronized Tile getOrCreateTile(int x, int y, int zoom) {
        Tile tile = this.getTile(x, y, zoom);
        if (tile == null) {
            tile = new Tile(this.tileSource, x, y, zoom);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache((TileCache)this.tileCache);
        }
        return tile;
    }

    synchronized Tile getTile(int x, int y, int zoom) {
        int max = 1 << zoom;
        if (x < 0 || x >= max || y < 0 || y >= max) {
            return null;
        }
        Tile tile = this.tileCache.getTile(this.tileSource, x, y, zoom);
        return tile;
    }

    synchronized boolean loadTile(Tile tile) {
        if (tile == null) {
            return false;
        }
        if (tile.hasError()) {
            return false;
        }
        if (tile.isLoaded()) {
            return false;
        }
        if (tile.isLoading()) {
            return false;
        }
        if (this.tileRequestsOutstanding.contains(tile)) {
            return false;
        }
        this.tileRequestsOutstanding.add(tile);
        this.jobDispatcher.addJob(this.tileLoader.createTileLoaderJob(this.tileSource, tile.getXtile(), tile.getYtile(), tile.getZoom()));
        return true;
    }

    void loadAllTiles(boolean force) {
        EastNorth botRight;
        MapView mv = Main.map.mapView;
        EastNorth topLeft = mv.getEastNorth(0, 0);
        TileSet ts = new TileSet(topLeft, botRight = mv.getEastNorth(mv.getWidth(), mv.getHeight()), this.currentZoomLevel);
        if (ts.tooLarge()) {
            System.out.println("Not downloading all tiles because there is more than 18 tiles on an axis!");
            return;
        }
        ts.loadAllTiles(force);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean done;
        boolean bl = done = (infoflags & 0x70) != 0;
        if (this.debug) {
            this.out("imageUpdate() done: " + done + " calling repaint");
        }
        Main.map.repaint(done ? 0L : 100L);
        return !done;
    }

    boolean imageLoaded(Image i) {
        if (i == null) {
            return false;
        }
        int status = Toolkit.getDefaultToolkit().checkImage(i, -1, -1, this);
        return (status & 0x20) != 0;
    }

    Image getLoadedTileImage(Tile tile) {
        if (!tile.isLoaded()) {
            return null;
        }
        BufferedImage img = tile.getImage();
        if (!this.imageLoaded(img)) {
            return null;
        }
        return img;
    }

    double getImageScaling(Image img, Rectangle r) {
        int realWidth = -1;
        int realHeight = -1;
        if (img != null) {
            realWidth = img.getHeight(this);
            realWidth = img.getWidth(this);
        }
        if (realWidth == -1 || realHeight == -1) {
            if (this.lastScaledImage != null) {
                return this.getImageScaling(this.lastScaledImage, r);
            }
            realWidth = 256;
            realHeight = 256;
        } else {
            this.lastScaledImage = img;
        }
        double drawWidth = r.width;
        double drawHeight = r.height;
        double drawArea = drawWidth * drawHeight;
        double realArea = realWidth * realHeight;
        return drawArea / realArea;
    }

    LatLon tileLatLon(Tile t) {
        int zoom = t.getZoom();
        return new LatLon(this.tileYToLat(t.getYtile(), zoom), this.tileXToLon(t.getXtile(), zoom));
    }

    int paintFromOtherZooms(Graphics g, Tile topLeftTile, Tile botRightTile) {
        LatLon topLeft = this.tileLatLon(topLeftTile);
        LatLon botRight = this.tileLatLon(botRightTile);
        int[] otherZooms = new int[]{-1, 1, -2, 2, -3, -4, -5};
        int painted = 0;
        this.debug = true;
        for (int zoomOff : otherZooms) {
            int zoom = this.currentZoomLevel + zoomOff;
            if (zoom < this.getMinZoomLvl() || zoom > this.getMaxZoomLvl()) continue;
            TileSet ts = new TileSet(topLeft, botRight, zoom);
            int zoom_painted = 0;
            this.paintTileImages(g, ts, zoom, null);
            if (this.debug && zoom_painted > 0) {
                this.out("painted " + zoom_painted + "/" + ts.size() + " tiles from zoom(" + zoomOff + "): " + zoom);
            }
            painted += zoom_painted;
            if (!((double)zoom_painted >= ts.size())) continue;
            if (!this.debug) break;
            this.out("broke after drawing " + zoom_painted + "/" + ts.size() + " at zoomOff: " + zoomOff);
            break;
        }
        this.debug = false;
        return painted;
    }

    Rectangle tileToRect(Tile t1) {
        Tile t2 = this.tempCornerTile(t1);
        Rectangle rect = new Rectangle(this.pixelPos(t1));
        rect.add(this.pixelPos(t2));
        return rect;
    }

    void drawImageInside(Graphics g, Image sourceImg, Rectangle source, Rectangle border) {
        Rectangle target = source;
        if (border != null) {
            target = source.intersection(border);
            if (this.debug) {
                this.out("source: " + source + "\nborder: " + border + "\nintersection: " + target);
            }
        }
        double imageYScaling = (double)sourceImg.getHeight(this) / source.getHeight();
        double imageXScaling = (double)sourceImg.getWidth(this) / source.getWidth();
        int screen_x_offset = target.x - source.x;
        int screen_y_offset = target.y - source.y;
        int img_x_offset = (int)((double)screen_x_offset * imageXScaling);
        int img_y_offset = (int)((double)screen_y_offset * imageYScaling);
        int img_x_end = img_x_offset + (int)(target.getWidth() * imageXScaling);
        int img_y_end = img_y_offset + (int)(target.getHeight() * imageYScaling);
        if (this.debug) {
            this.out("drawing image into target rect: " + target);
        }
        g.drawImage(sourceImg, target.x, target.y, target.x + target.width, target.y + target.height, img_x_offset, img_y_offset, img_x_end, img_y_end, this);
        if (ImageryPreferences.PROP_FADE_AMOUNT.get() != 0) {
            g.setColor(ImageryPreferences.getFadeColorWithAlpha());
            g.fillRect(target.x, target.y, target.width, target.height);
        }
    }

    List<Tile> paintTileImages(Graphics g, TileSet ts, int zoom, Tile border) {
        Rectangle borderRect = null;
        if (border != null) {
            borderRect = this.tileToRect(border);
        }
        LinkedList<Tile> missedTiles = new LinkedList<Tile>();
        boolean imageScaleRecorded = false;
        for (Tile tile : ts.allTiles()) {
            Image img = this.getLoadedTileImage(tile);
            if (img == null) {
                if (this.debug) {
                    this.out("missed tile: " + tile);
                }
                missedTiles.add(tile);
                continue;
            }
            Rectangle sourceRect = this.tileToRect(tile);
            if (borderRect != null && !sourceRect.intersects(borderRect)) continue;
            this.drawImageInside(g, img, sourceRect, borderRect);
            if (imageScaleRecorded || zoom != this.currentZoomLevel) continue;
            this.lastImageScale = new Double(this.getImageScaling(img, sourceRect));
            imageScaleRecorded = true;
        }
        return missedTiles;
    }

    void paintTileText(TileSet ts, Tile tile, Graphics g, MapView mv, int zoom, Tile t) {
        String md;
        int fontHeight = g.getFontMetrics().getHeight();
        if (tile == null) {
            return;
        }
        Point p = this.pixelPos(t);
        int texty = p.y + 2 + fontHeight;
        if (TMSPreferences.PROP_DRAW_DEBUG.get()) {
            g.drawString("x=" + t.getXtile() + " y=" + t.getYtile() + " z=" + zoom + "", p.x + 2, texty);
            texty += 1 + fontHeight;
            if (t.getXtile() % 32 == 0 && t.getYtile() % 32 == 0) {
                g.drawString("x=" + t.getXtile() / 32 + " y=" + t.getYtile() / 32 + " z=7", p.x + 2, texty);
                texty += 1 + fontHeight;
            }
        }
        if (tile == this.showMetadataTile && (md = tile.toString()) != null) {
            g.drawString(md, p.x + 2, texty);
            texty += 1 + fontHeight;
        }
        String tileStatus = tile.getStatus();
        if (!tile.isLoaded() && TMSPreferences.PROP_DRAW_DEBUG.get()) {
            g.drawString(I18n.tr((String)("image " + tileStatus)), p.x + 2, texty);
            texty += 1 + fontHeight;
        }
        int xCursor = -1;
        int yCursor = -1;
        if (TMSPreferences.PROP_DRAW_DEBUG.get()) {
            if (yCursor < t.getYtile()) {
                if (t.getYtile() % 32 == 31) {
                    g.fillRect(0, p.y - 1, mv.getWidth(), 3);
                } else {
                    g.drawLine(0, p.y, mv.getWidth(), p.y);
                }
                yCursor = t.getYtile();
            }
            if (xCursor < t.getXtile()) {
                if (t.getXtile() % 32 == 0) {
                    g.fillRect(p.x - 1, 0, 3, mv.getHeight());
                } else {
                    g.drawLine(p.x, 0, p.x, mv.getHeight());
                }
                xCursor = t.getXtile();
            }
        }
    }

    private Point pixelPos(LatLon ll) {
        return Main.map.mapView.getPoint(Main.proj.latlon2eastNorth(ll).add(this.getDx(), this.getDy()));
    }

    private Point pixelPos(Tile t) {
        double lon = this.tileXToLon(t.getXtile(), t.getZoom());
        LatLon tmpLL = new LatLon(this.tileYToLat(t.getYtile(), t.getZoom()), lon);
        return this.pixelPos(tmpLL);
    }

    private LatLon getShiftedLatLon(EastNorth en) {
        return Main.proj.eastNorth2latlon(en.add(-this.getDx(), -this.getDy()));
    }

    boolean autoZoomEnabled() {
        if (this.az_disable) {
            return false;
        }
        return this.autoZoom;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        int[] otherZooms;
        EastNorth topLeft = mv.getEastNorth(0, 0);
        EastNorth botRight = mv.getEastNorth(mv.getWidth(), mv.getHeight());
        if (botRight.east() == 0.0 || botRight.north() == 0.0) {
            Main.debug((String)"still initializing??");
            return;
        }
        int zoom = this.currentZoomLevel;
        TileSet ts = new TileSet(topLeft, botRight, zoom);
        if (this.autoZoomEnabled()) {
            if (this.zoomDecreaseAllowed() && ts.tooLarge()) {
                if (this.debug) {
                    this.out("too many tiles, decreasing zoom from " + this.currentZoomLevel);
                }
                if (this.decreaseZoomLevel()) {
                    this.paint(g, mv, bounds);
                }
                return;
            }
            if (this.zoomIncreaseAllowed() && ts.tooSmall()) {
                if (this.debug) {
                    this.out("too zoomed in, (" + ts.tilesSpanned() + "), increasing zoom from " + this.currentZoomLevel);
                }
                boolean tmp = this.az_disable;
                this.az_disable = true;
                if (this.increaseZoomLevel()) {
                    this.paint(g, mv, bounds);
                }
                this.az_disable = tmp;
                return;
            }
        }
        if (!ts.tooLarge()) {
            ts.loadAllTiles(false);
        }
        g.setColor(Color.DARK_GRAY);
        List<Tile> missedTiles = this.paintTileImages(g, ts, this.currentZoomLevel, null);
        for (int zoomOffset : otherZooms = new int[]{-1, 1, -2, 2, -3, -4, -5}) {
            if (!this.autoZoomEnabled() || !this.autoLoad) break;
            int newzoom = this.currentZoomLevel + zoomOffset;
            if (missedTiles.size() <= 0) break;
            LinkedList<Tile> newlyMissedTiles = new LinkedList<Tile>();
            for (Tile missed : missedTiles) {
                LatLon botRight2;
                Tile t2 = this.tempCornerTile(missed);
                LatLon topLeft2 = this.tileLatLon(missed);
                TileSet ts2 = new TileSet(topLeft2, botRight2 = this.tileLatLon(t2), newzoom);
                if (ts2.tooLarge()) continue;
                newlyMissedTiles.addAll(this.paintTileImages(g, ts2, newzoom, missed));
            }
            missedTiles = newlyMissedTiles;
        }
        if (this.debug && missedTiles.size() > 0) {
            this.out("still missed " + missedTiles.size() + " in the end");
        }
        g.setColor(Color.red);
        for (Tile t : ts.allTiles()) {
            this.paintTileText(ts, t, g, mv, this.currentZoomLevel, t);
        }
        if (this.tileSource.requiresAttribution()) {
            Font font = g.getFont();
            g.setFont(ATTR_LINK_FONT);
            Rectangle2D termsStringBounds = g.getFontMetrics().getStringBounds("Background Terms of Use", g);
            int textHeight = (int)termsStringBounds.getHeight() - 5;
            int textWidth = (int)termsStringBounds.getWidth();
            int termsTextY = mv.getHeight() - textHeight;
            if (this.attrTermsUrl != null) {
                int x = 2;
                int y = mv.getHeight() - textHeight;
                this.attrToUBounds = new Rectangle(x, y, textWidth, textHeight);
                g.setColor(Color.black);
                g.drawString("Background Terms of Use", x + 1, y + 1);
                g.setColor(Color.white);
                g.drawString("Background Terms of Use", x, y);
            }
            int imgWidth = this.attrImage.getWidth(this);
            if (this.attrImage != null) {
                int x = 2;
                int height = this.attrImage.getHeight(this);
                int y = termsTextY - height - textHeight - 5;
                this.attrImageBounds = new Rectangle(x, y, imgWidth, height);
                g.drawImage(this.attrImage, x, y, this);
            }
            g.setFont(ATTR_FONT);
            String attributionText = this.tileSource.getAttributionText(this.currentZoomLevel, this.getShiftedLatLon(topLeft), this.getShiftedLatLon(botRight));
            Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(attributionText, g);
            int x = mv.getWidth() - (int)stringBounds.getWidth();
            int y = mv.getHeight() - textHeight;
            g.setColor(Color.black);
            g.drawString(attributionText, x + 1, y + 1);
            g.setColor(Color.white);
            g.drawString(attributionText, x, y);
            g.setFont(font);
        }
        if (this.autoZoomEnabled() && this.lastImageScale != null) {
            if (this.lastImageScale > 3.0 && this.zoomIncreaseAllowed()) {
                if (this.debug) {
                    this.out("autozoom increase: scale: " + this.lastImageScale);
                }
                this.increaseZoomLevel();
                this.paint(g, mv, bounds);
            } else if (this.lastImageScale < 0.45 && this.lastImageScale > 0.0 && this.zoomDecreaseAllowed()) {
                if (this.debug) {
                    this.out("autozoom decrease: scale: " + this.lastImageScale);
                }
                this.decreaseZoomLevel();
                this.paint(g, mv, bounds);
            }
        }
        g.setColor(Color.black);
        if (ts.insane()) {
            g.drawString("zoom in to load any tiles", 120, 120);
        } else if (ts.tooLarge()) {
            g.drawString("zoom in to load more tiles", 120, 120);
        } else if (ts.tooSmall()) {
            g.drawString("increase zoom level to see more detail", 120, 120);
        }
    }

    Tile getTileForPixelpos(int px, int py) {
        int z;
        EastNorth botRight;
        if (this.debug) {
            this.out("getTileForPixelpos(" + px + ", " + py + ")");
        }
        MapView mv = Main.map.mapView;
        Point clicked = new Point(px, py);
        EastNorth topLeft = mv.getEastNorth(0, 0);
        TileSet ts = new TileSet(topLeft, botRight = mv.getEastNorth(mv.getWidth(), mv.getHeight()), z = this.currentZoomLevel);
        if (!ts.tooLarge()) {
            ts.loadAllTiles(false);
        }
        Tile clickedTile = null;
        for (Tile t1 : ts.allTiles()) {
            Tile t2 = this.tempCornerTile(t1);
            Rectangle r = new Rectangle(this.pixelPos(t1));
            r.add(this.pixelPos(t2));
            if (this.debug) {
                this.out("r: " + r + " clicked: " + clicked);
            }
            if (!r.contains(clicked)) continue;
            clickedTile = t1;
            break;
        }
        if (clickedTile == null) {
            return null;
        }
        System.out.println("clicked on tile: " + clickedTile.getXtile() + " " + clickedTile.getYtile() + " scale: " + this.lastImageScale + " currentZoomLevel: " + this.currentZoomLevel);
        return clickedTile;
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new ImageryLayer.OffsetAction(), new RenameLayerAction(this.getAssociatedFile(), (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public String getToolTipText() {
        return null;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    private int latToTileY(double lat, int zoom) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return (int)(Math.pow(2.0, zoom - 1) * (Math.PI - pf) / Math.PI);
    }

    private int lonToTileX(double lon, int zoom) {
        return (int)(Math.pow(2.0, zoom - 3) * (lon + 180.0) / 45.0);
    }

    private double tileYToLat(int y, int zoom) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)y / Math.pow(2.0, zoom - 1))) * 180.0 / Math.PI;
    }

    private double tileXToLon(int x, int zoom) {
        return (double)x * 45.0 / Math.pow(2.0, zoom - 3) - 180.0;
    }

    static {
        HashMap<TextAttribute, Integer> aUnderline = new HashMap<TextAttribute, Integer>();
        aUnderline.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        ATTR_LINK_FONT = ATTR_FONT.deriveFont(aUnderline);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TileSet {
        int z12x0;
        int z12x1;
        int z12y0;
        int z12y1;
        int zoom;
        int tileMax = -1;

        TileSet(EastNorth topLeft, EastNorth botRight, int zoom) {
            this(tMSLayer.getShiftedLatLon(topLeft), tMSLayer.getShiftedLatLon(botRight), zoom);
        }

        TileSet(LatLon topLeft, LatLon botRight, int zoom) {
            int tmp;
            this.zoom = zoom;
            this.z12x0 = TMSLayer.this.lonToTileX(topLeft.lon(), zoom);
            this.z12y0 = TMSLayer.this.latToTileY(topLeft.lat(), zoom);
            this.z12x1 = TMSLayer.this.lonToTileX(botRight.lon(), zoom);
            this.z12y1 = TMSLayer.this.latToTileY(botRight.lat(), zoom);
            if (this.z12x0 > this.z12x1) {
                tmp = this.z12x0;
                this.z12x0 = this.z12x1;
                this.z12x1 = tmp;
            }
            if (this.z12y0 > this.z12y1) {
                tmp = this.z12y0;
                this.z12y0 = this.z12y1;
                this.z12y1 = tmp;
            }
            this.tileMax = (int)Math.pow(2.0, zoom);
            if (this.z12x0 < 0) {
                this.z12x0 = 0;
            }
            if (this.z12y0 < 0) {
                this.z12y0 = 0;
            }
            if (this.z12x1 > this.tileMax) {
                this.z12x1 = this.tileMax;
            }
            if (this.z12y1 > this.tileMax) {
                this.z12y1 = this.tileMax;
            }
        }

        boolean tooSmall() {
            return this.tilesSpanned() < 2.1;
        }

        boolean tooLarge() {
            return this.tilesSpanned() > 10.0;
        }

        boolean insane() {
            return this.tilesSpanned() > 100.0;
        }

        double tilesSpanned() {
            return Math.sqrt(1.0 * this.size());
        }

        double size() {
            double x_span = (double)(this.z12x1 - this.z12x0) + 1.0;
            double y_span = (double)(this.z12y1 - this.z12y0) + 1.0;
            return x_span * y_span;
        }

        List<Tile> allTiles() {
            return this.allTiles(false);
        }

        private List<Tile> allTiles(boolean create) {
            ArrayList<Tile> ret = new ArrayList<Tile>();
            if (this.insane()) {
                return ret;
            }
            for (int x = this.z12x0; x <= this.z12x1; ++x) {
                for (int y = this.z12y0; y <= this.z12y1; ++y) {
                    Tile t = create ? TMSLayer.this.getOrCreateTile(x % this.tileMax, y % this.tileMax, this.zoom) : TMSLayer.this.getTile(x % this.tileMax, y % this.tileMax, this.zoom);
                    if (t == null) continue;
                    ret.add(t);
                }
            }
            return ret;
        }

        void loadAllTiles(boolean force) {
            List<Tile> tiles = this.allTiles(true);
            if (!TMSLayer.this.autoLoad && !force) {
                return;
            }
            int nr_queued = 0;
            for (Tile t : tiles) {
                if (!TMSLayer.this.loadTile(t)) continue;
                ++nr_queued;
            }
            if (TMSLayer.this.debug && nr_queued > 0) {
                TMSLayer.this.out("queued to load: " + nr_queued + "/" + tiles.size() + " tiles at zoom: " + this.zoom);
            }
        }
    }
}

