/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.plugins.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.plugins.imagery.wms.AddWMSLayerPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ImageryProvidersPanel
extends JPanel {
    final ImageryLayerTableModel model;
    private final ImageryLayerInfo layerInfo;

    public ImageryProvidersPanel(final PreferenceTabbedPane gui, ImageryLayerInfo layerInfo) {
        super(new GridBagLayout());
        this.layerInfo = layerInfo;
        this.model = new ImageryLayerTableModel();
        final JTable list = new JTable(this.model){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                return ImageryProvidersPanel.this.model.getValueAt(this.rowAtPoint(p), this.columnAtPoint(p)).toString();
            }
        };
        JScrollPane scroll = new JScrollPane(list);
        this.add((Component)scroll, GBC.eol().fill(1));
        scroll.setPreferredSize(new Dimension(200, 200));
        final ImageryDefaultLayerTableModel modeldef = new ImageryDefaultLayerTableModel();
        final JTable listdef = new JTable(modeldef){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                return (String)modeldef.getValueAt(this.rowAtPoint(p), this.columnAtPoint(p));
            }
        };
        JScrollPane scrolldef = new JScrollPane(listdef);
        scrolldef.setPreferredSize(new Dimension(200, 200));
        TableColumnModel mod = listdef.getColumnModel();
        mod.getColumn(1).setPreferredWidth(800);
        mod.getColumn(0).setPreferredWidth(200);
        mod = list.getColumnModel();
        mod.getColumn(2).setPreferredWidth(50);
        mod.getColumn(1).setPreferredWidth(800);
        mod.getColumn(0).setPreferredWidth(200);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton add = new JButton(I18n.tr((String)"Add"));
        buttonPanel.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddWMSLayerPanel p = new AddWMSLayerPanel();
                int answer = JOptionPane.showConfirmDialog((Component)gui, p, I18n.tr((String)"Add Imagery URL"), 2);
                if (answer == 0) {
                    ImageryProvidersPanel.this.model.addRow(new ImageryInfo(p.getUrlName(), p.getUrl()));
                }
            }
        });
        JButton delete = new JButton(I18n.tr((String)"Delete"));
        buttonPanel.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (list.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select the row to delete."));
                } else {
                    Integer i;
                    while ((i = Integer.valueOf(list.getSelectedRow())) != -1) {
                        ImageryProvidersPanel.this.model.removeRow(i);
                    }
                }
            }
        });
        JButton copy = new JButton(I18n.tr((String)"Copy Selected Default(s)"));
        buttonPanel.add((Component)copy, GBC.std().insets(0, 5, 0, 0));
        copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] lines = listdef.getSelectedRows();
                if (lines.length == 0) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select at least one row to copy."), I18n.tr((String)"Information"), 1);
                    return;
                }
                block0: for (int i = 0; i < lines.length; ++i) {
                    ImageryInfo info = modeldef.getRow(lines[i]);
                    for (int j = 0; j < ImageryProvidersPanel.this.model.getRowCount(); ++j) {
                        if (!info.equalsBaseValues(ImageryProvidersPanel.this.model.getRow(j))) continue;
                        list.getSelectionModel().setSelectionInterval(j, j);
                        list.scrollRectToVisible(list.getCellRect(j, 0, true));
                        continue block0;
                    }
                    if (info.eulaAcceptanceRequired != null && !ImageryProvidersPanel.this.confirmEulaAcceptance(gui, info.eulaAcceptanceRequired)) continue;
                    ImageryProvidersPanel.this.model.addRow(new ImageryInfo(info));
                    int lastLine = ImageryProvidersPanel.this.model.getRowCount() - 1;
                    list.getSelectionModel().setSelectionInterval(lastLine, lastLine);
                    list.scrollRectToVisible(list.getCellRect(lastLine, 0, true));
                }
            }
        });
        this.add(buttonPanel);
        this.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        this.add((Component)scrolldef, GBC.eol().insets(0, 5, 0, 0).fill(1));
    }

    private boolean confirmEulaAcceptance(PreferenceTabbedPane gui, String eulaUrl) {
        URL url = null;
        try {
            url = new URL(eulaUrl.replaceAll("\\{lang\\}", Locale.getDefault().toString()));
            JEditorPane htmlPane = null;
            try {
                htmlPane = new JEditorPane(url);
            }
            catch (IOException e1) {
                try {
                    url = new URL(eulaUrl.replaceAll("\\{lang\\}", "en"));
                    htmlPane = new JEditorPane(url);
                }
                catch (IOException e2) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"EULA license URL not available: {0}", (Object[])new Object[]{eulaUrl}));
                    return false;
                }
            }
            Box box = Box.createVerticalBox();
            htmlPane.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(htmlPane);
            scrollPane.setPreferredSize(new Dimension(400, 400));
            box.add(scrollPane);
            int option = JOptionPane.showConfirmDialog(Main.parent, box, I18n.tr((String)"Please abort if you are not sure"), 0, 2);
            if (option == 0) {
                return true;
            }
        }
        catch (MalformedURLException e2) {
            JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Malformed URL for the EULA licence: {0}", (Object[])new Object[]{eulaUrl}));
        }
        return false;
    }

    class ImageryDefaultLayerTableModel
    extends DefaultTableModel {
        public ImageryDefaultLayerTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr((String)"Menu Name (Default)"), I18n.tr((String)"Imagery URL (Default)")});
        }

        public ImageryInfo getRow(int row) {
            return ((ImageryProvidersPanel)ImageryProvidersPanel.this).layerInfo.defaultLayers.get(row);
        }

        public int getRowCount() {
            return ((ImageryProvidersPanel)ImageryProvidersPanel.this).layerInfo.defaultLayers.size();
        }

        public Object getValueAt(int row, int column) {
            ImageryInfo info = ((ImageryProvidersPanel)ImageryProvidersPanel.this).layerInfo.defaultLayers.get(row);
            switch (column) {
                case 0: {
                    return info.name;
                }
                case 1: {
                    return info.getFullURL();
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class ImageryLayerTableModel
    extends DefaultTableModel {
        public ImageryLayerTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr((String)"Menu Name"), I18n.tr((String)"Imagery URL"), I18n.trc((String)"layer", (String)"Zoom")});
        }

        public ImageryInfo getRow(int row) {
            return ((ImageryProvidersPanel)ImageryProvidersPanel.this).layerInfo.layers.get(row);
        }

        public void addRow(ImageryInfo i) {
            ImageryProvidersPanel.this.layerInfo.add(i);
            int p = this.getRowCount() - 1;
            this.fireTableRowsInserted(p, p);
        }

        public void removeRow(int i) {
            ImageryProvidersPanel.this.layerInfo.remove(this.getRow(i));
            this.fireTableRowsDeleted(i, i);
        }

        public int getRowCount() {
            return ((ImageryProvidersPanel)ImageryProvidersPanel.this).layerInfo.layers.size();
        }

        public Object getValueAt(int row, int column) {
            ImageryInfo info = ((ImageryProvidersPanel)ImageryProvidersPanel.this).layerInfo.layers.get(row);
            switch (column) {
                case 0: {
                    return info.name;
                }
                case 1: {
                    return info.getFullURL();
                }
                case 2: {
                    return info.imageryType == ImageryInfo.ImageryType.WMS || info.imageryType == ImageryInfo.ImageryType.HTML ? (info.pixelPerDegree == 0.0 ? "" : Double.valueOf(info.pixelPerDegree)) : (info.maxZoom == 0 ? "" : Integer.valueOf(info.maxZoom));
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public void setValueAt(Object o, int row, int column) {
            ImageryInfo info = ((ImageryProvidersPanel)ImageryProvidersPanel.this).layerInfo.layers.get(row);
            switch (column) {
                case 0: {
                    info.name = (String)o;
                    break;
                }
                case 1: {
                    info.setURL((String)o);
                    break;
                }
                case 2: {
                    info.pixelPerDegree = 0.0;
                    info.maxZoom = 0;
                    try {
                        if (info.imageryType == ImageryInfo.ImageryType.WMS || info.imageryType == ImageryInfo.ImageryType.HTML) {
                            info.pixelPerDegree = Double.parseDouble((String)o);
                            break;
                        }
                        info.maxZoom = Integer.parseInt((String)o);
                    }
                    catch (NumberFormatException e) {}
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException();
                }
            }
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }
}

