/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery.wms;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddWMSLayerPanel
extends JPanel {
    private List<LayerDetails> selectedLayers;
    private URL serviceUrl;
    private LayerDetails selectedLayer;
    private JTextField menuName;
    private JTextArea resultingLayerField;
    private MutableTreeNode treeRootNode;
    private DefaultTreeModel treeData;
    private JTree layerTree;
    private JButton showBoundsButton;
    private boolean previouslyShownUnsupportedCrsError = false;

    public AddWMSLayerPanel() {
        JPanel wmsFetchPanel = new JPanel(new GridBagLayout());
        this.menuName = new JTextField(40);
        this.menuName.setText(I18n.tr((String)"Unnamed WMS Layer"));
        final JTextArea serviceUrl = new JTextArea(3, 40);
        serviceUrl.setLineWrap(true);
        serviceUrl.setText("http://sample.com/wms?");
        wmsFetchPanel.add((Component)new JLabel(I18n.tr((String)"Menu Name")), GBC.std().insets(0, 0, 5, 0));
        wmsFetchPanel.add((Component)this.menuName, GBC.eop().insets(5, 0, 0, 0).fill(2));
        wmsFetchPanel.add((Component)new JLabel(I18n.tr((String)"Service URL")), GBC.std().insets(0, 0, 5, 0));
        JScrollPane scrollPane = new JScrollPane(serviceUrl, 20, 31);
        wmsFetchPanel.add((Component)scrollPane, GBC.eop().insets(5, 0, 0, 0));
        JButton getLayersButton = new JButton(I18n.tr((String)"Get Layers"));
        getLayersButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Cursor beforeCursor = AddWMSLayerPanel.this.getCursor();
                try {
                    AddWMSLayerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    AddWMSLayerPanel.this.attemptGetCapabilities(serviceUrl.getText());
                }
                finally {
                    AddWMSLayerPanel.this.setCursor(beforeCursor);
                }
            }
        });
        wmsFetchPanel.add((Component)getLayersButton, GBC.eop().anchor(13));
        this.treeRootNode = new DefaultMutableTreeNode();
        this.treeData = new DefaultTreeModel(this.treeRootNode);
        this.layerTree = new JTree(this.treeData);
        this.layerTree.setCellRenderer(new LayerTreeCellRenderer());
        this.layerTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath[] selectionRows = AddWMSLayerPanel.this.layerTree.getSelectionPaths();
                if (selectionRows == null) {
                    AddWMSLayerPanel.this.showBoundsButton.setEnabled(false);
                    AddWMSLayerPanel.this.selectedLayer = null;
                    return;
                }
                AddWMSLayerPanel.this.selectedLayers = new LinkedList();
                for (TreePath i : selectionRows) {
                    Object userObject = ((DefaultMutableTreeNode)i.getLastPathComponent()).getUserObject();
                    if (!(userObject instanceof LayerDetails)) continue;
                    LayerDetails detail = (LayerDetails)userObject;
                    if (!detail.isSupported()) {
                        AddWMSLayerPanel.this.layerTree.removeSelectionPath(i);
                        if (AddWMSLayerPanel.this.previouslyShownUnsupportedCrsError) continue;
                        JOptionPane.showMessageDialog(null, I18n.tr((String)"That layer does not support any of JOSM's projections,\nso you can not use it. This message will not show again."), I18n.tr((String)"WMS Error"), 0);
                        AddWMSLayerPanel.this.previouslyShownUnsupportedCrsError = true;
                        continue;
                    }
                    if (detail.ident == null) continue;
                    AddWMSLayerPanel.this.selectedLayers.add(detail);
                }
                if (!AddWMSLayerPanel.this.selectedLayers.isEmpty()) {
                    AddWMSLayerPanel.this.resultingLayerField.setText(AddWMSLayerPanel.this.buildGetMapUrl());
                    if (AddWMSLayerPanel.this.selectedLayers.size() == 1) {
                        AddWMSLayerPanel.this.showBoundsButton.setEnabled(true);
                        AddWMSLayerPanel.this.selectedLayer = (LayerDetails)AddWMSLayerPanel.this.selectedLayers.get(0);
                    }
                } else {
                    AddWMSLayerPanel.this.showBoundsButton.setEnabled(false);
                    AddWMSLayerPanel.this.selectedLayer = null;
                }
            }
        });
        wmsFetchPanel.add((Component)new JScrollPane(this.layerTree), GBC.eop().insets(5, 0, 0, 0).fill(2));
        JPanel layerManipulationButtons = new JPanel();
        this.showBoundsButton = new JButton(I18n.tr((String)"Show Bounds"));
        this.showBoundsButton.setEnabled(false);
        this.showBoundsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AddWMSLayerPanel.this.selectedLayer.bounds != null) {
                    SlippyMapBBoxChooser mapPanel = new SlippyMapBBoxChooser();
                    mapPanel.setBoundingBox(AddWMSLayerPanel.this.selectedLayer.bounds);
                    JOptionPane.showMessageDialog(null, mapPanel, I18n.tr((String)"Show Bounds"), -1);
                } else {
                    JOptionPane.showMessageDialog(null, I18n.tr((String)"No bounding box was found for this layer."), I18n.tr((String)"WMS Error"), 0);
                }
            }
        });
        layerManipulationButtons.add(this.showBoundsButton);
        wmsFetchPanel.add((Component)layerManipulationButtons, GBC.eol().insets(0, 0, 5, 0));
        wmsFetchPanel.add((Component)new JLabel(I18n.tr((String)"WMS URL")), GBC.std().insets(0, 0, 5, 0));
        this.resultingLayerField = new JTextArea(3, 40);
        this.resultingLayerField.setLineWrap(true);
        wmsFetchPanel.add((Component)new JScrollPane(this.resultingLayerField, 20, 31), GBC.eop().insets(5, 0, 0, 0).fill(2));
        this.add(wmsFetchPanel);
    }

    private String buildRootUrl() {
        StringBuilder a = new StringBuilder(this.serviceUrl.getProtocol());
        a.append("://");
        a.append(this.serviceUrl.getHost());
        if (this.serviceUrl.getPort() != -1) {
            a.append(":");
            a.append(this.serviceUrl.getPort());
        }
        a.append(this.serviceUrl.getPath());
        a.append("?");
        if (this.serviceUrl.getQuery() != null) {
            a.append(this.serviceUrl.getQuery());
            if (!this.serviceUrl.getQuery().isEmpty() && !this.serviceUrl.getQuery().endsWith("&")) {
                a.append("&");
            }
        }
        return a.toString();
    }

    private String buildGetMapUrl() {
        StringBuilder a = new StringBuilder();
        a.append(this.buildRootUrl());
        a.append("FORMAT=image/jpeg&VERSION=1.1.1&SERVICE=WMS&REQUEST=GetMap&Layers=");
        a.append(this.commaSepLayerList());
        a.append("&");
        return a.toString();
    }

    private String commaSepLayerList() {
        StringBuilder b = new StringBuilder();
        Iterator<LayerDetails> iterator = this.selectedLayers.iterator();
        while (iterator.hasNext()) {
            LayerDetails layerDetails = iterator.next();
            b.append(layerDetails.ident);
            if (!iterator.hasNext()) continue;
            b.append(",");
        }
        return b.toString();
    }

    private void showError(String incomingData, Exception e) {
        JOptionPane.showMessageDialog(this, I18n.tr((String)"Could not parse WMS layer list."), I18n.tr((String)"WMS Error"), 0);
        System.err.println("Could not parse WMS layer list. Incoming data:");
        System.err.println(incomingData);
        e.printStackTrace();
    }

    private void attemptGetCapabilities(String serviceUrlStr) {
        String baseURL;
        Document document;
        String incomingData;
        URL getCapabilitiesUrl = null;
        try {
            getCapabilitiesUrl = !serviceUrlStr.trim().contains("capabilities") ? new URL(serviceUrlStr + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities") : new URL(serviceUrlStr);
            this.serviceUrl = new URL(serviceUrlStr);
        }
        catch (HeadlessException e) {
            return;
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this, I18n.tr((String)"Invalid service URL."), I18n.tr((String)"WMS Error"), 0);
            return;
        }
        try {
            String line;
            URLConnection openConnection = getCapabilitiesUrl.openConnection();
            InputStream inputStream = openConnection.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder ba = new StringBuilder();
            while ((line = br.readLine()) != null) {
                ba.append(line);
                ba.append("\n");
            }
            incomingData = ba.toString();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, I18n.tr((String)"Could not retrieve WMS layer list."), I18n.tr((String)"WMS Error"), 0);
            return;
        }
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setValidating(false);
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    System.out.println("Ignoring DTD " + publicId + ", " + systemId);
                    return new InputSource(new StringReader(""));
                }
            });
            document = builder.parse(new InputSource(new StringReader(incomingData)));
        }
        catch (ParserConfigurationException e) {
            this.showError(incomingData, e);
            return;
        }
        catch (SAXException e) {
            this.showError(incomingData, e);
            return;
        }
        catch (IOException e) {
            this.showError(incomingData, e);
            return;
        }
        Element child = AddWMSLayerPanel.getChild(document.getDocumentElement(), "Capability");
        child = AddWMSLayerPanel.getChild(child, "Request");
        child = AddWMSLayerPanel.getChild(child, "GetMap");
        child = AddWMSLayerPanel.getChild(child, "DCPType");
        child = AddWMSLayerPanel.getChild(child, "HTTP");
        child = AddWMSLayerPanel.getChild(child, "Get");
        child = AddWMSLayerPanel.getChild(child, "OnlineResource");
        if (child != null && (baseURL = child.getAttribute("xlink:href")) != null) {
            try {
                System.out.println("GetCapabilities specifies a different service URL: " + baseURL);
                this.serviceUrl = new URL(baseURL);
            }
            catch (MalformedURLException e1) {
                // empty catch block
            }
        }
        try {
            this.treeRootNode.setUserObject(getCapabilitiesUrl.getHost());
            Element capabilityElem = AddWMSLayerPanel.getChild(document.getDocumentElement(), "Capability");
            List<Element> children = AddWMSLayerPanel.getChildren(capabilityElem, "Layer");
            List<LayerDetails> layers = this.parseLayers(children, new HashSet<String>());
            this.updateTreeList(layers);
        }
        catch (Exception e) {
            this.showError(incomingData, e);
            return;
        }
    }

    private void updateTreeList(List<LayerDetails> layers) {
        this.addLayersToTreeData(this.treeRootNode, layers);
        this.layerTree.expandRow(0);
    }

    private void addLayersToTreeData(MutableTreeNode parent, List<LayerDetails> layers) {
        for (LayerDetails layerDetails : layers) {
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(layerDetails);
            this.addLayersToTreeData(treeNode, layerDetails.children);
            this.treeData.insertNodeInto(treeNode, parent, 0);
        }
    }

    private List<LayerDetails> parseLayers(List<Element> children, Set<String> parentCrs) {
        LinkedList<LayerDetails> details = new LinkedList<LayerDetails>();
        for (Element element : children) {
            details.add(this.parseLayer(element, parentCrs));
        }
        return details;
    }

    private LayerDetails parseLayer(Element element, Set<String> parentCrs) {
        String name = AddWMSLayerPanel.getChildContent(element, "Title", null, null);
        String ident = AddWMSLayerPanel.getChildContent(element, "Name", null, null);
        HashSet<String> crsList = new HashSet<String>();
        crsList.addAll(parentCrs);
        List<Element> crsChildren = AddWMSLayerPanel.getChildren(element, "CRS");
        crsChildren.addAll(AddWMSLayerPanel.getChildren(element, "SRS"));
        for (Element child : crsChildren) {
            String crs = (String)AddWMSLayerPanel.getContent(child);
            if (crs == null) continue;
            String upperCase = crs.trim().toUpperCase();
            crsList.add(upperCase);
        }
        boolean josmSupportsThisLayer = false;
        for (String crs : crsList) {
            josmSupportsThisLayer |= this.isProjSupported(crs);
        }
        Bounds bounds = null;
        Element bboxElem = AddWMSLayerPanel.getChild(element, "EX_GeographicBoundingBox");
        if (bboxElem != null) {
            double left = Double.parseDouble(AddWMSLayerPanel.getChildContent(bboxElem, "westBoundLongitude", null, null));
            double top = Double.parseDouble(AddWMSLayerPanel.getChildContent(bboxElem, "northBoundLatitude", null, null));
            double right = Double.parseDouble(AddWMSLayerPanel.getChildContent(bboxElem, "eastBoundLongitude", null, null));
            double bot = Double.parseDouble(AddWMSLayerPanel.getChildContent(bboxElem, "southBoundLatitude", null, null));
            bounds = new Bounds(bot, left, top, right);
        } else {
            bboxElem = AddWMSLayerPanel.getChild(element, "LatLonBoundingBox");
            if (bboxElem != null) {
                double left = Double.parseDouble(bboxElem.getAttribute("minx"));
                double top = Double.parseDouble(bboxElem.getAttribute("maxy"));
                double right = Double.parseDouble(bboxElem.getAttribute("maxx"));
                double bot = Double.parseDouble(bboxElem.getAttribute("miny"));
                bounds = new Bounds(bot, left, top, right);
            }
        }
        List<Element> layerChildren = AddWMSLayerPanel.getChildren(element, "Layer");
        List<LayerDetails> childLayers = this.parseLayers(layerChildren, crsList);
        return new LayerDetails(name, ident, crsList, josmSupportsThisLayer, bounds, childLayers);
    }

    private boolean isProjSupported(String crs) {
        for (Projection proj : Projection.allProjections) {
            if (!(proj instanceof ProjectionSubPrefs ? ((ProjectionSubPrefs)proj).getPreferencesFromCode(crs) == null : proj.toCode().equals(crs))) continue;
            return true;
        }
        return false;
    }

    public String getUrlName() {
        return this.menuName.getText();
    }

    public String getUrl() {
        return this.resultingLayerField.getText();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Test");
        f.setContentPane(new AddWMSLayerPanel());
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    private static String getChildContent(Element parent, String name, String missing, String empty) {
        Element child = AddWMSLayerPanel.getChild(parent, name);
        if (child == null) {
            return missing;
        }
        String content = (String)AddWMSLayerPanel.getContent(child);
        return content != null ? content : empty;
    }

    private static Object getContent(Element element) {
        NodeList nl = element.getChildNodes();
        StringBuffer content = new StringBuffer();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    return node;
                }
                case 3: 
                case 4: {
                    content.append(node.getNodeValue());
                }
            }
        }
        return content.toString().trim();
    }

    private static List<Element> getChildren(Element parent, String name) {
        LinkedList<Element> retVal = new LinkedList<Element>();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getNodeName())) continue;
            retVal.add((Element)child);
        }
        return retVal;
    }

    private static Element getChild(Element parent, String name) {
        if (parent == null) {
            return null;
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    class LayerTreeCellRenderer
    extends DefaultTreeCellRenderer {
        LayerTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof LayerDetails) {
                LayerDetails layer = (LayerDetails)userObject;
                this.setEnabled(layer.isSupported());
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LayerDetails {
        private String name;
        private String ident;
        private List<LayerDetails> children;
        private Bounds bounds;
        private boolean supported;

        public LayerDetails(String name, String ident, Set<String> crsList, boolean supportedLayer, Bounds bounds, List<LayerDetails> childLayers) {
            this.name = name;
            this.ident = ident;
            this.supported = supportedLayer;
            this.children = childLayers;
            this.bounds = bounds;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public String toString() {
            if (this.name == null || this.name.isEmpty()) {
                return this.ident;
            }
            return this.name;
        }
    }
}

