/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.plugins.imagery.ImageryLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsetBookmark {
    public static List<OffsetBookmark> allBookmarks = new ArrayList<OffsetBookmark>();
    public Projection proj;
    public String layerName;
    public String name;
    public double dx;
    public double dy;

    public boolean isUsable(ImageryLayer layer) {
        return Main.proj.getClass() == this.proj.getClass() && layer.getInfo().getName().equals(this.layerName);
    }

    public OffsetBookmark(Projection proj, String layerName, String name, double dx, double dy) {
        this.proj = proj;
        this.layerName = layerName;
        this.name = name;
        this.dx = dx;
        this.dy = dy;
    }

    public OffsetBookmark(Collection<String> list) {
        ArrayList<String> array = new ArrayList<String>(list);
        String projectionName = array.get(0);
        for (Projection proj : Projection.allProjections) {
            if (!proj.getCacheDirectoryName().equals(projectionName)) continue;
            this.proj = proj;
            break;
        }
        if (this.proj == null) {
            throw new IllegalStateException(I18n.tr((String)"Projection ''{0}'' not found", (Object[])new Object[]{projectionName}));
        }
        this.layerName = array.get(1);
        this.name = array.get(2);
        this.dx = Double.valueOf(array.get(3));
        this.dy = Double.valueOf(array.get(4));
    }

    public ArrayList<String> getInfoArray() {
        ArrayList<String> res = new ArrayList<String>(5);
        res.add(this.proj.getCacheDirectoryName());
        res.add(this.layerName);
        res.add(this.name);
        res.add(String.valueOf(this.dx));
        res.add(String.valueOf(this.dy));
        return res;
    }

    public static void loadBookmarks() {
        for (Collection c : Main.pref.getArray("imagery.offsets", Collections.emptySet())) {
            allBookmarks.add(new OffsetBookmark(c));
        }
    }

    public static void saveBookmarks() {
        LinkedList<ArrayList<String>> coll = new LinkedList<ArrayList<String>>();
        for (OffsetBookmark b : allBookmarks) {
            coll.add(b.getInfoArray());
        }
        Main.pref.putArray("imagery.offsets", coll);
    }
}

