/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.imagery.ImageryAdjustAction;
import org.openstreetmap.josm.plugins.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.imagery.ImageryPlugin;
import org.openstreetmap.josm.plugins.imagery.ImageryPreferences;
import org.openstreetmap.josm.plugins.imagery.OffsetBookmark;
import org.openstreetmap.josm.plugins.imagery.tms.TMSLayer;
import org.openstreetmap.josm.plugins.imagery.wms.WMSLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageryLayer
extends Layer {
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ImageryPlugin.class.getResource("/images/imagery_small.png")));
    protected final ImageryInfo info;
    protected MapView mv;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected int sharpenLevel;

    public ImageryLayer(ImageryInfo info) {
        super(info.getName());
        this.info = info;
        this.mv = Main.map.mapView;
        this.sharpenLevel = ImageryPreferences.PROP_SHARPEN_LEVEL.get();
    }

    public double getPPD() {
        ProjectionBounds bounds = this.mv.getProjectionBounds();
        return (double)this.mv.getWidth() / (bounds.max.east() - bounds.min.east());
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void setOffset(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public void displace(double dx, double dy) {
        this.setOffset(this.dx += dx, this.dy += dy);
    }

    public ImageryInfo getInfo() {
        return this.info;
    }

    public Icon getIcon() {
        return icon;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public static ImageryLayer create(ImageryInfo info) {
        if (info.imageryType == ImageryInfo.ImageryType.WMS || info.imageryType == ImageryInfo.ImageryType.HTML) {
            return new WMSLayer(info);
        }
        if (info.imageryType == ImageryInfo.ImageryType.TMS || info.imageryType == ImageryInfo.ImageryType.BING) {
            return new TMSLayer(info);
        }
        throw new AssertionError();
    }

    public List<Component> getOffsetMenu() {
        ArrayList<Component> result = new ArrayList<Component>();
        result.add(new JMenuItem((Action)((Object)new ImageryAdjustAction(this))));
        if (OffsetBookmark.allBookmarks.isEmpty()) {
            return result;
        }
        result.add(new JSeparator(0));
        for (OffsetBookmark b : OffsetBookmark.allBookmarks) {
            if (!b.isUsable(this)) continue;
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(new ApplyOffsetAction(b));
            if (b.dx == this.dx && b.dy == this.dy) {
                item.setSelected(true);
            }
            result.add(item);
        }
        return result;
    }

    public BufferedImage sharpenImage(BufferedImage img) {
        if (this.sharpenLevel <= 0) {
            return img;
        }
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        BufferedImage tmp = new BufferedImage(width, height, 1);
        tmp.getGraphics().drawImage(img, 0, 0, null);
        Kernel kernel = this.sharpenLevel == 1 ? new Kernel(2, 2, new float[]{4.0f, -1.0f, -1.0f, -1.0f}) : new Kernel(3, 3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});
        ConvolveOp op = new ConvolveOp(kernel, 1, null);
        return op.filter(tmp, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OffsetAction
    extends AbstractAction
    implements Layer.LayerAction {
        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public Component createMenuComponent() {
            JMenu menu = new JMenu(I18n.trc((String)"layer", (String)"Offset"));
            menu.setIcon(ImageProvider.get((String)"mapmode", (String)"adjustimg"));
            for (Component item : ImageryLayer.this.getOffsetMenu()) {
                menu.add(item);
            }
            return menu;
        }

        public boolean supportLayers(List<Layer> layers) {
            return false;
        }
    }

    class ApplyOffsetAction
    extends AbstractAction {
        private OffsetBookmark b;

        ApplyOffsetAction(OffsetBookmark b) {
            super(b.name);
            this.b = b;
        }

        public void actionPerformed(ActionEvent ev) {
            ImageryLayer.this.setOffset(this.b.dx, this.b.dy);
            Main.map.repaint();
            if (!(ev.getSource() instanceof Component)) {
                return;
            }
            Component source = (Component)ev.getSource();
            if (!(source.getParent() instanceof Container)) {
                return;
            }
            Container m = source.getParent();
            for (Component c : m.getComponents()) {
                if (!(c instanceof JCheckBoxMenuItem) || c == source) continue;
                ((JCheckBoxMenuItem)c).setSelected(false);
            }
        }
    }
}

