/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.imagery.ImageryLayer;
import org.openstreetmap.josm.plugins.imagery.ImageryPlugin;
import org.openstreetmap.josm.plugins.imagery.OffsetBookmark;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageryAdjustAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    static ImageryOffsetDialog offsetDialog;
    static Cursor cursor;
    double oldDx;
    double oldDy;
    boolean mouseDown;
    EastNorth prevEastNorth;
    private ImageryLayer layer;

    public ImageryAdjustAction(ImageryLayer layer) {
        super(I18n.tr((String)"New offset"), "adjustimg", I18n.tr((String)"Adjust the position of this imagery layer"), Main.map, cursor);
        this.layer = layer;
    }

    public void enterMode() {
        super.enterMode();
        if (this.layer == null) {
            return;
        }
        if (!this.layer.isVisible()) {
            this.layer.setVisible(true);
        }
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
        this.oldDx = this.layer.dx;
        this.oldDy = this.layer.dy;
        offsetDialog = new ImageryOffsetDialog();
        offsetDialog.setVisible(true);
    }

    public void exitMode() {
        super.exitMode();
        if (offsetDialog != null) {
            this.layer.setOffset(this.oldDx, this.oldDy);
            offsetDialog.setVisible(false);
            offsetDialog = null;
        }
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.layer.isVisible()) {
            this.prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            Main.map.mapView.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.layer == null || this.prevEastNorth == null) {
            return;
        }
        EastNorth eastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
        double dx = this.layer.getDx() + eastNorth.east() - this.prevEastNorth.east();
        double dy = this.layer.getDy() + eastNorth.north() - this.prevEastNorth.north();
        this.layer.setOffset(dx, dy);
        if (offsetDialog != null) {
            offsetDialog.updateOffset();
        }
        Main.map.repaint();
        this.prevEastNorth = eastNorth;
    }

    public void mouseReleased(MouseEvent e) {
        Main.map.mapView.repaint();
        Main.map.mapView.setCursor(Cursor.getDefaultCursor());
        this.prevEastNorth = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (offsetDialog != null || this.layer == null) {
            return;
        }
        super.actionPerformed(e);
    }

    static {
        cursor = ImageProvider.getCursor((String)"normal", (String)"move");
    }

    class ImageryOffsetDialog
    extends ExtendedDialog
    implements PropertyChangeListener {
        public final JFormattedTextField easting;
        public final JFormattedTextField northing;
        JTextField tBookmarkName;
        private boolean ignoreListener;

        public ImageryOffsetDialog() {
            super(Main.parent, I18n.tr((String)"Adjust imagery offset"), new String[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel")}, false);
            this.easting = new JFormattedTextField(new DecimalFormat("0.00000E0"));
            this.northing = new JFormattedTextField(new DecimalFormat("0.00000E0"));
            this.tBookmarkName = new JTextField();
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.contentInsets = new Insets(15, 15, 5, 15);
            JPanel pnl = new JPanel();
            pnl.setLayout(new GridBagLayout());
            pnl.add((Component)new JLabel(I18n.tr((String)"Easting") + ": "), GBC.std());
            pnl.add((Component)this.easting, GBC.std().fill(2).insets(0, 0, 5, 0));
            pnl.add((Component)new JLabel(I18n.tr((String)"Northing") + ": "), GBC.std());
            pnl.add((Component)this.northing, GBC.eol());
            pnl.add((Component)new JLabel(I18n.tr((String)"Bookmark name: ")), GBC.eol().insets(0, 5, 0, 0));
            pnl.add((Component)this.tBookmarkName, GBC.eol().fill(2));
            this.easting.setColumns(8);
            this.northing.setColumns(8);
            this.easting.setValue(ImageryAdjustAction.this.layer.getDx());
            this.northing.setValue(ImageryAdjustAction.this.layer.getDy());
            this.easting.addPropertyChangeListener("value", this);
            this.northing.addPropertyChangeListener("value", this);
            this.setContent(pnl);
            this.setupDialog();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.ignoreListener) {
                return;
            }
            ImageryAdjustAction.this.layer.setOffset(((Number)this.easting.getValue()).doubleValue(), ((Number)this.northing.getValue()).doubleValue());
            Main.map.repaint();
        }

        public void updateOffset() {
            this.ignoreListener = true;
            this.easting.setValue(ImageryAdjustAction.this.layer.getDx());
            this.northing.setValue(ImageryAdjustAction.this.layer.getDy());
            this.ignoreListener = false;
        }

        protected void buttonAction(int buttonIndex, ActionEvent evt) {
            super.buttonAction(buttonIndex, evt);
            offsetDialog = null;
            if (buttonIndex == 2) {
                ImageryAdjustAction.this.layer.setOffset(ImageryAdjustAction.this.oldDx, ImageryAdjustAction.this.oldDy);
            } else if (this.tBookmarkName.getText() != null && !"".equals(this.tBookmarkName.getText())) {
                OffsetBookmark b = new OffsetBookmark(Main.proj, ImageryAdjustAction.this.layer.getInfo().getName(), this.tBookmarkName.getText(), ImageryAdjustAction.this.layer.getDx(), ImageryAdjustAction.this.layer.getDy());
                OffsetBookmark.allBookmarks.add(b);
                OffsetBookmark.saveBookmarks();
            }
            ImageryPlugin.instance.refreshOffsetMenu();
            Main.map.selectSelectTool(false);
        }
    }
}

