/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery.tms;

import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.plugins.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.imagery.ImageryPreferences;
import org.openstreetmap.josm.plugins.imagery.tms.BingAerialTileSource;
import org.openstreetmap.josm.plugins.imagery.tms.TMSTileSource;
import org.openstreetmap.josm.plugins.imagery.tms.TemplatedTMSTileSource;

public class TMSPreferences {
    public static final String PREFERENCE_PREFIX = "imagery.tms";
    public static final int MAX_ZOOM = 30;
    public static final int MIN_ZOOM = 2;
    public static final int DEFAULT_MAX_ZOOM = 18;
    public static final int DEFAULT_MIN_ZOOM = 2;
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.tms.default_autozoom", true);
    public static final BooleanProperty PROP_DEFAULT_AUTOLOAD = new BooleanProperty("imagery.tms.default_autoload", true);
    public static final IntegerProperty PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.tms.min_zoom_lvl", 2);
    public static final IntegerProperty PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.tms.max_zoom_lvl", 18);
    public static final BooleanProperty PROP_DRAW_DEBUG = new BooleanProperty("imagery.tms.draw_debug", false);
    public static final BooleanProperty PROP_ADD_TO_SLIPPYMAP_CHOOSER = new BooleanProperty("imagery.tms.add_to_slippymap_chooser", true);

    static int checkMaxZoomLvl(int maxZoomLvl, TileSource ts) {
        if (maxZoomLvl > 30) {
            System.err.println("MaxZoomLvl shouldnt be more than 30! Setting to 30.");
            maxZoomLvl = 30;
        }
        if (maxZoomLvl < PROP_MIN_ZOOM_LVL.get()) {
            System.err.println("maxZoomLvl shouldnt be more than minZoomLvl! Setting to minZoomLvl.");
            maxZoomLvl = PROP_MIN_ZOOM_LVL.get();
        }
        if (ts != null && ts.getMaxZoom() != 0 && ts.getMaxZoom() < maxZoomLvl) {
            maxZoomLvl = ts.getMaxZoom();
        }
        return maxZoomLvl;
    }

    public static int getMaxZoomLvl(TileSource ts) {
        return TMSPreferences.checkMaxZoomLvl(PROP_MAX_ZOOM_LVL.get(), ts);
    }

    public static void setMaxZoomLvl(int maxZoomLvl) {
        maxZoomLvl = TMSPreferences.checkMaxZoomLvl(maxZoomLvl, null);
        PROP_MAX_ZOOM_LVL.put(maxZoomLvl);
    }

    static int checkMinZoomLvl(int minZoomLvl, TileSource ts) {
        if (minZoomLvl < 2) {
            System.err.println("minZoomLvl shouldnt be lees than 2! Setting to that.");
            minZoomLvl = 2;
        }
        if (minZoomLvl > PROP_MAX_ZOOM_LVL.get()) {
            System.err.println("minZoomLvl shouldnt be more than maxZoomLvl! Setting to maxZoomLvl.");
            minZoomLvl = TMSPreferences.getMaxZoomLvl(ts);
        }
        if (ts != null && ts.getMinZoom() > minZoomLvl) {
            System.err.println("increasomg minZoomLvl to match tile source");
            minZoomLvl = ts.getMinZoom();
        }
        return minZoomLvl;
    }

    public static int getMinZoomLvl(TileSource ts) {
        return TMSPreferences.checkMinZoomLvl(PROP_MIN_ZOOM_LVL.get(), ts);
    }

    public static void setMinZoomLvl(int minZoomLvl) {
        minZoomLvl = TMSPreferences.checkMinZoomLvl(minZoomLvl, null);
        PROP_MIN_ZOOM_LVL.put(minZoomLvl);
    }

    public static TileSource getTileSource(ImageryInfo info) {
        if (info.getImageryType() == ImageryInfo.ImageryType.TMS) {
            if (ImageryPreferences.isUrlWithPatterns(info.getURL())) {
                return new TemplatedTMSTileSource(info.getName(), info.getURL(), info.getMaxZoom());
            }
            return new TMSTileSource(info.getName(), info.getURL(), info.getMaxZoom());
        }
        if (info.getImageryType() == ImageryInfo.ImageryType.BING) {
            return new BingAerialTileSource();
        }
        return null;
    }
}

