/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery.tms;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BingAerialTileSource
extends OsmTileSource.AbstractOsmTileSource {
    private static String API_KEY = "Arzdiw4nlOJzRwOz__qailc8NiR31Tt51dN2D7cm57NrnceZnCpgOkmJhNpGoppU";
    private static List<Attribution> attributions;

    public BingAerialTileSource() {
        super("Bing Aerial Maps", "http://ecn.t2.tiles.virtualearth.net/tiles/");
        attributions = this.loadAttributionText();
        System.err.println("Added " + attributions.size() + " attributions.");
    }

    private List<Attribution> loadAttributionText() {
        try {
            URL u = new URL("http://dev.virtualearth.net/REST/v1/Imagery/Metadata/Aerial/0,0?zl=1&mapVersion=v1&key=" + API_KEY + "&include=ImageryProviders&output=xml");
            InputStream stream = u.openStream();
            XMLReader parser = XMLReaderFactory.createXMLReader();
            AttrHandler handler = new AttrHandler();
            parser.setContentHandler(handler);
            parser.parse(new InputSource(stream));
            return handler.attributions;
        }
        catch (IOException e) {
            System.err.println("Could not open Bing aerials attribution metadata.");
        }
        catch (SAXException e) {
            System.err.println("Could not parse Bing aerials attribution metadata.");
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    public int getMaxZoom() {
        return 22;
    }

    public String getExtension() {
        return "jpeg";
    }

    public String getTilePath(int zoom, int tilex, int tiley) {
        String quadtree = BingAerialTileSource.computeQuadTree(zoom, tilex, tiley);
        return "/tiles/a" + quadtree + "." + this.getExtension() + "?g=587";
    }

    public TileSource.TileUpdate getTileUpdate() {
        return TileSource.TileUpdate.IfNoneMatch;
    }

    public boolean requiresAttribution() {
        return true;
    }

    public Image getAttributionImage() {
        return ImageProvider.get((String)"bing_maps").getImage();
    }

    public String getAttributionLinkURL() {
        return "http://go.microsoft.com/?linkid=9710837";
    }

    public String getTermsOfUseURL() {
        return "http://opengeodata.org/microsoft-imagery-details";
    }

    public String getAttributionText(int zoom, LatLon topLeft, LatLon botRight) {
        Bounds windowBounds = new Bounds(topLeft, botRight);
        StringBuilder a = new StringBuilder();
        for (Attribution attr : attributions) {
            Bounds attrBounds = attr.bounds;
            if (zoom > attr.maxZoom || zoom < attr.minZoom || !(windowBounds.getMin().lon() < attrBounds.getMax().lon()) || !(windowBounds.getMax().lon() > attrBounds.getMin().lon()) || !(windowBounds.getMax().lat() < attrBounds.getMin().lat()) || !(windowBounds.getMin().lat() > attrBounds.getMax().lat())) continue;
            a.append(attr.attribution);
            a.append(" ");
        }
        return a.toString();
    }

    static String computeQuadTree(int zoom, int tilex, int tiley) {
        StringBuilder k = new StringBuilder();
        for (int i = zoom; i > 0; --i) {
            char digit = '0';
            int mask = 1 << i - 1;
            if ((tilex & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((tiley & mask) != 0) {
                digit = (char)(digit + 2);
            }
            k.append(digit);
        }
        return k.toString();
    }

    class AttrHandler
    extends DefaultHandler {
        private String string;
        private Attribution curr;
        private List<Attribution> attributions = new ArrayList<Attribution>();
        private double southLat;
        private double northLat;
        private double eastLon;
        private double westLon;
        private boolean inCoverage = false;

        AttrHandler() {
        }

        public void startElement(String uri, String stripped, String tagName, Attributes attrs) throws SAXException {
            if ("ImageryProvider".equals(tagName)) {
                this.curr = new Attribution();
            } else if ("CoverageArea".equals(tagName)) {
                this.inCoverage = true;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.string = new String(ch, start, length);
        }

        public void endElement(String uri, String stripped, String tagName) throws SAXException {
            if ("ImageryProvider".equals(tagName)) {
                this.attributions.add(this.curr);
            } else if ("Attribution".equals(tagName)) {
                this.curr.attribution = this.string;
            } else if (this.inCoverage && "ZoomMin".equals(tagName)) {
                this.curr.minZoom = Integer.parseInt(this.string);
            } else if (this.inCoverage && "ZoomMax".equals(tagName)) {
                this.curr.maxZoom = Integer.parseInt(this.string);
            } else if (this.inCoverage && "SouthLatitude".equals(tagName)) {
                this.southLat = Double.parseDouble(this.string);
            } else if (this.inCoverage && "NorthLatitude".equals(tagName)) {
                this.northLat = Double.parseDouble(this.string);
            } else if (this.inCoverage && "EastLongitude".equals(tagName)) {
                this.eastLon = Double.parseDouble(this.string);
            } else if (this.inCoverage && "WestLongitude".equals(tagName)) {
                this.westLon = Double.parseDouble(this.string);
            } else if ("BoundingBox".equals(tagName)) {
                this.curr.bounds = new Bounds(this.northLat, this.westLon, this.southLat, this.eastLon);
            } else if ("CoverageArea".equals(tagName)) {
                this.inCoverage = false;
            }
            this.string = "";
        }
    }

    class Attribution {
        String attribution;
        int minZoom;
        int maxZoom;
        Bounds bounds;

        Attribution() {
        }
    }
}

