/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery.wms;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.io.CacheFiles;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.plugins.imagery.ImageryPreferences;
import org.openstreetmap.josm.plugins.imagery.wms.GeorefImage;
import org.openstreetmap.josm.plugins.imagery.wms.Grabber;
import org.openstreetmap.josm.plugins.imagery.wms.WMSLayer;
import org.openstreetmap.josm.plugins.imagery.wms.WMSRequest;
import org.openstreetmap.josm.tools.I18n;

public class WMSGrabber
extends Grabber {
    protected String baseURL;
    private final boolean urlWithPatterns;
    public static final NumberFormat latLonFormat = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));

    WMSGrabber(MapView mv, WMSLayer layer, CacheFiles cache) {
        super(mv, layer, cache);
        this.baseURL = layer.getInfo().getURL();
        this.urlWithPatterns = ImageryPreferences.isUrlWithPatterns(this.baseURL);
    }

    void fetch(WMSRequest request) throws Exception {
        URL url = null;
        try {
            url = this.getURL(this.b.min.east(), this.b.min.north(), this.b.max.east(), this.b.max.north(), this.width(), this.height());
            request.finish(GeorefImage.State.IMAGE, this.grab(url));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage() + "\nImage couldn't be fetched: " + (url != null ? url.toString() : ""));
        }
    }

    protected URL getURL(double w, double s, double e, double n, int wi, int ht) throws MalformedURLException {
        String myProj = Main.proj.toCode();
        if (Main.proj instanceof Mercator) {
            LatLon sw = Main.proj.eastNorth2latlon(new EastNorth(w, s));
            LatLon ne = Main.proj.eastNorth2latlon(new EastNorth(e, n));
            myProj = "EPSG:4326";
            s = sw.lat();
            w = sw.lon();
            n = ne.lat();
            e = ne.lon();
        }
        String str = this.baseURL;
        String bbox = latLonFormat.format(w) + "," + latLonFormat.format(s) + "," + latLonFormat.format(e) + "," + latLonFormat.format(n);
        if (this.urlWithPatterns) {
            str = str.replaceAll("\\{proj\\}", myProj).replaceAll("\\{bbox\\}", bbox).replaceAll("\\{w\\}", latLonFormat.format(w)).replaceAll("\\{s\\}", latLonFormat.format(s)).replaceAll("\\{e\\}", latLonFormat.format(e)).replaceAll("\\{n\\}", latLonFormat.format(n)).replaceAll("\\{width\\}", String.valueOf(wi)).replaceAll("\\{height\\}", String.valueOf(ht));
        } else {
            str = str + "bbox=" + bbox + WMSGrabber.getProjection(this.baseURL, false) + "&width=" + wi + "&height=" + ht;
            if (!this.baseURL.endsWith("&") && !this.baseURL.endsWith("?")) {
                System.out.println(I18n.tr((String)"Warning: The base URL ''{0}'' for a WMS service doesn't have a trailing '&' or a trailing '?'.", (Object[])new Object[]{this.baseURL}));
                System.out.println(I18n.tr((String)"Warning: Fetching WMS tiles is likely to fail. Please check you preference settings."));
                System.out.println(I18n.tr((String)"Warning: The complete URL is ''{0}''.", (Object[])new Object[]{str}));
            }
        }
        return new URL(str.replace(" ", "%20"));
    }

    public static String getProjection(String baseURL, Boolean warn) {
        String projname = Main.proj.toCode();
        if (Main.proj instanceof Mercator) {
            projname = "EPSG:4326";
        }
        String res = "";
        try {
            Matcher m = Pattern.compile(".*srs=([a-z0-9:]+).*").matcher(baseURL.toLowerCase());
            if (m.matches()) {
                if (!(projname = projname.toLowerCase()).equals(m.group(1)) && warn.booleanValue()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The projection ''{0}'' in URL and current projection ''{1}'' mismatch.\nThis may lead to wrong coordinates.", (Object[])new Object[]{m.group(1), projname}), I18n.tr((String)"Warning"), 2);
                }
            } else {
                res = "&srs=" + projname;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return res;
    }

    public boolean loadFromCache(WMSRequest request) {
        URL url = null;
        try {
            url = this.getURL(this.b.min.east(), this.b.min.north(), this.b.max.east(), this.b.max.north(), this.width(), this.height());
        }
        catch (Exception e) {
            return false;
        }
        BufferedImage cached = this.cache.getImg(url.toString());
        if (!request.isReal() && !this.layer.hasAutoDownload() || cached != null) {
            if (cached == null) {
                request.finish(GeorefImage.State.NOT_IN_CACHE, null);
                return true;
            }
            request.finish(GeorefImage.State.IMAGE, cached);
            return true;
        }
        return false;
    }

    protected BufferedImage grab(URL url) throws IOException, OsmTransferException {
        System.out.println("Grabbing WMS " + url);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (this.layer.getInfo().getCookies() != null && !this.layer.getInfo().getCookies().equals("")) {
            conn.setRequestProperty("Cookie", this.layer.getInfo().getCookies());
        }
        conn.setRequestProperty("User-Agent", Main.pref.get("imagery.wms.user_agent", Version.getInstance().getAgentString()));
        conn.setConnectTimeout(Main.pref.getInteger("imagery.wms.timeout.connect", 30) * 1000);
        conn.setReadTimeout(Main.pref.getInteger("imagery.wms.timeout.read", 30) * 1000);
        String contentType = conn.getHeaderField("Content-Type");
        if (conn.getResponseCode() != 200 || contentType != null && !contentType.startsWith("image")) {
            throw new IOException(this.readException(conn));
        }
        ProgressInputStream is = new ProgressInputStream((URLConnection)conn, null);
        BufferedImage img = ImageIO.read((InputStream)is);
        is.close();
        this.cache.saveImg(url.toString(), img);
        return img;
    }

    protected String readException(URLConnection conn) throws IOException {
        StringBuilder exception = new StringBuilder();
        InputStream in = conn.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = br.readLine()) != null) {
            exception.append(line.replaceAll("[^\\p{Print}]", ""));
            exception.append('\n');
        }
        return exception.toString();
    }
}

