/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery.tms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.plugins.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.imagery.ImageryPlugin;
import org.openstreetmap.josm.plugins.imagery.tms.TMSPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMSTileSourceProvider
implements SlippyMapBBoxChooser.TileSourceProvider {
    static final HashSet<String> existingSlippyMapUrls = new HashSet();

    public List<TileSource> getTileSources() {
        if (!TMSPreferences.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get()) {
            return Collections.emptyList();
        }
        ArrayList<TileSource> sources = new ArrayList<TileSource>();
        for (ImageryInfo info : ImageryPlugin.instance.info.getLayers()) {
            TileSource source;
            if (existingSlippyMapUrls.contains(info.getURL()) || (source = TMSPreferences.getTileSource(info)) == null) continue;
            sources.add(source);
        }
        return sources;
    }

    public static void addExistingSlippyMapUrl(String url) {
        existingSlippyMapUrls.add(url);
    }

    static {
        existingSlippyMapUrls.add("http://tile.openstreetmap.org");
        existingSlippyMapUrls.add("http://tah.openstreetmap.org/Tiles");
        existingSlippyMapUrls.add("http://tile.opencyclemap.org/cycle");
    }
}

