/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.plugins.imagery.OffsetBookmark;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class OffsetBookmarksPanel
extends JPanel {
    List<OffsetBookmark> bookmarks = OffsetBookmark.allBookmarks;
    OffsetsBookmarksModel model = new OffsetsBookmarksModel();

    public OffsetBookmarksPanel(final PreferenceTabbedPane gui) {
        super(new GridBagLayout());
        final JTable list = new JTable(this.model){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                return OffsetBookmarksPanel.this.model.getValueAt(this.rowAtPoint(p), this.columnAtPoint(p)).toString();
            }
        };
        JScrollPane scroll = new JScrollPane(list);
        this.add((Component)scroll, GBC.eol().fill(1));
        scroll.setPreferredSize(new Dimension(200, 200));
        TableColumnModel mod = list.getColumnModel();
        mod.getColumn(0).setPreferredWidth(150);
        mod.getColumn(1).setPreferredWidth(200);
        mod.getColumn(2).setPreferredWidth(300);
        mod.getColumn(3).setPreferredWidth(150);
        mod.getColumn(4).setPreferredWidth(150);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton add = new JButton(I18n.tr((String)"Add"));
        buttonPanel.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OffsetBookmark b = new OffsetBookmark(Main.proj, "", "", 0.0, 0.0);
                OffsetBookmarksPanel.this.model.addRow(b);
            }
        });
        JButton delete = new JButton(I18n.tr((String)"Delete"));
        buttonPanel.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (list.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select the row to delete."));
                } else {
                    Integer i;
                    while ((i = Integer.valueOf(list.getSelectedRow())) != -1) {
                        OffsetBookmarksPanel.this.model.removeRow(i);
                    }
                }
            }
        });
        this.add((Component)buttonPanel, GBC.eol());
    }

    class OffsetsBookmarksModel
    extends DefaultTableModel {
        public OffsetsBookmarksModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr((String)"Projection"), I18n.tr((String)"Layer"), I18n.tr((String)"Name"), I18n.tr((String)"Easting"), I18n.tr((String)"Northing")});
        }

        public OffsetBookmark getRow(int row) {
            return OffsetBookmarksPanel.this.bookmarks.get(row);
        }

        public void addRow(OffsetBookmark i) {
            OffsetBookmarksPanel.this.bookmarks.add(i);
            int p = this.getRowCount() - 1;
            this.fireTableRowsInserted(p, p);
        }

        public void removeRow(int i) {
            OffsetBookmarksPanel.this.bookmarks.remove(this.getRow(i));
            this.fireTableRowsDeleted(i, i);
        }

        public int getRowCount() {
            return OffsetBookmarksPanel.this.bookmarks.size();
        }

        public Object getValueAt(int row, int column) {
            OffsetBookmark info = OffsetBookmarksPanel.this.bookmarks.get(row);
            switch (column) {
                case 0: {
                    return info.proj.toString();
                }
                case 1: {
                    return info.layerName;
                }
                case 2: {
                    return info.name;
                }
                case 3: {
                    return info.dx;
                }
                case 4: {
                    return info.dy;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public void setValueAt(Object o, int row, int column) {
            OffsetBookmark info = OffsetBookmarksPanel.this.bookmarks.get(row);
            switch (column) {
                case 1: {
                    info.layerName = o.toString();
                    break;
                }
                case 2: {
                    info.name = o.toString();
                    break;
                }
                case 3: {
                    info.dx = Double.parseDouble((String)o);
                    break;
                }
                case 4: {
                    info.dy = Double.parseDouble((String)o);
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException();
                }
            }
        }

        public boolean isCellEditable(int row, int column) {
            return column >= 1;
        }
    }
}

