/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.plugins.imagery.ImageryPlugin;
import org.openstreetmap.josm.plugins.imagery.ImageryPreferences;
import org.openstreetmap.josm.plugins.imagery.ImageryProvidersPanel;
import org.openstreetmap.josm.plugins.imagery.OffsetBookmark;
import org.openstreetmap.josm.plugins.imagery.OffsetBookmarksPanel;
import org.openstreetmap.josm.plugins.imagery.tms.TMSPreferences;
import org.openstreetmap.josm.plugins.imagery.wms.WMSAdapter;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ImageryPreferenceEditor
implements PreferenceSetting {
    ImageryProvidersPanel imageryProviders;
    WMSAdapter wmsAdapter = ImageryPlugin.wmsAdapter;
    ImageryPlugin plugin = ImageryPlugin.instance;
    private Color colFadeColor;
    private JButton btnFadeColor;
    private JSlider fadeAmount = new JSlider(0, 100);
    private JCheckBox remoteCheckBox;
    private JComboBox sharpen;
    private boolean allowRemoteControl = true;
    private JComboBox browser;
    JCheckBox overlapCheckBox;
    JSpinner spinEast;
    JSpinner spinNorth;
    JSpinner spinSimConn;
    private JCheckBox autozoomActive = new JCheckBox();
    private JCheckBox autoloadTiles = new JCheckBox();
    private JSpinner minZoomLvl;
    private JSpinner maxZoomLvl;
    private JCheckBox addToSlippyMapChosser = new JCheckBox();

    private JPanel buildCommonSettingsPanel(final PreferenceTabbedPane gui) {
        JPanel p = new JPanel(new GridBagLayout());
        this.colFadeColor = ImageryPreferences.getFadeColor();
        this.btnFadeColor = new JButton();
        this.btnFadeColor.setBackground(this.colFadeColor);
        this.btnFadeColor.setText(ColorHelper.color2html((Color)this.colFadeColor));
        this.btnFadeColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JColorChooser chooser = new JColorChooser(ImageryPreferenceEditor.this.colFadeColor);
                int answer = JOptionPane.showConfirmDialog((Component)gui, chooser, I18n.tr((String)"Choose a color for {0}", (Object[])new Object[]{I18n.tr((String)"imagery fade")}), 2, -1);
                if (answer == 0) {
                    ImageryPreferenceEditor.this.colFadeColor = chooser.getColor();
                    ImageryPreferenceEditor.this.btnFadeColor.setBackground(ImageryPreferenceEditor.this.colFadeColor);
                    ImageryPreferenceEditor.this.btnFadeColor.setText(ColorHelper.color2html((Color)ImageryPreferenceEditor.this.colFadeColor));
                }
            }
        });
        p.add((Component)new JLabel(I18n.tr((String)"Fade Color: ")), GBC.std());
        p.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        p.add((Component)this.btnFadeColor, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr((String)"Fade amount: ")), GBC.std());
        p.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        p.add((Component)this.fadeAmount, GBC.eol().fill(2));
        this.fadeAmount.setValue(ImageryPreferences.PROP_FADE_AMOUNT.get());
        this.allowRemoteControl = ImageryPreferences.PROP_REMOTE_CONTROL.get();
        this.remoteCheckBox = new JCheckBox(I18n.tr((String)"Allow remote control (reqires remotecontrol plugin)"), this.allowRemoteControl);
        p.add((Component)this.remoteCheckBox, GBC.eol().fill(2));
        this.sharpen = new JComboBox<String>(new String[]{I18n.tr((String)"None"), I18n.tr((String)"Soft"), I18n.tr((String)"Strong")});
        p.add(new JLabel(I18n.tr((String)"Sharpen (requires layer re-add): ")));
        p.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        p.add((Component)this.sharpen, GBC.std().fill(2));
        this.sharpen.setSelectedIndex(ImageryPreferences.PROP_SHARPEN_LEVEL.get());
        return p;
    }

    private JPanel buildWMSSettingsPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.browser = new JComboBox<String>(new String[]{"webkit-image {0}", "gnome-web-photo --mode=photo --format=png {0} /dev/stdout", "gnome-web-photo-fixed {0}", "webkit-image-gtk {0}"});
        this.browser.setEditable(true);
        this.browser.setSelectedItem(this.wmsAdapter.PROP_BROWSER.get());
        p.add((Component)new JLabel(I18n.tr((String)"Downloader:")), GBC.eol().fill(2));
        p.add(this.browser);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        this.overlapCheckBox = new JCheckBox(I18n.tr((String)"Overlap tiles"), this.wmsAdapter.PROP_OVERLAP.get());
        JLabel labelEast = new JLabel(I18n.tr((String)"% of east:"));
        JLabel labelNorth = new JLabel(I18n.tr((String)"% of north:"));
        this.spinEast = new JSpinner(new SpinnerNumberModel(this.wmsAdapter.PROP_OVERLAP_EAST.get(), 1, 50, 1));
        this.spinNorth = new JSpinner(new SpinnerNumberModel(this.wmsAdapter.PROP_OVERLAP_NORTH.get(), 1, 50, 1));
        JPanel overlapPanel = new JPanel(new FlowLayout());
        overlapPanel.add(this.overlapCheckBox);
        overlapPanel.add(labelEast);
        overlapPanel.add(this.spinEast);
        overlapPanel.add(labelNorth);
        overlapPanel.add(this.spinNorth);
        p.add(overlapPanel);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        JLabel labelSimConn = new JLabel(I18n.tr((String)"Simultaneous connections"));
        this.spinSimConn = new JSpinner(new SpinnerNumberModel(this.wmsAdapter.PROP_SIMULTANEOUS_CONNECTIONS.get(), 1, 30, 1));
        JPanel overlapPanelSimConn = new JPanel(new FlowLayout(0));
        overlapPanelSimConn.add(labelSimConn);
        overlapPanelSimConn.add(this.spinSimConn);
        p.add((Component)overlapPanelSimConn, GBC.eol().fill(2));
        return p;
    }

    private JPanel buildTMSSettingsPanel() {
        JPanel tmsTab = new JPanel(new GridBagLayout());
        this.minZoomLvl = new JSpinner(new SpinnerNumberModel(2, 2, 30, 1));
        this.maxZoomLvl = new JSpinner(new SpinnerNumberModel(18, 2, 30, 1));
        tmsTab.add((Component)new JLabel(I18n.tr((String)"Auto zoom by default: ")), GBC.std());
        tmsTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        tmsTab.add((Component)this.autozoomActive, GBC.eol().fill(2));
        tmsTab.add((Component)new JLabel(I18n.tr((String)"Autoload tiles by default: ")), GBC.std());
        tmsTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        tmsTab.add((Component)this.autoloadTiles, GBC.eol().fill(2));
        tmsTab.add((Component)new JLabel(I18n.tr((String)"Min zoom lvl: ")), GBC.std());
        tmsTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        tmsTab.add((Component)this.minZoomLvl, GBC.eol().fill(2));
        tmsTab.add((Component)new JLabel(I18n.tr((String)"Max zoom lvl: ")), GBC.std());
        tmsTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        tmsTab.add((Component)this.maxZoomLvl, GBC.eol().fill(2));
        tmsTab.add((Component)new JLabel(I18n.tr((String)"Add to slippymap chooser: ")), GBC.std());
        tmsTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        tmsTab.add((Component)this.addToSlippyMapChosser, GBC.eol().fill(2));
        this.autozoomActive.setSelected(TMSPreferences.PROP_DEFAULT_AUTOZOOM.get());
        this.autoloadTiles.setSelected(TMSPreferences.PROP_DEFAULT_AUTOLOAD.get());
        this.addToSlippyMapChosser.setSelected(TMSPreferences.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get());
        this.maxZoomLvl.setValue(TMSPreferences.getMaxZoomLvl(null));
        this.minZoomLvl.setValue(TMSPreferences.getMinZoomLvl(null));
        return tmsTab;
    }

    private void addSettingsSection(JPanel p, String name, JPanel section) {
        JLabel lbl = new JLabel(name);
        lbl.setFont(lbl.getFont().deriveFont(1));
        p.add((Component)lbl, GBC.std());
        p.add((Component)new JSeparator(), GBC.eol().fill(2).insets(5, 0, 0, 0));
        p.add((Component)section, GBC.eol().insets(20, 5, 0, 10));
    }

    private Component buildSettingsPanel(PreferenceTabbedPane gui) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addSettingsSection(p, I18n.tr((String)"Common Settings"), this.buildCommonSettingsPanel(gui));
        this.addSettingsSection(p, I18n.tr((String)"WMS Settings"), this.buildWMSSettingsPanel());
        this.addSettingsSection(p, I18n.tr((String)"TMS Settings"), this.buildTMSSettingsPanel());
        p.add((Component)new JPanel(), GBC.eol().fill(1));
        return new JScrollPane(p);
    }

    public void addGui(PreferenceTabbedPane gui) {
        JPanel p = gui.createPreferenceTab("imagery", I18n.tr((String)"Imagery Preferences"), I18n.tr((String)"Modify list of imagery layers displayed in the Imagery menu"));
        JTabbedPane pane = new JTabbedPane();
        this.imageryProviders = new ImageryProvidersPanel(gui, this.plugin.info);
        pane.add(this.imageryProviders);
        pane.add(this.buildSettingsPanel(gui));
        pane.add(new OffsetBookmarksPanel(gui));
        pane.setTitleAt(0, I18n.tr((String)"Imagery providers"));
        pane.setTitleAt(1, I18n.tr((String)"Settings"));
        pane.setTitleAt(2, I18n.tr((String)"Offset bookmarks"));
        p.add((Component)pane, GBC.std().fill(1));
    }

    public boolean ok() {
        boolean restartRequired = false;
        this.plugin.info.save();
        this.plugin.refreshMenu();
        OffsetBookmark.saveBookmarks();
        this.wmsAdapter.PROP_OVERLAP.put(this.overlapCheckBox.getModel().isSelected());
        this.wmsAdapter.PROP_OVERLAP_EAST.put(((Integer)this.spinEast.getModel().getValue()).intValue());
        this.wmsAdapter.PROP_OVERLAP_NORTH.put(((Integer)this.spinNorth.getModel().getValue()).intValue());
        this.wmsAdapter.PROP_SIMULTANEOUS_CONNECTIONS.put(((Integer)this.spinSimConn.getModel().getValue()).intValue());
        this.allowRemoteControl = this.remoteCheckBox.getModel().isSelected();
        Main.pref.put("imagery.wms.browser", this.browser.getEditor().getItem().toString());
        if (TMSPreferences.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get() != this.addToSlippyMapChosser.isSelected()) {
            restartRequired = true;
        }
        TMSPreferences.PROP_ADD_TO_SLIPPYMAP_CHOOSER.put(this.addToSlippyMapChosser.isSelected());
        TMSPreferences.PROP_DEFAULT_AUTOZOOM.put(this.autozoomActive.isSelected());
        TMSPreferences.PROP_DEFAULT_AUTOLOAD.put(this.autoloadTiles.isSelected());
        TMSPreferences.setMaxZoomLvl((Integer)this.maxZoomLvl.getValue());
        TMSPreferences.setMinZoomLvl((Integer)this.minZoomLvl.getValue());
        ImageryPreferences.PROP_FADE_AMOUNT.put(this.fadeAmount.getValue());
        ImageryPreferences.setFadeColor(this.colFadeColor);
        ImageryPreferences.PROP_REMOTE_CONTROL.put(this.allowRemoteControl);
        ImageryPreferences.PROP_SHARPEN_LEVEL.put(this.sharpen.getSelectedIndex());
        return restartRequired;
    }

    public void setServerUrl(String server, String url) {
        for (int i = 0; i < this.imageryProviders.model.getRowCount(); ++i) {
            if (!server.equals(this.imageryProviders.model.getValueAt(i, 0).toString())) continue;
            this.imageryProviders.model.setValueAt(url, i, 1);
            return;
        }
        this.imageryProviders.model.addRow(new String[]{server, url});
    }

    public String getServerUrl(String server) {
        for (int i = 0; i < this.imageryProviders.model.getRowCount(); ++i) {
            if (!server.equals(this.imageryProviders.model.getValueAt(i, 0).toString())) continue;
            return this.imageryProviders.model.getValueAt(i, 1).toString();
        }
        return null;
    }
}

