/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.imagery.ImageryPlugin;
import org.openstreetmap.josm.plugins.imagery.OffsetBookmark;
import org.openstreetmap.josm.plugins.imagery.tms.TMSLayer;
import org.openstreetmap.josm.plugins.imagery.wms.WMSLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class ImageryLayer
extends Layer {
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ImageryPlugin.class.getResource("/images/imagery_small.png")));
    protected final ImageryInfo info;
    protected MapView mv;
    protected double dx = 0.0;
    protected double dy = 0.0;

    public ImageryLayer(ImageryInfo info) {
        super(info.getName());
        this.info = info;
        this.mv = Main.map.mapView;
    }

    public double getPPD() {
        ProjectionBounds bounds = this.mv.getProjectionBounds();
        return (double)this.mv.getWidth() / (bounds.max.east() - bounds.min.east());
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void setOffset(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public void displace(double dx, double dy) {
        this.setOffset(this.dx += dx, this.dy += dy);
    }

    public ImageryInfo getInfo() {
        return this.info;
    }

    public Icon getIcon() {
        return icon;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public static ImageryLayer create(ImageryInfo info) {
        if (info.imageryType == ImageryInfo.ImageryType.WMS || info.imageryType == ImageryInfo.ImageryType.HTML) {
            return new WMSLayer(info);
        }
        if (info.imageryType == ImageryInfo.ImageryType.TMS || info.imageryType == ImageryInfo.ImageryType.BING) {
            return new TMSLayer(info);
        }
        throw new AssertionError();
    }

    public Action getOffsetAction() {
        return new OffsetAction();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OffsetAction
    extends AbstractAction
    implements Layer.LayerAction {
        OffsetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public Component createMenuComponent() {
            JMenu menu = new JMenu(I18n.trc((String)"layer", (String)"Offset"));
            menu.setIcon(ImageProvider.get((String)"mapmode", (String)"adjustimg"));
            boolean haveCurrent = false;
            for (OffsetBookmark b : OffsetBookmark.allBookmarks) {
                if (!b.isUsable(ImageryLayer.this)) continue;
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(new ApplyOffsetAction(b));
                if (b.dx == ImageryLayer.this.dx && b.dy == ImageryLayer.this.dy) {
                    item.setSelected(true);
                    haveCurrent = true;
                }
                menu.add(item);
            }
            if (!haveCurrent) {
                menu.insert(new NewBookmarkAction(), 0);
            }
            return menu;
        }

        public boolean supportLayers(List<Layer> layers) {
            return false;
        }
    }

    class NewBookmarkAction
    extends AbstractAction {
        public NewBookmarkAction() {
            super(I18n.tr((String)"(save current)"));
        }

        public void actionPerformed(ActionEvent arg0) {
            BookmarkNamePanel p = new BookmarkNamePanel();
            int answer = JOptionPane.showConfirmDialog(Main.parent, p, I18n.tr((String)"Add offset bookmark"), 2);
            if (answer == 0) {
                OffsetBookmark b = new OffsetBookmark(Main.proj, ImageryLayer.this.info.getName(), p.text.getText(), ImageryLayer.this.getDx(), ImageryLayer.this.getDy());
                OffsetBookmark.allBookmarks.add(b);
                OffsetBookmark.saveBookmarks();
            }
        }

        private class BookmarkNamePanel
        extends JPanel {
            public JTextField text;

            public BookmarkNamePanel() {
                super(new GridBagLayout());
                this.text = new JTextField();
                this.add((Component)new JLabel(I18n.tr((String)"Bookmark name: ")), GBC.eol());
                this.add((Component)this.text, GBC.eol().fill(2));
            }
        }
    }

    class ApplyOffsetAction
    extends AbstractAction {
        private OffsetBookmark b;

        ApplyOffsetAction(OffsetBookmark b) {
            super(b.name);
            this.b = b;
        }

        public void actionPerformed(ActionEvent arg0) {
            ImageryLayer.this.setOffset(this.b.dx, this.b.dy);
            Main.map.repaint();
        }
    }
}

