/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.plugins.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.imagery.ImageryPlugin;
import org.openstreetmap.josm.plugins.imagery.ImageryPreferences;
import org.openstreetmap.josm.plugins.imagery.tms.TMSPreferences;
import org.openstreetmap.josm.plugins.imagery.wms.AddWMSLayerPanel;
import org.openstreetmap.josm.plugins.imagery.wms.WMSAdapter;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ImageryPreferenceEditor
implements PreferenceSetting {
    private ImageryLayerTableModel model;
    private JComboBox browser;
    private Color colFadeColor;
    private JButton btnFadeColor;
    private JSlider fadeAmount = new JSlider(0, 100);
    private JCheckBox remoteCheckBox;
    boolean allowRemoteControl = true;
    JCheckBox overlapCheckBox;
    JSpinner spinEast;
    JSpinner spinNorth;
    JSpinner spinSimConn;
    WMSAdapter wmsAdapter = ImageryPlugin.wmsAdapter;
    ImageryPlugin plugin = ImageryPlugin.instance;
    private JCheckBox autozoomActive = new JCheckBox();
    private JCheckBox autoloadTiles = new JCheckBox();
    private JSpinner minZoomLvl;
    private JSpinner maxZoomLvl;

    private JPanel buildImageryProvidersPanel(final PreferenceTabbedPane gui) {
        JPanel p = new JPanel(new GridBagLayout());
        this.model = new ImageryLayerTableModel();
        final JTable list = new JTable(this.model){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                return ImageryPreferenceEditor.this.model.getValueAt(this.rowAtPoint(p), this.columnAtPoint(p)).toString();
            }
        };
        JScrollPane scroll = new JScrollPane(list);
        p.add((Component)scroll, GBC.eol().fill(1));
        scroll.setPreferredSize(new Dimension(200, 200));
        final ImageryDefaultLayerTableModel modeldef = new ImageryDefaultLayerTableModel();
        final JTable listdef = new JTable(modeldef){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                return (String)modeldef.getValueAt(this.rowAtPoint(p), this.columnAtPoint(p));
            }
        };
        JScrollPane scrolldef = new JScrollPane(listdef);
        scrolldef.setPreferredSize(new Dimension(200, 200));
        TableColumnModel mod = listdef.getColumnModel();
        mod.getColumn(1).setPreferredWidth(800);
        mod.getColumn(0).setPreferredWidth(200);
        mod = list.getColumnModel();
        mod.getColumn(2).setPreferredWidth(50);
        mod.getColumn(1).setPreferredWidth(800);
        mod.getColumn(0).setPreferredWidth(200);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton add = new JButton(I18n.tr((String)"Add"));
        buttonPanel.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddWMSLayerPanel p = new AddWMSLayerPanel();
                int answer = JOptionPane.showConfirmDialog((Component)gui, p, I18n.tr((String)"Add Imagery URL"), 2);
                if (answer == 0) {
                    ImageryPreferenceEditor.this.model.addRow(new ImageryInfo(p.getUrlName(), p.getUrl()));
                }
            }
        });
        JButton delete = new JButton(I18n.tr((String)"Delete"));
        buttonPanel.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (list.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select the row to delete."));
                } else {
                    Integer i;
                    while ((i = Integer.valueOf(list.getSelectedRow())) != -1) {
                        ImageryPreferenceEditor.this.model.removeRow(i);
                    }
                }
            }
        });
        JButton copy = new JButton(I18n.tr((String)"Copy Selected Default(s)"));
        buttonPanel.add((Component)copy, GBC.std().insets(0, 5, 0, 0));
        copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] lines = listdef.getSelectedRows();
                if (lines.length == 0) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select at least one row to copy."), I18n.tr((String)"Information"), 1);
                    return;
                }
                block0: for (int i = 0; i < lines.length; ++i) {
                    ImageryInfo info = modeldef.getRow(lines[i]);
                    for (int j = 0; j < ImageryPreferenceEditor.this.model.getRowCount(); ++j) {
                        if (!info.equalsBaseValues(ImageryPreferenceEditor.this.model.getRow(j))) continue;
                        list.getSelectionModel().setSelectionInterval(j, j);
                        list.scrollRectToVisible(list.getCellRect(j, 0, true));
                        continue block0;
                    }
                    if (info.eulaAcceptanceRequired != null && !ImageryPreferenceEditor.this.confirmeEulaAcceptance(gui, info.eulaAcceptanceRequired)) continue;
                    ImageryPreferenceEditor.this.model.addRow(new ImageryInfo(info));
                    int lastLine = ImageryPreferenceEditor.this.model.getRowCount() - 1;
                    list.getSelectionModel().setSelectionInterval(lastLine, lastLine);
                    list.scrollRectToVisible(list.getCellRect(lastLine, 0, true));
                }
            }
        });
        p.add(buttonPanel);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        p.add((Component)scrolldef, GBC.eol().insets(0, 5, 0, 0).fill(1));
        return p;
    }

    private JPanel buildCommonSettingsPanel(final PreferenceTabbedPane gui) {
        JPanel p = new JPanel(new GridBagLayout());
        this.colFadeColor = ImageryPreferences.getFadeColor();
        this.btnFadeColor = new JButton();
        this.btnFadeColor.setBackground(this.colFadeColor);
        this.btnFadeColor.setText(ColorHelper.color2html((Color)this.colFadeColor));
        this.btnFadeColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JColorChooser chooser = new JColorChooser(ImageryPreferenceEditor.this.colFadeColor);
                int answer = JOptionPane.showConfirmDialog((Component)gui, chooser, I18n.tr((String)"Choose a color for {0}", (Object[])new Object[]{I18n.tr((String)"imagery fade")}), 2, -1);
                if (answer == 0) {
                    ImageryPreferenceEditor.this.colFadeColor = chooser.getColor();
                    ImageryPreferenceEditor.this.btnFadeColor.setBackground(ImageryPreferenceEditor.this.colFadeColor);
                    ImageryPreferenceEditor.this.btnFadeColor.setText(ColorHelper.color2html((Color)ImageryPreferenceEditor.this.colFadeColor));
                }
            }
        });
        p.add((Component)new JLabel(I18n.tr((String)"Fade Color: ")), GBC.std());
        p.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        p.add((Component)this.btnFadeColor, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr((String)"Fade amount: ")), GBC.std());
        p.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        p.add((Component)this.fadeAmount, GBC.eol().fill(2));
        this.fadeAmount.setValue(ImageryPreferences.PROP_FADE_AMOUNT.get());
        this.allowRemoteControl = ImageryPreferences.PROP_REMOTE_CONTROL.get();
        this.remoteCheckBox = new JCheckBox(I18n.tr((String)"Allow remote control (reqires remotecontrol plugin)"), this.allowRemoteControl);
        p.add((Component)this.remoteCheckBox, GBC.eol().fill(2));
        return p;
    }

    private JPanel buildWMSSettingsPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.browser = new JComboBox<String>(new String[]{"webkit-image {0}", "gnome-web-photo --mode=photo --format=png {0} /dev/stdout", "gnome-web-photo-fixed {0}", "webkit-image-gtk {0}"});
        this.browser.setEditable(true);
        this.browser.setSelectedItem(Main.pref.get("wmsplugin.browser", "webkit-image {0}"));
        p.add((Component)new JLabel(I18n.tr((String)"Downloader:")), GBC.eol().fill(2));
        p.add(this.browser);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        this.overlapCheckBox = new JCheckBox(I18n.tr((String)"Overlap tiles"), this.wmsAdapter.PROP_OVERLAP.get());
        JLabel labelEast = new JLabel(I18n.tr((String)"% of east:"));
        JLabel labelNorth = new JLabel(I18n.tr((String)"% of north:"));
        this.spinEast = new JSpinner(new SpinnerNumberModel(this.wmsAdapter.PROP_OVERLAP_EAST.get(), 1, 50, 1));
        this.spinNorth = new JSpinner(new SpinnerNumberModel(this.wmsAdapter.PROP_OVERLAP_NORTH.get(), 1, 50, 1));
        JPanel overlapPanel = new JPanel(new FlowLayout());
        overlapPanel.add(this.overlapCheckBox);
        overlapPanel.add(labelEast);
        overlapPanel.add(this.spinEast);
        overlapPanel.add(labelNorth);
        overlapPanel.add(this.spinNorth);
        p.add(overlapPanel);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        JLabel labelSimConn = new JLabel(I18n.tr((String)"Simultaneous connections"));
        this.spinSimConn = new JSpinner(new SpinnerNumberModel(this.wmsAdapter.PROP_SIMULTANEOUS_CONNECTIONS.get(), 1, 30, 1));
        JPanel overlapPanelSimConn = new JPanel(new FlowLayout(0));
        overlapPanelSimConn.add(labelSimConn);
        overlapPanelSimConn.add(this.spinSimConn);
        p.add((Component)overlapPanelSimConn, GBC.eol().fill(2));
        return p;
    }

    private JPanel buildTMSSettingsPanel() {
        JPanel tmsTab = new JPanel(new GridBagLayout());
        this.minZoomLvl = new JSpinner(new SpinnerNumberModel(2, 2, 30, 1));
        this.maxZoomLvl = new JSpinner(new SpinnerNumberModel(18, 2, 30, 1));
        tmsTab.add((Component)new JLabel(I18n.tr((String)"Auto zoom by default: ")), GBC.std());
        tmsTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        tmsTab.add((Component)this.autozoomActive, GBC.eol().fill(2));
        tmsTab.add((Component)new JLabel(I18n.tr((String)"Autoload tiles by default: ")), GBC.std());
        tmsTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        tmsTab.add((Component)this.autoloadTiles, GBC.eol().fill(2));
        tmsTab.add((Component)new JLabel(I18n.tr((String)"Min zoom lvl: ")), GBC.std());
        tmsTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        tmsTab.add((Component)this.minZoomLvl, GBC.eol().fill(2));
        tmsTab.add((Component)new JLabel(I18n.tr((String)"Max zoom lvl: ")), GBC.std());
        tmsTab.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        tmsTab.add((Component)this.maxZoomLvl, GBC.eol().fill(2));
        tmsTab.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.autozoomActive.setSelected(TMSPreferences.PROP_DEFAULT_AUTOZOOM.get());
        this.autoloadTiles.setSelected(TMSPreferences.PROP_DEFAULT_AUTOLOAD.get());
        this.maxZoomLvl.setValue(TMSPreferences.getMaxZoomLvl(null));
        this.minZoomLvl.setValue(TMSPreferences.getMinZoomLvl(null));
        return tmsTab;
    }

    private void addSettingsSection(JPanel p, String name, JPanel section) {
        JLabel lbl = new JLabel(name);
        lbl.setFont(lbl.getFont().deriveFont(1));
        p.add((Component)lbl, GBC.std());
        p.add((Component)new JSeparator(), GBC.eol().fill(2).insets(5, 0, 0, 0));
        p.add((Component)section, GBC.eol().insets(20, 5, 0, 10));
    }

    private Component buildSettingsPanel(PreferenceTabbedPane gui) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addSettingsSection(p, I18n.tr((String)"Common Settings"), this.buildCommonSettingsPanel(gui));
        this.addSettingsSection(p, I18n.tr((String)"WMS Settings"), this.buildWMSSettingsPanel());
        this.addSettingsSection(p, I18n.tr((String)"TMS Settings"), this.buildTMSSettingsPanel());
        p.add((Component)new JPanel(), GBC.eol().fill(1));
        return new JScrollPane(p);
    }

    public void addGui(PreferenceTabbedPane gui) {
        JPanel p = gui.createPreferenceTab("imagery", I18n.tr((String)"Imagery Preferences"), I18n.tr((String)"Modify list of imagery layers displayed in the Imagery menu"));
        JTabbedPane pane = new JTabbedPane();
        pane.add(this.buildImageryProvidersPanel(gui));
        pane.add(this.buildSettingsPanel(gui));
        pane.setTitleAt(0, I18n.tr((String)"Imagery providers"));
        pane.setTitleAt(1, I18n.tr((String)"Settings"));
        p.add((Component)pane, GBC.std().fill(1));
    }

    public boolean ok() {
        this.plugin.info.save();
        this.plugin.refreshMenu();
        this.wmsAdapter.PROP_OVERLAP.put(this.overlapCheckBox.getModel().isSelected());
        this.wmsAdapter.PROP_OVERLAP_EAST.put(((Integer)this.spinEast.getModel().getValue()).intValue());
        this.wmsAdapter.PROP_OVERLAP_NORTH.put(((Integer)this.spinNorth.getModel().getValue()).intValue());
        this.wmsAdapter.PROP_SIMULTANEOUS_CONNECTIONS.put(((Integer)this.spinSimConn.getModel().getValue()).intValue());
        this.allowRemoteControl = this.remoteCheckBox.getModel().isSelected();
        Main.pref.put("wmsplugin.browser", this.browser.getEditor().getItem().toString());
        TMSPreferences.PROP_DEFAULT_AUTOZOOM.put(this.autozoomActive.isSelected());
        TMSPreferences.PROP_DEFAULT_AUTOLOAD.put(this.autoloadTiles.isSelected());
        TMSPreferences.setMaxZoomLvl((Integer)this.maxZoomLvl.getValue());
        TMSPreferences.setMinZoomLvl((Integer)this.minZoomLvl.getValue());
        ImageryPreferences.PROP_REMOTE_CONTROL.put(this.allowRemoteControl);
        ImageryPreferences.PROP_FADE_AMOUNT.put(this.fadeAmount.getValue());
        ImageryPreferences.setFadeColor(this.colFadeColor);
        return false;
    }

    public void setServerUrl(String server, String url) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!server.equals(this.model.getValueAt(i, 0).toString())) continue;
            this.model.setValueAt(url, i, 1);
            return;
        }
        this.model.addRow(new String[]{server, url});
    }

    public String getServerUrl(String server) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!server.equals(this.model.getValueAt(i, 0).toString())) continue;
            return this.model.getValueAt(i, 1).toString();
        }
        return null;
    }

    private boolean confirmeEulaAcceptance(PreferenceTabbedPane gui, String eulaUrl) {
        URL url = null;
        try {
            url = new URL(eulaUrl.replaceAll("\\{lang\\}", Locale.getDefault().toString()));
            JEditorPane htmlPane = null;
            try {
                htmlPane = new JEditorPane(url);
            }
            catch (IOException e1) {
                try {
                    url = new URL(eulaUrl.replaceAll("\\{lang\\}", "en"));
                    htmlPane = new JEditorPane(url);
                }
                catch (IOException e2) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"EULA license URL not available: {0}", (Object[])new Object[]{eulaUrl}));
                    return false;
                }
            }
            Box box = Box.createVerticalBox();
            htmlPane.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(htmlPane);
            scrollPane.setPreferredSize(new Dimension(400, 400));
            box.add(scrollPane);
            int option = JOptionPane.showConfirmDialog(Main.parent, box, I18n.tr((String)"Please abort if you are not sure"), 0, 2);
            if (option == 0) {
                return true;
            }
        }
        catch (MalformedURLException e2) {
            JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Malformed URL for the EULA licence: {0}", (Object[])new Object[]{eulaUrl}));
        }
        return false;
    }

    class ImageryDefaultLayerTableModel
    extends DefaultTableModel {
        public ImageryDefaultLayerTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr((String)"Menu Name (Default)"), I18n.tr((String)"Imagery URL (Default)")});
        }

        public ImageryInfo getRow(int row) {
            return ImageryPreferenceEditor.this.plugin.info.defaultLayers.get(row);
        }

        public int getRowCount() {
            return ImageryPreferenceEditor.this.plugin.info.defaultLayers.size();
        }

        public Object getValueAt(int row, int column) {
            ImageryInfo info = ImageryPreferenceEditor.this.plugin.info.defaultLayers.get(row);
            switch (column) {
                case 0: {
                    return info.name;
                }
                case 1: {
                    return info.getFullURL();
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class ImageryLayerTableModel
    extends DefaultTableModel {
        public ImageryLayerTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr((String)"Menu Name"), I18n.tr((String)"Imagery URL"), I18n.trc((String)"layer", (String)"Zoom")});
        }

        public ImageryInfo getRow(int row) {
            return ImageryPreferenceEditor.this.plugin.info.layers.get(row);
        }

        public void addRow(ImageryInfo i) {
            ImageryPreferenceEditor.this.plugin.info.add(i);
            int p = this.getRowCount() - 1;
            this.fireTableRowsInserted(p, p);
        }

        public void removeRow(int i) {
            ImageryPreferenceEditor.this.plugin.info.remove(this.getRow(i));
            this.fireTableRowsDeleted(i, i);
        }

        public int getRowCount() {
            return ImageryPreferenceEditor.this.plugin.info.layers.size();
        }

        public Object getValueAt(int row, int column) {
            ImageryInfo info = ImageryPreferenceEditor.this.plugin.info.layers.get(row);
            switch (column) {
                case 0: {
                    return info.name;
                }
                case 1: {
                    return info.getFullURL();
                }
                case 2: {
                    return info.imageryType == ImageryInfo.ImageryType.WMS ? (info.pixelPerDegree == 0.0 ? "" : Double.valueOf(info.pixelPerDegree)) : (info.maxZoom == 0 ? "" : Integer.valueOf(info.maxZoom));
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public void setValueAt(Object o, int row, int column) {
            ImageryInfo info = ImageryPreferenceEditor.this.plugin.info.layers.get(row);
            switch (column) {
                case 0: {
                    info.name = (String)o;
                    break;
                }
                case 1: {
                    info.setURL((String)o);
                    break;
                }
                case 2: {
                    info.pixelPerDegree = 0.0;
                    info.maxZoom = 0;
                    try {
                        if (info.imageryType == ImageryInfo.ImageryType.WMS) {
                            info.pixelPerDegree = Double.parseDouble((String)o);
                            break;
                        }
                        info.maxZoom = Integer.parseInt((String)o);
                    }
                    catch (NumberFormatException e) {}
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException();
                }
            }
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }
}

