/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageryInfo
implements Comparable<ImageryInfo> {
    String name;
    String url = null;
    String cookies = null;
    String eulaAcceptanceRequired = null;
    ImageryType imageryType = ImageryType.WMS;
    double pixelPerDegree = 0.0;
    int maxZoom = 0;

    public ImageryInfo(String name) {
        this.name = name;
    }

    public ImageryInfo(String name, String url) {
        this.name = name;
        this.setURL(url);
    }

    public ImageryInfo(String name, String url, String eulaAcceptanceRequired) {
        this.name = name;
        this.setURL(url);
        this.eulaAcceptanceRequired = eulaAcceptanceRequired;
    }

    public ImageryInfo(String name, String url, String eulaAcceptanceRequired, String cookies) {
        this.name = name;
        this.setURL(url);
        this.cookies = cookies;
    }

    public ImageryInfo(String name, String url, String cookies, double pixelPerDegree) {
        this.name = name;
        this.setURL(url);
        this.cookies = cookies;
        this.pixelPerDegree = pixelPerDegree;
    }

    public ArrayList<String> getInfoArray() {
        String e2 = null;
        String e3 = null;
        String e4 = null;
        if (this.url != null && !this.url.isEmpty()) {
            e2 = this.getFullURL();
        }
        if (this.cookies != null && !this.cookies.isEmpty()) {
            e3 = this.cookies;
        }
        if (this.imageryType == ImageryType.WMS) {
            if (this.pixelPerDegree != 0.0) {
                e4 = String.valueOf(this.pixelPerDegree);
            }
        } else if (this.maxZoom != 0) {
            e4 = String.valueOf(this.maxZoom);
        }
        if (e4 != null && e3 == null) {
            e3 = "";
        }
        if (e3 != null && e2 == null) {
            e2 = "";
        }
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.name);
        if (e2 != null) {
            res.add(e2);
        }
        if (e3 != null) {
            res.add(e3);
        }
        if (e4 != null) {
            res.add(e4);
        }
        return res;
    }

    public ImageryInfo(Collection<String> list) {
        ArrayList<String> array = new ArrayList<String>(list);
        this.name = array.get(0);
        if (array.size() >= 2) {
            this.setURL(array.get(1));
        }
        if (array.size() >= 3) {
            this.cookies = array.get(2);
        }
        if (this.imageryType == ImageryType.WMS && array.size() >= 4) {
            this.pixelPerDegree = Double.valueOf(array.get(3));
        }
        if (this.imageryType == ImageryType.TMS && array.size() >= 4) {
            this.maxZoom = Integer.valueOf(array.get(3));
        }
    }

    public ImageryInfo(ImageryInfo i) {
        this.name = i.name;
        this.url = i.url;
        this.cookies = i.cookies;
        this.imageryType = i.imageryType;
        this.pixelPerDegree = i.pixelPerDegree;
    }

    @Override
    public int compareTo(ImageryInfo in) {
        int i = this.name.compareTo(in.name);
        if (i == 0) {
            i = this.url.compareTo(in.url);
        }
        if (i == 0) {
            i = Double.compare(this.pixelPerDegree, in.pixelPerDegree);
        }
        return i;
    }

    public boolean equalsBaseValues(ImageryInfo in) {
        return this.url.equals(in.url);
    }

    public void setPixelPerDegree(double ppd) {
        this.pixelPerDegree = ppd;
    }

    public void setURL(String url) {
        for (ImageryType type : ImageryType.values()) {
            if (!url.startsWith(type.getUrlString() + ":")) continue;
            this.url = url.substring(type.getUrlString().length() + 1);
            this.imageryType = type;
            return;
        }
        this.url = url;
        this.imageryType = ImageryType.WMS;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getURL() {
        return this.url;
    }

    public String getCookies() {
        return this.cookies;
    }

    public double getPixelPerDegree() {
        return this.pixelPerDegree;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public String getFullURL() {
        return this.imageryType.getUrlString() + ":" + this.url;
    }

    public String getToolbarName() {
        String res = this.name;
        if (this.pixelPerDegree != 0.0) {
            res = res + "#PPD=" + this.pixelPerDegree;
        }
        return res;
    }

    public String getMenuName() {
        String res = this.name;
        if (this.pixelPerDegree != 0.0) {
            res = res + " (" + this.pixelPerDegree + ")";
        } else if (this.maxZoom != 0) {
            res = res + " (z" + this.maxZoom + ")";
        }
        return res;
    }

    public ImageryType getImageryType() {
        return this.imageryType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageryType {
        WMS("wms"),
        TMS("tms"),
        HTML("html"),
        BING("bing");

        private String urlString;

        private ImageryType(String urlString) {
            this.urlString = urlString;
        }

        public String getUrlString() {
            return this.urlString;
        }
    }
}

