/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.imagery.ImageryPlugin;
import org.openstreetmap.josm.plugins.imagery.tms.TMSLayer;
import org.openstreetmap.josm.plugins.imagery.wms.WMSLayer;

public abstract class ImageryLayer
extends Layer {
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(ImageryPlugin.class.getResource("/images/imagery_small.png")));
    protected MapView mv;
    protected double dx = 0.0;
    protected double dy = 0.0;

    public ImageryLayer(String name) {
        super(name);
        this.mv = Main.map.mapView;
    }

    public double getPPD() {
        ProjectionBounds bounds = this.mv.getProjectionBounds();
        return (double)this.mv.getWidth() / (bounds.max.east() - bounds.min.east());
    }

    public void displace(double dx, double dy) {
        this.dx += dx;
        this.dy += dy;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public Icon getIcon() {
        return icon;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public static ImageryLayer create(ImageryInfo info) {
        if (info.imageryType == ImageryInfo.ImageryType.WMS || info.imageryType == ImageryInfo.ImageryType.HTML) {
            return new WMSLayer(info);
        }
        if (info.imageryType == ImageryInfo.ImageryType.TMS || info.imageryType == ImageryInfo.ImageryType.BING) {
            return new TMSLayer(info);
        }
        throw new AssertionError();
    }
}

