/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.imagery.ImageryPlugin;
import org.openstreetmap.josm.tools.I18n;

public class ImageryLayerInfo {
    ArrayList<ImageryInfo> layers = new ArrayList();
    ArrayList<ImageryInfo> defaultLayers = new ArrayList();
    private static final String[] DEFAULT_LAYER_SITES = new String[]{"http://josm.openstreetmap.de/maps"};

    public void load() {
        this.layers.clear();
        Collection defaults = Main.pref.getCollection("imagery.layers.default", Collections.emptySet());
        for (Collection c : Main.pref.getArray("imagery.layers", Collections.emptySet())) {
            this.layers.add(new ImageryInfo(c));
        }
        ArrayList<String> defaultsSave = new ArrayList<String>();
        for (String source : Main.pref.getCollection("imagery.layers.sites", Arrays.asList(DEFAULT_LAYER_SITES))) {
            try {
                String line;
                InputStreamReader r;
                MirroredInputStream s = new MirroredInputStream(source, ImageryPlugin.instance.getPluginDir(), -1L);
                try {
                    r = new InputStreamReader((InputStream)s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    r = new InputStreamReader((InputStream)s);
                }
                BufferedReader reader = new BufferedReader(r);
                while ((line = reader.readLine()) != null) {
                    String[] val = line.split(";");
                    if (line.startsWith("#") || val.length != 3 && val.length != 4) continue;
                    boolean force = "true".equals(val[0]);
                    String name = I18n.tr((String)val[1]);
                    String url = val[2];
                    String eulaAcceptanceRequired = null;
                    if (val.length == 4) {
                        eulaAcceptanceRequired = val[3];
                    }
                    this.defaultLayers.add(new ImageryInfo(name, url, eulaAcceptanceRequired));
                    if (!force) continue;
                    defaultsSave.add(url);
                    if (defaults.contains(url)) continue;
                    for (ImageryInfo i : this.layers) {
                        if (!url.equals(i.url)) continue;
                        force = false;
                    }
                    if (!force) continue;
                    this.layers.add(new ImageryInfo(name, url));
                }
            }
            catch (IOException e) {
            }
        }
        Main.pref.putCollection("imagery.layers.default", defaultsSave.size() > 0 ? defaultsSave : defaults);
        Collections.sort(this.layers);
        this.save();
    }

    public void add(ImageryInfo info) {
        this.layers.add(info);
    }

    public void remove(ImageryInfo info) {
        this.layers.remove(info);
    }

    public void save() {
        LinkedList<ArrayList<String>> coll = new LinkedList<ArrayList<String>>();
        for (ImageryInfo info : this.layers) {
            coll.add(info.getInfoArray());
        }
        Main.pref.putArray("imagery.layers", coll);
    }
}

