/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery;

import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.plugins.imagery.AddImageryLayerAction;
import org.openstreetmap.josm.plugins.imagery.ImageryAdjustAction;
import org.openstreetmap.josm.plugins.imagery.ImageryInfo;
import org.openstreetmap.josm.plugins.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.plugins.imagery.ImageryPreferenceEditor;
import org.openstreetmap.josm.plugins.imagery.wms.Map_Rectifier_WMSmenuAction;
import org.openstreetmap.josm.plugins.imagery.wms.WMSAdapter;
import org.openstreetmap.josm.plugins.imagery.wms.WMSLayer;
import org.openstreetmap.josm.plugins.imagery.wms.WMSRemoteHandler;
import org.openstreetmap.josm.plugins.imagery.wms.io.WMSLayerExporter;
import org.openstreetmap.josm.plugins.imagery.wms.io.WMSLayerImporter;
import org.openstreetmap.josm.tools.I18n;

public class ImageryPlugin
extends Plugin {
    JMenu imageryJMenu;
    public static ImageryPlugin instance;
    public static WMSAdapter wmsAdapter;
    public ImageryLayerInfo info = new ImageryLayerInfo();
    private boolean menuEnabled = false;
    private final String REMOTECONTROL_NAME = "remotecontrol";
    final int REMOTECONTROL_MIN_REVISION = 22734;
    final int REMOTECONTROL_NEED_API_MAJOR = 1;
    final int REMOTECONTROL_MIN_API_MINOR = 0;
    boolean remoteControlAvailable = false;
    boolean remoteControlCompatible = true;
    boolean remoteControlInitialized = false;
    int remoteControlRevision = 0;
    int remoteControlApiMajor = 0;
    int remoteControlApiMinor = 0;
    int remoteControlProtocolMajor = 0;
    int remoteControlProtocolMinor = 0;

    private void initRemoteControl() {
        for (PluginProxy pp : PluginHandler.pluginList) {
            PluginInformation info = pp.getPluginInformation();
            if (!"remotecontrol".equals(info.name)) continue;
            this.remoteControlAvailable = true;
            this.remoteControlRevision = Integer.parseInt(info.version);
            if (22734 <= this.remoteControlRevision) continue;
            this.remoteControlCompatible = false;
        }
        if (this.remoteControlAvailable && this.remoteControlCompatible) {
            Plugin plugin = (Plugin)PluginHandler.getPlugin((String)"remotecontrol");
            try {
                int[] versions;
                Method method = plugin.getClass().getMethod("getVersion", new Class[0]);
                Object obj = method.invoke((Object)plugin, new Object[0]);
                if (obj != null && obj instanceof int[] && (versions = (int[])obj).length >= 4) {
                    this.remoteControlApiMajor = versions[0];
                    this.remoteControlApiMinor = versions[1];
                    this.remoteControlProtocolMajor = versions[2];
                    this.remoteControlProtocolMinor = versions[3];
                }
                if (this.remoteControlApiMajor != 1 || this.remoteControlApiMinor < 0) {
                    this.remoteControlCompatible = false;
                }
                if (this.remoteControlCompatible) {
                    System.out.println(((Object)((Object)this)).getClass().getSimpleName() + ": initializing remote control");
                    method = plugin.getClass().getMethod("addRequestHandler", String.class, Class.class);
                    method.invoke((Object)plugin, "/wms", WMSRemoteHandler.class);
                    this.remoteControlInitialized = true;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (this.remoteControlAvailable) {
            String msg = null;
            if (this.remoteControlCompatible) {
                if (!this.remoteControlInitialized) {
                    msg = I18n.tr((String)"Could not initialize remote control.");
                }
            } else {
                msg = I18n.tr((String)"Remote control plugin is not compatible with {0}.", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            }
            if (msg != null) {
                String additionalMessage = I18n.tr((String)"{0} will work but remote control for this plugin is disabled.\nYou should update the plugins.", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
                String versionMessage = I18n.tr((String)"Current version of \"{1}\": {2}, internal version {3}. Need version {4}, internal version {5}.\nIf updating the plugins does not help report a bug for \"{0}\".", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), "remotecontrol", "" + this.remoteControlRevision, this.remoteControlApiMajor != 0 ? "" + this.remoteControlApiMajor + "." + this.remoteControlApiMinor : I18n.tr((String)"unknown"), "22734", "1.0"});
                String title = I18n.tr((String)"{0}: Problem with remote control", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
                System.out.println(((Object)((Object)this)).getClass().getSimpleName() + ": " + msg + "\n" + versionMessage);
                JOptionPane.showMessageDialog(Main.parent, msg + "\n" + additionalMessage, title, 2);
            }
        }
        if (!this.remoteControlAvailable) {
            System.out.println(((Object)((Object)this)).getClass().getSimpleName() + ": remote control not available");
        }
    }

    protected void initExporterAndImporter() {
        ExtensionFileFilter.exporters.add(new WMSLayerExporter());
        ExtensionFileFilter.importers.add(new WMSLayerImporter());
    }

    public ImageryPlugin(PluginInformation info) {
        super(info);
        instance = this;
        this.info.load();
        this.refreshMenu();
        this.initRemoteControl();
    }

    public void addLayer(ImageryInfo info) {
        this.info.add(info);
        this.info.save();
        this.refreshMenu();
    }

    public void refreshMenu() {
        MainMenu menu = Main.main.menu;
        if (this.imageryJMenu == null) {
            String string = I18n.marktr((String)"Imagery");
            menu.getClass();
            this.imageryJMenu = menu.addMenu(string, 87, 5, HelpUtil.ht((String)"/Plugin/Imagery"));
        } else {
            this.imageryJMenu.removeAll();
        }
        for (ImageryInfo u : this.info.layers) {
            this.imageryJMenu.add(new JMenuItem((Action)((Object)new AddImageryLayerAction(u))));
        }
        this.imageryJMenu.addSeparator();
        this.imageryJMenu.add(new JMenuItem((Action)((Object)new Map_Rectifier_WMSmenuAction())));
        this.imageryJMenu.addSeparator();
        this.imageryJMenu.add(new JMenuItem((Action)new JosmAction(I18n.tr((String)"Blank Layer"), "blankmenu", I18n.tr((String)"Open a blank WMS layer to load data from a file"), null, false){

            public void actionPerformed(ActionEvent ev) {
                Main.main.addLayer((Layer)new WMSLayer());
            }
        }));
        this.setEnabledAll(this.menuEnabled);
    }

    private void setEnabledAll(boolean isEnabled) {
        for (int i = 0; i < this.imageryJMenu.getItemCount(); ++i) {
            JMenuItem item = this.imageryJMenu.getItem(i);
            if (item == null) continue;
            item.setEnabled(isEnabled);
        }
        this.menuEnabled = isEnabled;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            this.setEnabledAll(true);
            Main.map.addMapMode(new IconToggleButton((Action)((Object)new ImageryAdjustAction(Main.map))));
        } else if (oldFrame != null && newFrame == null) {
            this.setEnabledAll(false);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new ImageryPreferenceEditor();
    }

    public String getPluginDir() {
        return new File(Main.pref.getPluginsDirectory(), "imagery").getPath();
    }

    static {
        wmsAdapter = new WMSAdapter();
    }
}

