/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery.tms;

import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;

public class TMSPreferences {
    public static final String PREFERENCE_PREFIX = "imagery.tms";
    public static final int MAX_ZOOM = 30;
    public static final int MIN_ZOOM = 2;
    public static final int DEFAULT_MAX_ZOOM = 20;
    public static final int DEFAULT_MIN_ZOOM = 2;
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.tms.default_autozoom", true);
    public static final BooleanProperty PROP_DEFAULT_AUTOLOAD = new BooleanProperty("imagery.tms.default_autoload", true);
    public static final IntegerProperty PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.tms.min_zoom_lvl", 2);
    public static final IntegerProperty PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.tms.max_zoom_lvl", 20);
    public static final IntegerProperty PROP_FADE_BACKGROUND = new IntegerProperty("imagery.tms.fade_background", 0);
    public static final BooleanProperty PROP_DRAW_DEBUG = new BooleanProperty("imagery.tms.draw_debug", false);

    public static void setFadeBackground(float fadeBackground) {
        PROP_FADE_BACKGROUND.put(Math.round(fadeBackground * 100.0f));
    }

    public static float getFadeBackground() {
        float parsed = (float)PROP_FADE_BACKGROUND.get() / 100.0f;
        if (parsed < 0.0f) {
            parsed = 0.0f;
        } else if (parsed > 1.0f) {
            parsed = 1.0f;
        }
        return parsed;
    }

    static int checkMaxZoomLvl(int maxZoomLvl, TileSource ts) {
        if (maxZoomLvl > 30) {
            System.err.println("MaxZoomLvl shouldnt be more than 30! Setting to 30.");
            maxZoomLvl = 30;
        }
        if (maxZoomLvl < PROP_MIN_ZOOM_LVL.get()) {
            System.err.println("maxZoomLvl shouldnt be more than minZoomLvl! Setting to minZoomLvl.");
            maxZoomLvl = PROP_MIN_ZOOM_LVL.get();
        }
        if (ts != null && ts.getMaxZoom() < PROP_MIN_ZOOM_LVL.get()) {
            System.err.println("decreasing maxZoomLvl to match new tile source");
            maxZoomLvl = ts.getMaxZoom();
        }
        return maxZoomLvl;
    }

    public static int getMaxZoomLvl(TileSource ts) {
        return TMSPreferences.checkMaxZoomLvl(PROP_MAX_ZOOM_LVL.get(), ts);
    }

    public static void setMaxZoomLvl(int maxZoomLvl) {
        maxZoomLvl = TMSPreferences.checkMaxZoomLvl(maxZoomLvl, null);
        PROP_MAX_ZOOM_LVL.put(maxZoomLvl);
    }

    static int checkMinZoomLvl(int minZoomLvl, TileSource ts) {
        if (minZoomLvl < 2) {
            System.err.println("minZoomLvl shouldnt be lees than 2! Setting to that.");
            minZoomLvl = 2;
        }
        if (minZoomLvl > PROP_MAX_ZOOM_LVL.get()) {
            System.err.println("minZoomLvl shouldnt be more than maxZoomLvl! Setting to maxZoomLvl.");
            minZoomLvl = TMSPreferences.getMaxZoomLvl(ts);
        }
        if (ts != null && ts.getMinZoom() > PROP_MIN_ZOOM_LVL.get()) {
            System.err.println("increasomg minZoomLvl to match new tile source");
            minZoomLvl = ts.getMinZoom();
        }
        return minZoomLvl;
    }

    public static int getMinZoomLvl(TileSource ts) {
        return TMSPreferences.checkMinZoomLvl(PROP_MIN_ZOOM_LVL.get(), ts);
    }

    public static void setMinZoomLvl(int minZoomLvl) {
        minZoomLvl = TMSPreferences.checkMinZoomLvl(minZoomLvl, null);
        PROP_MIN_ZOOM_LVL.put(minZoomLvl);
    }
}

