/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.gui.action.adapter.DisplayMenu;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.MapdustShowAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowCloseBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowCommentBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowInvalidateBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.ShowReOpenBugAction;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustButtonPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObserver;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapdustPanel
extends JPanel
implements ListSelectionListener,
MapdustBugDetailsObservable {
    private final ArrayList<MapdustBugDetailsObserver> observers = new ArrayList();
    private static final long serialVersionUID = 1L;
    private List<MapdustBug> mapdustBugsList;
    private JList listBugs;
    private MapdustButtonPanel btnPanel;
    private MapdustGUI mapdustGUI;
    private JPopupMenu menu;
    private JMenuItem menuAddComment;
    private JMenuItem menuFixed;
    private JMenuItem menuInvalidate;
    private JMenuItem menuReopen;

    public MapdustPanel() {
    }

    public MapdustPanel(List<MapdustBug> mapdustBugsList, String name, MapdustPlugin mapdustPlugin) {
        this.mapdustGUI = mapdustPlugin.getMapdustGUI();
        this.mapdustBugsList = mapdustBugsList;
        this.setLayout(new BorderLayout(5, 10));
        this.addComponents(mapdustPlugin);
        this.setName(I18n.tr((String)name));
    }

    private void addComponents(MapdustPlugin mapdustPlugin) {
        this.btnPanel = new MapdustButtonPanel(mapdustPlugin);
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            MapdustShowAction action = new ShowCommentBugAction(mapdustPlugin);
            this.menuAddComment = ComponentUtil.createJMenuItem(action, I18n.tr((String)"Add comment"), "dialogs/comment.png");
            this.menu.add(this.menuAddComment);
            action = new ShowCloseBugAction(mapdustPlugin);
            this.menuFixed = ComponentUtil.createJMenuItem(action, I18n.tr((String)"Close bug"), "dialogs/fixed.png");
            this.menu.add(this.menuFixed);
            action = new ShowInvalidateBugAction(mapdustPlugin);
            this.menuInvalidate = ComponentUtil.createJMenuItem(action, I18n.tr((String)"Invalidate bug"), "dialogs/invalid.png");
            this.menu.add(this.menuInvalidate);
            action = new ShowReOpenBugAction(mapdustPlugin);
            this.menuReopen = ComponentUtil.createJMenuItem(action, I18n.tr((String)"Re-open bug"), "dialogs/reopen.png");
            this.menu.add(this.menuReopen);
        }
        this.listBugs = ComponentUtil.createJList(this.mapdustBugsList, this.menu);
        this.listBugs.addListSelectionListener(this);
        DisplayMenu adapter = new DisplayMenu(this.listBugs, this.menu);
        this.listBugs.addMouseListener(adapter);
        JScrollPane cmpBugs = ComponentUtil.createJScrollPane(this.listBugs);
        this.add((Component)cmpBugs, "Center");
        this.add((Component)this.btnPanel, "South");
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        MapdustBug selectedBug = (MapdustBug)this.listBugs.getSelectedValue();
        Main.pref.put("selectedBug.status", selectedBug.getStatus().getValue());
        this.notifyObservers(selectedBug);
        if (selectedBug.getStatus().getKey().equals(1)) {
            this.btnPanel.getBtnAddComment().setEnabled(true);
            this.btnPanel.getBtnReOpenBugReport().setEnabled(false);
            this.btnPanel.getBtnInvalidateBugReport().setEnabled(true);
            this.btnPanel.getBtnFixBugReport().setEnabled(true);
            this.getMenuReopen().setEnabled(false);
            this.getMenuInvalidate().setEnabled(true);
            this.getMenuFixed().setEnabled(true);
        }
        if (selectedBug.getStatus().getKey().equals(2)) {
            this.btnPanel.getBtnAddComment().setEnabled(true);
            this.btnPanel.getBtnReOpenBugReport().setEnabled(true);
            this.btnPanel.getBtnInvalidateBugReport().setEnabled(false);
            this.btnPanel.getBtnFixBugReport().setEnabled(false);
            this.getMenuReopen().setEnabled(true);
            this.getMenuInvalidate().setEnabled(false);
            this.getMenuFixed().setEnabled(false);
        }
        if (selectedBug.getStatus().getKey().equals(3)) {
            this.btnPanel.getBtnAddComment().setEnabled(true);
            this.btnPanel.getBtnReOpenBugReport().setEnabled(true);
            this.btnPanel.getBtnInvalidateBugReport().setEnabled(false);
            this.btnPanel.getBtnFixBugReport().setEnabled(false);
            this.getMenuReopen().setEnabled(true);
            this.getMenuInvalidate().setEnabled(false);
            this.getMenuFixed().setEnabled(false);
        }
        Main.map.mapView.repaint();
        this.mapdustGUI.repaint();
    }

    public MapdustBug getSelectedBug() {
        MapdustBug selectedBug = (MapdustBug)this.getListBugs().getSelectedValue();
        return selectedBug;
    }

    public int getSelectedIndex() {
        return this.getListBugs().getSelectedIndex();
    }

    public void setSelectedBug(MapdustBug mapdustBug) {
        this.getListBugs().setSelectedValue(mapdustBug, false);
        int index = this.getSelectedIndex();
        this.getListBugs().ensureIndexIsVisible(index);
    }

    public JList getListBugs() {
        return this.listBugs;
    }

    public JPopupMenu getMenu() {
        return this.menu;
    }

    public MapdustButtonPanel getBtnPanel() {
        return this.btnPanel;
    }

    public JMenuItem getMenuAddComment() {
        return this.menuAddComment;
    }

    public JMenuItem getMenuFixed() {
        return this.menuFixed;
    }

    public JMenuItem getMenuInvalidate() {
        return this.menuInvalidate;
    }

    public JMenuItem getMenuReopen() {
        return this.menuReopen;
    }

    public List<MapdustBug> getMapdustBugsList() {
        return this.mapdustBugsList;
    }

    @Override
    public void addObserver(MapdustBugDetailsObserver observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    @Override
    public void removeObserver(MapdustBugDetailsObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notifyObservers(MapdustBug mapdustBug) {
        Iterator<MapdustBugDetailsObserver> elements = this.observers.iterator();
        while (elements.hasNext()) {
            elements.next().showDetails(mapdustBug);
        }
    }
}

