/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.action.execute;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustActionUploader;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustActionUploaderException;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.MapdustExecuteAction;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustRefreshObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustRefreshObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;
import org.openstreetmap.josm.tools.I18n;

public class ExecuteWorkOffline
extends MapdustExecuteAction
implements MapdustRefreshObservable {
    private static final long serialVersionUID = 1L;
    private final ArrayList<MapdustRefreshObserver> observers = new ArrayList();

    public ExecuteWorkOffline() {
    }

    public ExecuteWorkOffline(MapdustGUI mapdustGUI) {
        this.setMapdustGUI(mapdustGUI);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof JToggleButton) {
            JToggleButton btn = (JToggleButton)event.getSource();
            if (this.getMapdustGUI() != null) {
                String pluginState = Main.pref.get("mapdust.pluginState");
                if (pluginState.equals(MapdustPluginState.ONLINE.getValue())) {
                    Main.pref.put("mapdust.pluginState", MapdustPluginState.OFFLINE.getValue());
                    btn.setSelected(false);
                } else {
                    String title = "MapDust";
                    String message = "Do you want to submit your changes ";
                    int result = JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)(message = message + "to Mapdust?")), I18n.tr((String)title), 0);
                    if (result == 0) {
                        try {
                            MapdustActionUploader.getInstance().uploadData(this.getMapdustGUI().getQueuePanel().getActionList());
                        }
                        catch (MapdustActionUploaderException e) {
                            String errorMessage = "There was a Mapdust service error.";
                            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage), I18n.tr((String)"Error"), 0);
                        }
                    }
                    Main.pref.put("mapdust.pluginState", MapdustPluginState.ONLINE.getValue());
                    btn.setSelected(false);
                }
                this.notifyObservers();
            }
        }
    }

    public void addObserver(MapdustRefreshObserver observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    public void removeObserver(MapdustRefreshObserver observer) {
        this.observers.remove(observer);
    }

    public void notifyObservers() {
        Iterator<MapdustRefreshObserver> elements = this.observers.iterator();
        while (elements.hasNext()) {
            elements.next().updateData();
        }
    }
}

