/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustActionPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustBugPropertiesPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustActionListObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustInitialUpdateObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustInitialUpdateObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustAction;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapdustGUI
extends ToggleDialog
implements MapdustActionListObserver,
MapdustBugDetailsObservable,
MapdustInitialUpdateObservable {
    private static final long serialVersionUID = 1L;
    private final ArrayList<MapdustBugDetailsObserver> bugDetailsObservers = new ArrayList();
    private final ArrayList<MapdustInitialUpdateObserver> initialUpdateObservers = new ArrayList();
    private MapdustPanel panel;
    private MapdustActionPanel queuePanel;
    private JTabbedPane tabbedPane;
    private MapdustPlugin mapdustPlugin;
    private final MapdustBugPropertiesPanel detailsPanel;
    private JPanel mainPanel;
    private boolean initialUpdate = false;

    public MapdustGUI(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, MapdustPlugin mapdustPlugin) {
        super(I18n.tr((String)name), iconName, I18n.tr((String)tooltip), shortcut, preferredHeight);
        this.mapdustPlugin = mapdustPlugin;
        this.panel = new MapdustPanel(mapdustPlugin.getMapdustBugList(), "Bug reports", mapdustPlugin);
        MapdustBug bug = null;
        if (mapdustPlugin.getMapdustBugList() != null && mapdustPlugin.getMapdustBugList().size() > 0) {
            bug = mapdustPlugin.getMapdustBugList().get(0);
        }
        this.detailsPanel = new MapdustBugPropertiesPanel(bug);
        this.panel.addObserver(this.detailsPanel);
        this.addObserver(this.detailsPanel);
        String pluginState = Main.pref.get("mapdust.pluginState");
        if (pluginState.equals(MapdustPluginState.OFFLINE.getValue())) {
            this.tabbedPane = new JTabbedPane();
            LinkedList<MapdustAction> list = new LinkedList<MapdustAction>();
            this.mainPanel = new JPanel();
            this.mainPanel.setAutoscrolls(true);
            this.mainPanel.setLayout(new BorderLayout(5, 10));
            this.mainPanel.add((Component)this.detailsPanel, "North");
            this.mainPanel.add((Component)this.panel, "Center");
            this.queuePanel = new MapdustActionPanel(list, "Work offline", mapdustPlugin);
            this.tabbedPane.add((Component)this.mainPanel, 0);
            this.tabbedPane.add(this.queuePanel);
            this.add(this.tabbedPane, "Center");
        } else {
            this.mainPanel = new JPanel();
            this.mainPanel.setIgnoreRepaint(true);
            this.mainPanel.setAutoscrolls(true);
            this.mainPanel.setLayout(new BorderLayout(5, 10));
            this.mainPanel.add((Component)this.detailsPanel, "North");
            this.mainPanel.add((Component)this.panel, "Center");
            this.add(this.mainPanel, "Center");
            this.tabbedPane = null;
            this.queuePanel = null;
        }
    }

    public synchronized void update(List<MapdustBug> mapdustBugs, MapdustPlugin mapdustPlugin) {
        this.mapdustPlugin = mapdustPlugin;
        String pluginState = Main.pref.get("mapdust.pluginState");
        if (pluginState.equals(MapdustPluginState.ONLINE.getValue())) {
            if (this.tabbedPane != null) {
                this.tabbedPane.remove(this.panel);
                this.tabbedPane.remove(this.queuePanel);
                this.mainPanel.remove(this.tabbedPane);
                this.remove(this.mainPanel);
                this.queuePanel = null;
            } else {
                this.mainPanel.remove(this.detailsPanel);
                this.mainPanel.remove(this.panel);
                this.remove(this.mainPanel);
            }
            this.panel = new MapdustPanel(mapdustBugs, "Bug reports", mapdustPlugin);
            this.panel.addObserver(this.detailsPanel);
            MapdustBug selectedBug = mapdustBugs != null && mapdustBugs.size() > 0 ? mapdustBugs.get(0) : null;
            this.notifyObservers(selectedBug);
            this.mainPanel = new JPanel();
            this.mainPanel.setAutoscrolls(true);
            this.mainPanel.setLayout(new BorderLayout());
            if (mapdustBugs != null) {
                this.mainPanel.add((Component)this.detailsPanel, "North");
            }
            this.mainPanel.add((Component)this.panel, "Center");
            this.add(this.mainPanel, "Center");
        } else {
            ArrayList<MapdustAction> list = new ArrayList();
            if (this.queuePanel == null) {
                this.mainPanel.remove(this.detailsPanel);
                this.mainPanel.remove(this.panel);
                this.remove(this.mainPanel);
            } else {
                list = this.queuePanel.getActionList();
                this.mainPanel.remove(this.detailsPanel);
                this.tabbedPane.remove(this.panel);
                this.tabbedPane.remove(this.queuePanel);
                this.mainPanel.remove(this.tabbedPane);
                this.remove(this.mainPanel);
            }
            this.tabbedPane = new JTabbedPane();
            this.queuePanel = new MapdustActionPanel(list, "Offline Contribution", mapdustPlugin);
            this.panel = new MapdustPanel(mapdustBugs, "Bug reports (offline)", mapdustPlugin);
            this.panel.addObserver(this.detailsPanel);
            this.mainPanel = new JPanel();
            this.mainPanel.setAutoscrolls(true);
            this.mainPanel.setLayout(new BorderLayout());
            if (mapdustBugs != null && mapdustBugs.size() > 0) {
                this.mainPanel.add((Component)this.detailsPanel, "North");
            }
            this.tabbedPane.add((Component)this.panel, 0);
            this.tabbedPane.add(this.queuePanel);
            this.mainPanel.add((Component)this.tabbedPane, "Center");
            this.add(this.mainPanel, "Center");
        }
        this.invalidate();
        this.repaint();
    }

    @Override
    public synchronized void addAction(MapdustAction action) {
        List<MapdustAction> list = this.queuePanel.getActionList();
        List<MapdustBug> mapdustBugs = this.panel.getMapdustBugsList();
        mapdustBugs = this.modifyBug(mapdustBugs, action.getMapdustBug());
        this.mainPanel.remove(this.detailsPanel);
        this.tabbedPane.remove(this.panel);
        this.tabbedPane.remove(this.queuePanel);
        this.mainPanel.remove(this.tabbedPane);
        this.remove(this.mainPanel);
        this.tabbedPane = new JTabbedPane();
        list.add(action);
        this.queuePanel = new MapdustActionPanel(list, "Offline Contribution", this.mapdustPlugin);
        this.panel = new MapdustPanel(mapdustBugs, "Bug reports (offline)", this.mapdustPlugin);
        this.mainPanel = new JPanel();
        this.mainPanel.setAutoscrolls(true);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.detailsPanel, "North");
        this.tabbedPane.add((Component)this.panel, 0);
        this.tabbedPane.add(this.queuePanel);
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.add(this.mainPanel, "Center");
        this.invalidate();
        this.repaint();
    }

    public void showDialog() {
        super.showDialog();
        if (!this.initialUpdate && this.isShowing) {
            this.notifyObservers();
            this.initialUpdate = true;
        }
    }

    private List<MapdustBug> modifyBug(List<MapdustBug> mapdustBugs, MapdustBug modifiedBug) {
        int index = -1;
        for (int i = 0; i < mapdustBugs.size(); ++i) {
            if (modifiedBug.getId() == null || !mapdustBugs.get(i).getId().equals(modifiedBug.getId())) continue;
            index = i;
        }
        if (index != -1) {
            mapdustBugs.remove(index);
            mapdustBugs.add(0, modifiedBug);
        }
        return mapdustBugs;
    }

    @Override
    public void addObserver(MapdustBugDetailsObserver observer) {
        if (!this.bugDetailsObservers.contains(observer)) {
            this.bugDetailsObservers.add(observer);
        }
    }

    @Override
    public void addObserver(MapdustInitialUpdateObserver observer) {
        if (!this.initialUpdateObservers.contains(observer)) {
            this.initialUpdateObservers.add(observer);
        }
    }

    @Override
    public void removeObserver(MapdustBugDetailsObserver observer) {
        this.bugDetailsObservers.remove(observer);
    }

    @Override
    public void removeObserver(MapdustInitialUpdateObserver observer) {
        this.initialUpdateObservers.remove(observer);
    }

    @Override
    public void notifyObservers(MapdustBug mapdustBug) {
        Iterator<MapdustBugDetailsObserver> elements = this.bugDetailsObservers.iterator();
        while (elements.hasNext()) {
            elements.next().showDetails(mapdustBug);
        }
    }

    @Override
    public void notifyObservers() {
        Iterator<MapdustInitialUpdateObserver> elements = this.initialUpdateObservers.iterator();
        while (elements.hasNext()) {
            elements.next().initialUpdate();
        }
    }

    public MapdustPanel getPanel() {
        return this.panel;
    }

    public MapdustActionPanel getQueuePanel() {
        return this.queuePanel;
    }
}

