/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery.tms;

public class TMSKey {
    private final int x;
    private final int y;
    private final int level;
    public final boolean valid;

    public TMSKey(int x, int y, int level) {
        this.x = x;
        this.y = y;
        this.level = level;
        if (level <= 0 || x < 0 || y < 0) {
            this.valid = false;
            System.err.println("invalid TMSKey(" + level + ", " + x + ", " + y + ")");
        } else {
            this.valid = true;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof TMSKey) {
            TMSKey smk = (TMSKey)obj;
            if (smk.x == this.x && smk.y == this.y && smk.level == this.level) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return new Integer(this.x + this.y * 10000 + this.level * 100000).hashCode();
    }

    public String toString() {
        return "TMSKey(x=" + this.x + ",y=" + this.y + ",level=" + this.level + ")";
    }
}

