/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.piclayer.PicLayerFromFile;
import org.openstreetmap.josm.tools.I18n;

public class NewLayerFromFileAction
extends JosmAction {
    String m_lastdirprefname = "piclayer.lastdir";

    public NewLayerFromFileAction() {
        super(I18n.tr((String)"New picture layer from file..."), null, null, null, false);
    }

    public void actionPerformed(ActionEvent arg0) {
        JFileChooser fc = new JFileChooser(Main.pref.get(this.m_lastdirprefname));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new ImageFileFilter());
        fc.setMultiSelectionEnabled(true);
        int result = fc.showOpenDialog(Main.parent);
        if (result == 0) {
            int newLayerPos = Main.map.mapView.getAllLayers().size();
            for (PicLayerFromFile l : Main.map.mapView.getLayersOfType(PicLayerFromFile.class)) {
                int pos = Main.map.mapView.getLayerPos((Layer)l);
                if (pos >= newLayerPos) continue;
                newLayerPos = pos;
            }
            for (File file : fc.getSelectedFiles()) {
                PicLayerFromFile layer = new PicLayerFromFile(file);
                try {
                    layer.initialize();
                }
                catch (IOException e) {
                    System.out.println("NewLayerFromFileAction::actionPerformed - " + e.getMessage());
                    JOptionPane.showMessageDialog(null, e.getMessage());
                    return;
                }
                Main.pref.put(this.m_lastdirprefname, file.getParent());
                Main.main.addLayer((Layer)layer);
                Main.map.mapView.moveLayer((Layer)layer, newLayerPos++);
                if (fc.getSelectedFiles().length != 1 || Main.pref.getInteger("piclayer.zoom-on-load", 1) == 0) continue;
                BoundingXYVisitor v = new BoundingXYVisitor();
                layer.visitBoundingBox(v);
                Main.map.mapView.recalculateCenterScale(v);
            }
        }
    }

    private class ImageFileFilter
    extends FileFilter {
        private ImageFileFilter() {
        }

        public boolean accept(File f) {
            String ext3 = f.getName().length() > 4 ? f.getName().substring(f.getName().length() - 4).toLowerCase() : "";
            String ext4 = f.getName().length() > 5 ? f.getName().substring(f.getName().length() - 5).toLowerCase() : "";
            return f.isDirectory() || ext3.equals(".jpg") || ext4.equals(".jpeg") || ext3.equals(".png");
        }

        public String getDescription() {
            return I18n.tr((String)"Image files");
        }
    }
}

