/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ohe.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.plugins.ohe.OhePlugin;
import org.openstreetmap.josm.plugins.ohe.OpeningTimeUtils;
import org.openstreetmap.josm.plugins.ohe.gui.OheEditor;
import org.openstreetmap.josm.plugins.ohe.gui.TimeRect;
import org.openstreetmap.josm.plugins.ohe.parser.OpeningTimeCompiler;
import org.openstreetmap.josm.plugins.ohe.parser.ParseException;
import org.openstreetmap.josm.plugins.ohe.parser.SyntaxException;
import org.openstreetmap.josm.plugins.ohe.parser.TokenMgrError;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OheDialogPanel
extends JPanel {
    private final JTextField keyField;
    private final JTextField valueField;
    private final JButton twentyfourSevenButton;
    private final JLabel actualPostionLabel;
    private final OheEditor editorPanel;
    private final String oldkey;

    public OheDialogPanel(OhePlugin plugin, String key, String value) {
        this.oldkey = key;
        this.keyField = new JTextField(key);
        this.valueField = new JTextField(value);
        this.valueField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OheDialogPanel.this.editorPanel.initTimeRects();
            }
        });
        this.twentyfourSevenButton = new JButton(I18n.tr((String)"apply {0}", (Object[])new Object[]{"24/7"}));
        this.twentyfourSevenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                OheDialogPanel.this.valueField.setText("24/7");
                OheDialogPanel.this.editorPanel.initTimeRects();
            }
        });
        this.actualPostionLabel = new JLabel("Mo 00:00");
        JPanel toolsPanel = new JPanel(new GridBagLayout());
        toolsPanel.add((Component)this.twentyfourSevenButton, GBC.std());
        toolsPanel.add(Box.createGlue(), GBC.std().fill(2));
        toolsPanel.add((Component)this.actualPostionLabel, GBC.eop());
        this.editorPanel = new OheEditor(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(I18n.tr((String)"Key")), GBC.std());
        this.add(Box.createHorizontalStrut(10), GBC.std());
        this.add((Component)this.keyField, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr((String)"Value")), GBC.std());
        this.add(Box.createHorizontalStrut(10), GBC.std());
        this.add((Component)this.valueField, GBC.eop().fill(2));
        this.add((Component)toolsPanel, GBC.eol().fill(2));
        this.add((Component)this.editorPanel, GBC.eol().fill());
        this.valueField.requestFocus();
        this.setPreferredSize(new Dimension(480, 520));
    }

    public String[] getChangedKeyValuePair() {
        return new String[]{this.oldkey, this.keyField.getText(), this.valueField.getText()};
    }

    public ArrayList<int[]> getTime() throws Exception {
        String value = this.valueField.getText();
        ArrayList<int[]> time = null;
        if (value.length() > 0) {
            OpeningTimeCompiler compiler = new OpeningTimeCompiler(value);
            try {
                time = OpeningTimeUtils.convert(compiler.startCompile());
            }
            catch (Throwable t) {
                int[] tColumns = null;
                String info = null;
                if (t instanceof ParseException) {
                    ParseException parserExc = (ParseException)t;
                    tColumns = new int[]{parserExc.currentToken.beginColumn - 1, parserExc.currentToken.endColumn + 1};
                } else if (t instanceof SyntaxException) {
                    SyntaxException syntaxError = (SyntaxException)t;
                    tColumns = new int[]{syntaxError.getStartColumn(), syntaxError.getEndColumn()};
                    info = syntaxError.getInfo();
                } else if (t instanceof TokenMgrError) {
                    TokenMgrError tokenMgrError = (TokenMgrError)t;
                    tColumns = new int[]{tokenMgrError.errorColumn - 1, tokenMgrError.errorColumn + 1};
                } else {
                    t.printStackTrace();
                }
                if (tColumns != null) {
                    int first = Math.max(0, (int)tColumns[0]);
                    int last = Math.min(value.length(), tColumns[1]);
                    String begin = value.substring(0, first);
                    String middle = value.substring(first, last);
                    String end = value.substring(last);
                    String message = "<html>" + I18n.tr((String)"There is something wrong in the value near:") + "<br>" + begin + "<span style='background-color:red;'>" + middle + "</span>" + end;
                    if (info != null) {
                        message = message + "<br>" + I18n.tr((String)"Info: {0}", (Object[])new Object[]{I18n.tr((String)info)});
                    }
                    message = message + "<br>" + I18n.tr((String)"Correct the value manually and than press Enter.");
                    message = message + "</html>";
                    JOptionPane.showMessageDialog(this, message, I18n.tr((String)"Error in timeformat"), 1);
                }
                throw new Exception("Error in the TimeValue");
            }
        }
        return time;
    }

    public void updateValueField(ArrayList<TimeRect> timeRects) {
        if (this.valueField != null && timeRects != null) {
            this.valueField.setText(OpeningTimeUtils.makeStringFromRects(timeRects));
        }
    }

    public void setMousePositionText(String positionText) {
        this.actualPostionLabel.setText(positionText);
    }
}

