/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.AddressDialog;
import buildings_tools.Building;
import buildings_tools.BuildingsToolsPlugin;
import buildings_tools.ToolSettings;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawBuildingAction
extends MapMode
implements MapViewPaintable,
AWTEventListener,
SelectionChangedListener {
    private final Cursor cursorCrosshair;
    private final Cursor cursorJoinNode;
    private Cursor currCursor;
    private Cursor customCursor;
    private Mode mode = Mode.None;
    private Mode nextMode = Mode.None;
    private final Color selectedColor;
    private Point drawStartPos;
    private Point mousePos;
    private boolean isCtrlDown;
    private boolean isShiftDown;
    private boolean isAltDown;
    Building building = new Building();

    public DrawBuildingAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Draw buildings"), "building", I18n.tr((String)"Draw buildings"), Shortcut.registerShortcut((String)"mapmode:buildings", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Draw buildings")}), (int)87, (int)3), mapFrame, DrawBuildingAction.getCursor());
        this.cursorCrosshair = DrawBuildingAction.getCursor();
        this.cursorJoinNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
        this.currCursor = this.cursorCrosshair;
        this.selectedColor = Main.pref.getColor(I18n.marktr((String)"selected"), Color.red);
    }

    private static Cursor getCursor() {
        try {
            return ImageProvider.getCursor((String)"crosshair", (String)"building");
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(1);
        }
    }

    private void setCursor(final Cursor c) {
        if (this.currCursor.equals(c)) {
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (!(Main.map.mapMode instanceof DrawBuildingAction)) {
                        return;
                    }
                    Main.map.mapView.setCursor(c);
                }
            });
            this.currCursor = c;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showAddrDialog(Way w) {
        AddressDialog dlg = new AddressDialog();
        if (!this.isAltDown) {
            dlg.showDialog();
            if (dlg.getValue() != 1) {
                return;
            }
        }
        dlg.saveValues();
        String tmp = dlg.getHouseNum();
        if (tmp != null && tmp != "") {
            w.put("addr:housenumber", tmp);
        }
        if ((tmp = dlg.getStreetName()) != null && tmp != "") {
            w.put("addr:street", tmp);
        }
    }

    public void enterMode() {
        super.enterMode();
        if (this.getCurrentDataSet() == null) {
            Main.map.selectSelectTool(false);
            return;
        }
        this.currCursor = this.cursorCrosshair;
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        DataSet.addSelectionListener((SelectionChangedListener)this);
        this.updateSnap(this.getCurrentDataSet().getSelected());
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        DataSet.removeSelectionListener((SelectionChangedListener)this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.mode != Mode.None) {
            Main.map.mapView.repaint();
        }
        this.mode = Mode.None;
    }

    public void cancelDrawing() {
        this.mode = Mode.None;
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        Main.map.statusLine.setHeading(-1.0);
        Main.map.statusLine.setAngle(-1.0);
        this.building.reset();
        Main.map.mapView.repaint();
        this.updateStatusLine();
    }

    @Override
    public void eventDispatched(AWTEvent arg0) {
        boolean isShiftDown;
        if (!(arg0 instanceof KeyEvent)) {
            return;
        }
        KeyEvent ev = (KeyEvent)arg0;
        int modifiers = ev.getModifiersEx();
        boolean isCtrlDown = (modifiers & 0x80) != 0;
        boolean bl = isShiftDown = (modifiers & 0x40) != 0;
        if (this.isCtrlDown != isCtrlDown || this.isShiftDown != isShiftDown) {
            this.isCtrlDown = isCtrlDown;
            this.isShiftDown = isShiftDown;
            this.processMouseEvent(null);
            this.updCursor();
            if (this.mode != Mode.None) {
                Main.map.mapView.repaint();
            }
        }
        boolean bl2 = this.isAltDown = (modifiers & 0x200) != 0;
        if (ev.getKeyCode() == 27 && ev.getID() == 401) {
            if (this.mode != Mode.None) {
                ev.consume();
            }
            this.cancelDrawing();
        }
    }

    private EastNorth getEastNorth() {
        Node n = this.isCtrlDown ? null : Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isUsablePredicate);
        if (n == null) {
            return BuildingsToolsPlugin.latlon2eastNorth(Main.map.mapView.getLatLon(this.mousePos.x, this.mousePos.y));
        }
        return BuildingsToolsPlugin.latlon2eastNorth(n.getCoor());
    }

    private boolean isRectDrawing() {
        return this.building.isRectDrawing() && (!this.isShiftDown || ToolSettings.isBBMode());
    }

    private Mode modeDrawing() {
        EastNorth p = this.getEastNorth();
        if (this.isRectDrawing()) {
            this.building.setPlaceRect(p);
            return this.isShiftDown ? Mode.DrawingAngFix : Mode.None;
        }
        this.building.setPlace(p, ToolSettings.getWidth(), ToolSettings.getLenStep(), this.isShiftDown);
        Main.map.statusLine.setDist(this.building.getLength());
        this.nextMode = ToolSettings.getWidth() == 0.0 ? Mode.DrawingWidth : Mode.None;
        return this.nextMode;
    }

    private Mode modeDrawingWidth() {
        this.building.setWidth(this.getEastNorth());
        Main.map.statusLine.setDist(Math.abs(this.building.getWidth()));
        return Mode.None;
    }

    private Mode modeDrawingAngFix() {
        this.building.angFix(this.getEastNorth());
        return Mode.None;
    }

    private void processMouseEvent(MouseEvent e) {
        if (e != null) {
            this.mousePos = e.getPoint();
            this.isCtrlDown = e.isControlDown();
            this.isShiftDown = e.isShiftDown();
            this.isAltDown = e.isAltDown();
        }
        if (this.mode == Mode.None) {
            this.nextMode = Mode.None;
            return;
        }
        if (this.mode == Mode.Drawing) {
            this.nextMode = this.modeDrawing();
        } else if (this.mode == Mode.DrawingWidth) {
            this.nextMode = this.modeDrawingWidth();
        } else if (this.mode == Mode.DrawingAngFix) {
            this.nextMode = this.modeDrawingAngFix();
        } else {
            throw new AssertionError((Object)"Invalid drawing mode");
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.mode == Mode.None) {
            return;
        }
        if (this.building.getLength() == 0.0) {
            return;
        }
        g.setColor(this.selectedColor);
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        this.building.paint(g, mv);
        g.setStroke(new BasicStroke(1.0f));
    }

    private void drawingStart(MouseEvent e) {
        this.drawStartPos = this.mousePos = e.getPoint();
        Node n = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isUsablePredicate);
        if (n == null) {
            this.building.setBase(BuildingsToolsPlugin.latlon2eastNorth(Main.map.mapView.getLatLon(this.mousePos.x, this.mousePos.y)));
        } else {
            this.building.setBase(n);
        }
        this.mode = Mode.Drawing;
        this.updateStatusLine();
    }

    private void drawingAdvance(MouseEvent e) {
        this.processMouseEvent(e);
        if (this.mode != Mode.None && this.nextMode == Mode.None) {
            this.drawingFinish();
        } else {
            this.mode = this.nextMode;
            this.updateStatusLine();
        }
    }

    private void drawingFinish() {
        if (this.building.getLength() != 0.0) {
            Way w = this.building.create();
            if (w != null && ToolSettings.isUsingAddr()) {
                this.showAddrDialog(w);
            }
            if (ToolSettings.isAutoSelect() && (Main.main.getCurrentDataSet().getSelected().isEmpty() || this.isShiftDown)) {
                Main.main.getCurrentDataSet().setSelected(new PrimitiveId[]{w});
            }
        }
        this.cancelDrawing();
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        if (this.mode == Mode.None) {
            this.drawingStart(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
        this.updCursor();
        if (this.mode != Mode.None) {
            Main.map.mapView.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        boolean dragged = true;
        if (this.drawStartPos != null) {
            dragged = e.getPoint().distance(this.drawStartPos) > 10.0;
        }
        this.drawStartPos = null;
        if (this.mode == Mode.Drawing && !dragged) {
            return;
        }
        if (this.mode == Mode.None) {
            return;
        }
        this.drawingAdvance(e);
    }

    private void updCursor() {
        if (this.mousePos == null) {
            return;
        }
        if (!Main.isDisplayingMapView()) {
            return;
        }
        Node n = null;
        if (!this.isCtrlDown) {
            n = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isUsablePredicate);
        }
        if (n != null) {
            this.setCursor(this.cursorJoinNode);
        } else if (this.customCursor != null && (!this.isShiftDown || this.isRectDrawing())) {
            this.setCursor(this.customCursor);
        } else {
            this.setCursor(this.cursorCrosshair);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.processMouseEvent(e);
        this.updCursor();
        if (this.mode != Mode.None) {
            Main.map.mapView.repaint();
        }
    }

    public String getModeHelpText() {
        if (this.mode == Mode.None) {
            return I18n.tr((String)"Point on the corner of the building to start drawing");
        }
        if (this.mode == Mode.Drawing) {
            return I18n.tr((String)"Point on opposite end of the building");
        }
        if (this.mode == Mode.DrawingWidth) {
            return I18n.tr((String)"Set width of the building");
        }
        return "";
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    public void updateSnap(Collection<? extends OsmPrimitive> newSelection) {
        this.building.clearAngleSnap();
        if (newSelection.size() <= 10) {
            LinkedList<Node> nodes = new LinkedList<Node>();
            LinkedList<Way> ways = new LinkedList<Way>();
            for (OsmPrimitive osmPrimitive : newSelection) {
                switch (osmPrimitive.getType()) {
                    case NODE: {
                        nodes.add((Node)osmPrimitive);
                        break;
                    }
                    case WAY: {
                        ways.add((Way)osmPrimitive);
                    }
                }
            }
            this.building.addAngleSnap(nodes.toArray(new Node[0]));
            for (Way way : ways) {
                this.building.addAngleSnap(way);
            }
        }
        this.updateCustomCursor();
    }

    private void updateCustomCursor() {
        Double angle = this.building.getDrawingAngle();
        if (angle == null || !ToolSettings.isSoftCursor()) {
            this.customCursor = null;
            return;
        }
        int R = 9;
        int r = 3;
        BufferedImage img = new BufferedImage(32, 32, 2);
        Graphics2D g = img.createGraphics();
        GeneralPath b = new GeneralPath();
        b.moveTo(16.0 - Math.cos(angle) * 9.0, 16.0 - Math.sin(angle) * 9.0);
        b.lineTo(16.0 - Math.cos(angle) * 3.0, 16.0 - Math.sin(angle) * 3.0);
        b.moveTo(16.0 + Math.cos(angle) * 9.0, 16.0 + Math.sin(angle) * 9.0);
        b.lineTo(16.0 + Math.cos(angle) * 3.0, 16.0 + Math.sin(angle) * 3.0);
        b.moveTo(16.0 + Math.sin(angle) * 9.0, 16.0 - Math.cos(angle) * 9.0);
        b.lineTo(16.0 + Math.sin(angle) * 3.0, 16.0 - Math.cos(angle) * 3.0);
        b.moveTo(16.0 - Math.sin(angle) * 9.0, 16.0 + Math.cos(angle) * 9.0);
        b.lineTo(16.0 - Math.sin(angle) * 3.0, 16.0 + Math.cos(angle) * 3.0);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.setColor(Color.WHITE);
        g.draw(b);
        g.setStroke(new BasicStroke(1.0f, 1, 1));
        g.setColor(Color.BLACK);
        g.draw(b);
        this.customCursor = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(16, 16), "custom crosshair");
        this.updCursor();
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.updateSnap(newSelection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        None,
        Drawing,
        DrawingWidth,
        DrawingAngFix;

    }
}

