/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditTableModel;
import org.openstreetmap.josm.tools.I18n;

public class UnresolvedAddressesTableModel
extends AddressEditTableModel {
    private static final int NUMBER_OF_COLUMNS = 5;
    private static final String[] COLUMN_NAMES = new String[]{I18n.tr((String)"Street"), I18n.tr((String)"Number"), I18n.tr((String)"City"), I18n.tr((String)"Postcode"), I18n.tr((String)"Name")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, String.class, String.class};
    private static final long serialVersionUID = 424009321818130586L;

    public UnresolvedAddressesTableModel(AddressEditContainer addressContainer) {
        super(addressContainer);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getRowCount() {
        if (this.addressContainer == null || this.addressContainer.getUnresolvedAddresses() == null) {
            return 0;
        }
        return this.addressContainer.getNumberOfUnresolvedAddresses();
    }

    @Override
    public Object getValueAt(int row, int column) {
        OSMAddress aNode = (OSMAddress)this.getEntityOfRow(row);
        if (aNode == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return aNode.getStreetName();
            }
            case 1: {
                return aNode.getHouseNumber();
            }
            case 2: {
                return aNode.getCity();
            }
            case 3: {
                return aNode.getPostCode();
            }
            case 4: {
                String name = aNode.getName();
                if (!StringUtils.isNullOrEmpty(name)) {
                    return TagUtils.getAddrHousenameValue(aNode.getOsmObject());
                }
                return "";
            }
        }
        throw new RuntimeException("Invalid column index: " + column);
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return COLUMN_CLASSES[arg0];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public IOSMEntity getEntityOfRow(int row) {
        if (this.addressContainer == null || this.addressContainer.getUnresolvedAddresses() == null) {
            return null;
        }
        if (row < 0 || row >= this.addressContainer.getNumberOfUnresolvedAddresses()) {
            return null;
        }
        return this.addressContainer.getUnresolvedAddresses().get(row);
    }

    @Override
    public int getRowOfEntity(IOSMEntity entity) {
        if (this.addressContainer == null || this.addressContainer.getUnresolvedAddresses() == null) {
            return -1;
        }
        return this.addressContainer.getUnresolvedAddresses().indexOf(entity);
    }
}

