/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui.actions;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditTableModel;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.AbstractAddressEditAction;
import org.openstreetmap.josm.tools.I18n;

public class ApplyAllGuessesAction
extends AbstractAddressEditAction
implements MouseListener {
    public ApplyAllGuessesAction() {
        super(I18n.tr((String)"Apply all guesses"), "applyguesses_24", I18n.tr((String)"Turns all guesses into the corresponding tag values."));
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        List<OSMAddress> addrToFix;
        if (ev == null) {
            return;
        }
        if (ev.getSelectedUnresolvedAddresses() != null) {
            addrToFix = ev.getSelectedUnresolvedAddresses();
            this.applyGuesses(addrToFix);
        }
        if (ev.getSelectedIncompleteAddresses() != null) {
            addrToFix = ev.getSelectedIncompleteAddresses();
            this.applyGuesses(addrToFix);
        }
    }

    @Override
    protected void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(container != null && container.getNumberOfGuesses() > 0);
    }

    private void applyGuesses(List<OSMAddress> addrToFix) {
        this.beginTransaction(I18n.tr((String)"Applied guessed values"));
        ArrayList<OSMAddress> addrToFixShadow = new ArrayList<OSMAddress>(addrToFix);
        for (OSMAddress aNode : addrToFixShadow) {
            this.beginObjectTransaction(aNode);
            aNode.applyAllGuesses();
            this.finishObjectTransaction(aNode);
        }
        this.finishTransaction();
    }

    @Override
    protected void updateEnabledState(AddressEditSelectionEvent event) {
        this.setEnabled(event.hasAddressesWithGuesses());
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
        if (container == null || container.getNumberOfIncompleteAddresses() == 0) {
            return;
        }
        List<OSMAddress> addrToFix = container.getUnresolvedAddresses();
        this.applyGuesses(addrToFix);
        addrToFix = container.getIncompleteAddresses();
        this.applyGuesses(addrToFix);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int row;
        IOSMEntity node;
        AddressEditTableModel model;
        JTable table = (JTable)e.getSource();
        Point p = e.getPoint();
        if (e.getClickCount() == 2 && (model = (AddressEditTableModel)table.getModel()) != null && (node = model.getEntityOfRow(row = table.rowAtPoint(p))) instanceof OSMAddress) {
            this.beginTransaction(String.valueOf(I18n.tr((String)"Applied guessed values for ")) + node.getOsmObject());
            this.beginObjectTransaction(node);
            OSMAddress aNode = (OSMAddress)node;
            aNode.applyAllGuesses();
            this.finishObjectTransaction(node);
            this.finishTransaction();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

