/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui.actions;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.AbstractAddressEditAction;
import org.openstreetmap.josm.tools.I18n;

public class SelectAddressesInMapAction
extends AbstractAddressEditAction {
    public SelectAddressesInMapAction() {
        super(I18n.tr((String)"Select"), "selectall", "Selects selected addresses in the map");
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        if (ev == null) {
            return;
        }
        if (ev.hasUnresolvedAddresses()) {
            this.internalSelectAddresses(ev.getSelectedUnresolvedAddresses());
        } else if (ev.hasIncompleteAddresses()) {
            this.internalSelectAddresses(ev.getSelectedIncompleteAddresses());
        }
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
    }

    @Override
    protected void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(false);
    }

    @Override
    protected void updateEnabledState(AddressEditSelectionEvent event) {
        this.setEnabled(event != null && event.hasAddresses());
    }

    private void internalSelectAddresses(List<OSMAddress> addrToSel) {
        if (addrToSel == null) {
            return;
        }
        ArrayList<OsmPrimitive> sel = new ArrayList<OsmPrimitive>();
        this.getCurrentDataSet().clearSelection();
        for (OSMAddress aNode : addrToSel) {
            sel.add(aNode.getOsmObject());
        }
        this.getCurrentDataSet().setSelected(sel);
    }
}

