/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditTableModel;
import org.openstreetmap.josm.tools.I18n;

public class IncompleteAddressesTableModel
extends AddressEditTableModel {
    private static final long serialVersionUID = -5951629033395186324L;
    private static final int NUMBER_OF_COLUMNS = 6;
    private static final String[] COLUMN_NAMES = new String[]{I18n.tr((String)"Country"), I18n.tr((String)"State"), I18n.tr((String)"City"), I18n.tr((String)"Post Code"), I18n.tr((String)"Street"), I18n.tr((String)"Number")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};

    public IncompleteAddressesTableModel(AddressEditContainer addressContainer) {
        super(addressContainer);
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getRowCount() {
        if (this.addressContainer == null || this.addressContainer.getIncompleteAddresses() == null) {
            return 0;
        }
        return this.addressContainer.getNumberOfIncompleteAddresses();
    }

    @Override
    public Object getValueAt(int row, int column) {
        OSMAddress aNode = (OSMAddress)this.getEntityOfRow(row);
        if (aNode == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return aNode.getCountry();
            }
            case 1: {
                return aNode.getState();
            }
            case 2: {
                return aNode.getCity();
            }
            case 3: {
                return aNode.getPostCode();
            }
            case 4: {
                return aNode.getStreetName();
            }
            case 5: {
                return aNode.getHouseNumber();
            }
        }
        throw new RuntimeException("Invalid column index: " + column);
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return COLUMN_CLASSES[arg0];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public IOSMEntity getEntityOfRow(int row) {
        if (this.addressContainer == null || this.addressContainer.getIncompleteAddresses() == null) {
            return null;
        }
        if (row < 0 || row >= this.addressContainer.getNumberOfIncompleteAddresses()) {
            return null;
        }
        return this.addressContainer.getIncompleteAddresses().get(row);
    }

    @Override
    public int getRowOfEntity(IOSMEntity entity) {
        if (this.addressContainer == null || this.addressContainer.getIncompleteAddresses() == null) {
            return -1;
        }
        return this.addressContainer.getIncompleteAddresses().indexOf(entity);
    }
}

