/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.HashMap;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OSMEntityBase;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreet;
import org.openstreetmap.josm.plugins.fixAddresses.OsmUtils;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;

public class OSMAddress
extends OSMEntityBase {
    public static final String MISSING_TAG = "?";
    public static final String INTERPOLATION_TAG = "x..y";
    private boolean isPartOfInterpolation;
    private HashMap<String, String> guessedValues = new HashMap();
    private HashMap<String, String> derivedValues = new HashMap();

    public OSMAddress(OsmPrimitive osmObject) {
        super(osmObject);
    }

    @Override
    public void setOsmObject(OsmPrimitive osmObject) {
        super.setOsmObject(osmObject);
        this.isPartOfInterpolation = OsmUtils.getValuesFromAddressInterpolation(this);
        String streetNameViaRel = OsmUtils.getAssociatedStreet(this.osmObject);
        if (!StringUtils.isNullOrEmpty(streetNameViaRel)) {
            this.setDerivedValue("addr:street", streetNameViaRel);
        }
    }

    public boolean isComplete() {
        return this.hasCity() && this.hasHouseNumber() && this.hasPostCode() && this.hasCity() && this.hasState() && this.hasStreetName();
    }

    public String getStreetName() {
        return this.getTagValueWithGuess("addr:street");
    }

    private String getTagValueWithGuess(String tag) {
        if (StringUtils.isNullOrEmpty(tag)) {
            return MISSING_TAG;
        }
        if (this.osmObject == null) {
            return MISSING_TAG;
        }
        if (!this.osmObject.hasKey(tag) || StringUtils.isNullOrEmpty(this.osmObject.get(tag))) {
            if (!this.hasDerivedValue(tag)) {
                if (this.hasGuessedValue(tag)) {
                    return "*" + this.getGuessedValue(tag);
                }
                return MISSING_TAG;
            }
            return this.getDerivedValue(tag);
        }
        return this.osmObject.get(tag);
    }

    public boolean hasStreetName() {
        return TagUtils.hasAddrStreetTag(this.osmObject) || this.hasDerivedValue("addr:street");
    }

    public String getGuessedStreetName() {
        return this.getGuessedValue("addr:street");
    }

    public void setGuessedStreetName(String guessedStreetName) {
        this.setGuessedValue("addr:street", guessedStreetName);
    }

    public boolean hasGuessedStreetName() {
        return this.hasGuessedValue("addr:street");
    }

    public String getGuessedPostCode() {
        return this.getGuessedValue("addr:postcode");
    }

    public void setGuessedPostCode(String guessedPostCode) {
        this.setGuessedValue("addr:postcode", guessedPostCode);
    }

    public boolean hasGuessedPostCode() {
        return this.hasGuessedValue("addr:postcode");
    }

    public String getGuessedCity() {
        return this.getGuessedValue("addr:city");
    }

    public void setGuessedCity(String guessedCity) {
        this.setGuessedValue("addr:city", guessedCity);
    }

    public boolean hasGuessedCity() {
        return this.hasGuessedValue("addr:city");
    }

    public boolean hasGuesses() {
        return this.guessedValues.size() > 0;
    }

    public void applyAllGuesses() {
        for (String tag : this.guessedValues.keySet()) {
            String val = this.guessedValues.get(tag);
            if (StringUtils.isNullOrEmpty(val)) continue;
            this.setOSMTag(tag, val);
        }
        this.guessedValues.clear();
    }

    public String getPostCode() {
        return this.getTagValueWithGuess("addr:postcode");
    }

    public boolean hasPostCode() {
        return this.hasTag("addr:postcode");
    }

    public String getHouseNumber() {
        if (!TagUtils.hasAddrHousenumberTag(this.osmObject)) {
            if (!this.isPartOfInterpolation) {
                return MISSING_TAG;
            }
            return INTERPOLATION_TAG;
        }
        return TagUtils.getAddrHousenumberValue(this.osmObject);
    }

    public boolean hasHouseNumber() {
        return TagUtils.hasAddrHousenumberTag(this.osmObject) || this.isPartOfInterpolation;
    }

    protected boolean isPartOfInterpolation() {
        return this.isPartOfInterpolation;
    }

    public String getCity() {
        return this.getTagValueWithGuess("addr:city");
    }

    public boolean hasCity() {
        return this.hasTag("addr:city");
    }

    public String getState() {
        return this.getTagValueWithGuess("addr:state");
    }

    public boolean hasState() {
        return this.hasTag("addr:state");
    }

    public String getCountry() {
        return this.getTagValueWithGuess("addr:country");
    }

    public boolean hasCountry() {
        return this.hasTag("addr:country");
    }

    public void removeAllAddressTags() {
        this.removeOSMTag("addr:city");
        this.removeOSMTag("addr:country");
        this.removeOSMTag("addr:postcode");
        this.removeOSMTag("addr:housenumber");
        this.removeOSMTag("addr:state");
        this.removeOSMTag("addr:street");
    }

    public boolean hasTag(String tag) {
        if (StringUtils.isNullOrEmpty(tag)) {
            return false;
        }
        return TagUtils.hasTag(this.osmObject, tag) || this.hasDerivedValue(tag);
    }

    @Override
    public int compareTo(IOSMEntity o) {
        if (o == null || !(o instanceof OSMAddress)) {
            return -1;
        }
        OSMAddress other = (OSMAddress)o;
        int cc = 0;
        cc = this.getCountry().compareTo(other.getCountry());
        if (cc == 0 && (cc = this.getState().compareTo(other.getState())) == 0 && (cc = this.getCity().compareTo(other.getCity())) == 0 && (cc = this.getStreetName().compareTo(other.getStreetName())) == 0) {
            if (this.hasGuessedStreetName()) {
                if (other.hasStreetName()) {
                    cc = this.getGuessedStreetName().compareTo(other.getStreetName());
                    if (cc == 0) {
                        cc = this.getHouseNumber().compareTo(other.getHouseNumber());
                    }
                } else if (other.hasGuessedStreetName() && (cc = this.getGuessedStreetName().compareTo(other.getGuessedStreetName())) == 0) {
                    cc = this.getHouseNumber().compareTo(other.getHouseNumber());
                }
            } else {
                cc = this.getHouseNumber().compareTo(other.getHouseNumber());
            }
        }
        return cc;
    }

    public void assignStreet(OSMStreet node) {
        if (node == null || !node.hasName()) {
            return;
        }
        if (!node.getName().equals(this.getStreetName())) {
            this.setStreetName(node.getName());
            node.addAddress(this);
            OSMAddress.fireEntityChanged(this);
        }
    }

    public String getGuessedValue(String tag) {
        if (!this.hasGuessedValue(tag)) {
            return null;
        }
        return this.guessedValues.get(tag);
    }

    public boolean needsGuess() {
        return this.needsGuessedValue("addr:city") || this.needsGuessedValue("addr:postcode") || this.needsGuessedValue("addr:street");
    }

    public boolean needsGuessedValue(String tag) {
        return MISSING_TAG.equals(this.getTagValueWithGuess(tag));
    }

    public void clearAllGuesses() {
        this.guessedValues.clear();
    }

    private boolean hasGuessedValue(String tag) {
        return this.guessedValues.containsKey(tag) && !StringUtils.isNullOrEmpty(this.guessedValues.get(tag));
    }

    public void setGuessedValue(String tag, String value) {
        this.guessedValues.put(tag, value);
        OSMAddress.fireEntityChanged(this);
    }

    private boolean hasDerivedValue(String tag) {
        return this.derivedValues.containsKey(tag) && !StringUtils.isNullOrEmpty(this.derivedValues.get(tag));
    }

    public boolean hasDerivedValues() {
        return this.derivedValues.size() > 0;
    }

    public String getDerivedValue(String tag) {
        if (!this.hasDerivedValue(tag)) {
            return null;
        }
        return this.derivedValues.get(tag);
    }

    public void setDerivedValue(String tag, String value) {
        this.derivedValues.put(tag, value);
    }

    public void setStreetName(String streetName) {
        if (streetName != null && streetName.length() == 0) {
            return;
        }
        this.setOSMTag("addr:street", streetName);
    }

    public void setState(String state) {
        if (state != null && state.length() == 0) {
            return;
        }
        this.setOSMTag("addr:state", state);
    }

    public void setCountry(String country) {
        if (country != null && country.length() == 0) {
            return;
        }
        this.setOSMTag("addr:country", country);
    }

    public void setPostCode(String postCode) {
        if (postCode != null && postCode.length() == 0) {
            return;
        }
        this.setOSMTag("addr:postcode", postCode);
    }

    @Override
    public String toString() {
        return OSMAddress.getFormatString(this);
    }

    public static String getFormatString(OSMAddress node) {
        String guessed = node.getGuessedStreetName();
        String sName = node.getStreetName();
        if (!StringUtils.isNullOrEmpty(guessed) && MISSING_TAG.equals(sName)) {
            sName = String.format("(%s)", guessed);
        }
        return String.format("%s %s, %s-%s %s (%s) ", sName, node.getHouseNumber(), node.getCountry(), node.getPostCode(), node.getCity(), node.getState());
    }
}

