/*
 * Decompiled with CFR 0.152.
 */
package pdfimport;

import java.util.Properties;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;

public class FilePlacement {
    public Projection projection = null;
    public double minX = 0.0;
    public double maxX = 1.0;
    public double minY = 0.0;
    public double maxY = 1.0;
    public double minEast = 0.0;
    public double maxEast = 10000.0;
    public double minNorth = 0.0;
    public double maxNorth = 10000.0;
    EastNorth en = new EastNorth(0.0, 0.0);

    public void setPdfBounds(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public void setEastNorthBounds(double minEast, double minNorth, double maxEast, double maxNorth) {
        this.minEast = minEast;
        this.maxEast = maxEast;
        this.minNorth = minNorth;
        this.maxNorth = maxNorth;
    }

    public Properties toProperties() {
        Properties p = new Properties();
        if (this.projection != null) {
            p.setProperty("Projection", this.projection.getClass().getCanonicalName());
        }
        p.setProperty("minX", Double.toString(this.minX));
        p.setProperty("maxX", Double.toString(this.maxX));
        p.setProperty("minY", Double.toString(this.minY));
        p.setProperty("maxY", Double.toString(this.maxY));
        p.setProperty("minEast", Double.toString(this.minEast));
        p.setProperty("maxEast", Double.toString(this.maxEast));
        p.setProperty("minNorth", Double.toString(this.minNorth));
        p.setProperty("maxNorth", Double.toString(this.maxNorth));
        return p;
    }

    public void fromProperties(Properties p) {
        String className = p.getProperty("Projection", null);
        this.projection = null;
        if (className != null) {
            for (Projection proj : Projection.allProjections) {
                if (!proj.getClass().getCanonicalName().equals(className)) continue;
                this.projection = proj;
                break;
            }
        }
        this.minX = this.parseProperty(p, "minX", this.minX);
        this.maxX = this.parseProperty(p, "maxX", this.maxX);
        this.minY = this.parseProperty(p, "minY", this.minY);
        this.maxY = this.parseProperty(p, "maxY", this.maxY);
        this.minEast = this.parseProperty(p, "minEast", this.minEast);
        this.maxEast = this.parseProperty(p, "maxEast", this.maxEast);
        this.minNorth = this.parseProperty(p, "minNorth", this.minNorth);
        this.maxNorth = this.parseProperty(p, "maxNorth", this.maxNorth);
    }

    private double parseProperty(Properties p, String name, double defaultValue) {
        if (!p.containsKey(name)) {
            return defaultValue;
        }
        String value = p.getProperty(name);
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public LatLon tranformCoords(double x, double y) {
        if (this.projection == null) {
            return new LatLon(y / 1000.0, x / 1000.0);
        }
        x = (x - this.minX) * (this.maxEast - this.minEast) / (this.maxX - this.minX) + this.minEast;
        y = (y - this.minY) * (this.maxNorth - this.minNorth) / (this.maxY - this.minY) + this.minNorth;
        this.en.setLocation(x, y);
        return this.projection.eastNorth2latlon(this.en);
    }

    public EastNorth reverseTransform(LatLon coor) {
        if (this.projection == null) {
            return new EastNorth(coor.lon() * 1000.0, coor.lat() * 1000.0);
        }
        return null;
    }
}

