/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.afm.AFMParser;
import org.apache.fontbox.afm.FontMetric;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.encoding.AFMEncoding;
import org.apache.pdfbox.encoding.DictionaryEncoding;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.EncodingManager;
import org.apache.pdfbox.encoding.Type1Encoding;
import org.apache.pdfbox.encoding.conversion.CMapSubstitution;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PDFont
implements COSObjectable {
    private static final Log log = LogFactory.getLog(PDFont.class);
    protected COSDictionary font;
    private Encoding fontEncoding = null;
    protected CMap cmap = null;
    private static Map<String, CMap> cmapObjects = Collections.synchronizedMap(new HashMap());
    private static final Map<String, FontMetric> afmObjects = Collections.unmodifiableMap(PDFont.getAdobeFontMetrics());
    private static final String resourceRootCMAP = "org/apache/pdfbox/resources/cmap/";
    private static final String resourceRootAFM = "org/apache/pdfbox/resources/afm/";
    private FontMetric afm = null;
    private COSBase encodingObject = null;
    private static final String[] SINGLE_CHAR_STRING = new String[256];
    private static final String[][] DOUBLE_CHAR_STRING = new String[256][256];
    private String subtype = null;
    private boolean type1Font;
    private boolean trueTypeFont;
    private boolean typeFont;

    private static Map<String, FontMetric> getAdobeFontMetrics() {
        HashMap<String, FontMetric> metrics = new HashMap<String, FontMetric>();
        PDFont.addAdobeFontMetric(metrics, "Courier-Bold");
        PDFont.addAdobeFontMetric(metrics, "Courier-BoldOblique");
        PDFont.addAdobeFontMetric(metrics, "Courier");
        PDFont.addAdobeFontMetric(metrics, "Courier-Oblique");
        PDFont.addAdobeFontMetric(metrics, "Helvetica");
        PDFont.addAdobeFontMetric(metrics, "Helvetica-Bold");
        PDFont.addAdobeFontMetric(metrics, "Helvetica-BoldOblique");
        PDFont.addAdobeFontMetric(metrics, "Helvetica-Oblique");
        PDFont.addAdobeFontMetric(metrics, "Symbol");
        PDFont.addAdobeFontMetric(metrics, "Times-Bold");
        PDFont.addAdobeFontMetric(metrics, "Times-BoldItalic");
        PDFont.addAdobeFontMetric(metrics, "Times-Italic");
        PDFont.addAdobeFontMetric(metrics, "Times-Roman");
        PDFont.addAdobeFontMetric(metrics, "ZapfDingbats");
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAdobeFontMetric(Map<String, FontMetric> metrics, String name) {
        block5: {
            try {
                String resource = resourceRootAFM + name + ".afm";
                InputStream afmStream = ResourceLoader.loadResource(resource);
                if (afmStream == null) break block5;
                try {
                    AFMParser parser = new AFMParser(afmStream);
                    parser.parse();
                    metrics.put(name, parser.getResult());
                }
                finally {
                    afmStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void clearResources() {
        cmapObjects.clear();
    }

    public PDFont() {
        this.font = new COSDictionary();
        this.font.setItem(COSName.TYPE, (COSBase)COSName.FONT);
    }

    public PDFont(COSDictionary fontDictionary) {
        this.font = fontDictionary;
        this.determineEncoding();
    }

    private void determineEncoding() {
        FontMetric metric;
        COSDictionary cidsysteminfo;
        String cmapName = null;
        COSName encodingName = null;
        COSBase toUnicode = this.font.getDictionaryObject(COSName.TO_UNICODE);
        COSBase encoding = this.getEncodingObject();
        if (toUnicode != null) {
            if (toUnicode instanceof COSStream) {
                try {
                    this.parseCmap(null, ((COSStream)toUnicode).getUnfilteredStream(), null);
                }
                catch (IOException exception) {
                    log.error("Error: Could not load embedded CMAP");
                }
            } else if (toUnicode instanceof COSName) {
                encodingName = (COSName)toUnicode;
                this.cmap = cmapObjects.get(encodingName.getName());
                if (this.cmap == null) {
                    cmapName = encodingName.getName();
                }
            }
        }
        if (encoding != null) {
            if (encoding instanceof COSName) {
                if (this.cmap == null) {
                    encodingName = (COSName)encoding;
                    this.cmap = cmapObjects.get(encodingName.getName());
                    if (this.cmap == null) {
                        cmapName = encodingName.getName();
                    }
                }
                if (this.cmap == null && cmapName != null) {
                    try {
                        this.fontEncoding = EncodingManager.INSTANCE.getEncoding(encodingName);
                    }
                    catch (IOException exception) {
                        log.debug("Debug: Could not find encoding for " + encodingName);
                    }
                }
            } else if (encoding instanceof COSDictionary) {
                try {
                    this.fontEncoding = new DictionaryEncoding((COSDictionary)encoding);
                }
                catch (IOException exception) {
                    log.error("Error: Could not create the DictionaryEncoding");
                }
            } else if (encoding instanceof COSStream && this.cmap == null) {
                COSStream encodingStream = (COSStream)encoding;
                try {
                    this.parseCmap(null, encodingStream.getUnfilteredStream(), null);
                }
                catch (IOException exception) {
                    log.error("Error: Could not parse the embedded CMAP");
                }
            }
        }
        if ((cidsysteminfo = (COSDictionary)this.font.getDictionaryObject(COSName.CIDSYSTEMINFO)) != null) {
            String ordering = cidsysteminfo.getString(COSName.ORDERING);
            String registry = cidsysteminfo.getString(COSName.REGISTRY);
            int supplement = cidsysteminfo.getInt(COSName.SUPPLEMENT);
            cmapName = registry + "-" + ordering + "-" + supplement;
            cmapName = CMapSubstitution.substituteCMap(cmapName);
            this.cmap = cmapObjects.get(cmapName);
        }
        if ((metric = this.getAFM()) != null) {
            this.fontEncoding = new AFMEncoding(metric);
        }
        if (this.cmap == null && cmapName != null) {
            String resourceName = resourceRootCMAP + cmapName;
            try {
                this.parseCmap(resourceRootCMAP, ResourceLoader.loadResource(resourceName), encodingName);
                if (this.cmap == null && encodingName == null) {
                    log.error("Error: Could not parse predefined CMAP file for '" + cmapName + "'");
                }
            }
            catch (IOException exception) {
                log.error("Error: Could not find predefined CMAP file for '" + cmapName + "'");
            }
        }
        this.getEncodingFromFont();
    }

    @Override
    public COSBase getCOSObject() {
        return this.font;
    }

    public abstract float getFontWidth(byte[] var1, int var2, int var3) throws IOException;

    public abstract float getFontHeight(byte[] var1, int var2, int var3) throws IOException;

    public float getStringWidth(String string) throws IOException {
        byte[] data = string.getBytes("ISO-8859-1");
        float totalWidth = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            totalWidth += this.getFontWidth(data, i, 1);
        }
        return totalWidth;
    }

    public abstract float getAverageFontWidth() throws IOException;

    public abstract void drawString(String var1, Graphics var2, float var3, AffineTransform var4, float var5, float var6) throws IOException;

    protected int getCodeFromArray(byte[] data, int offset, int length) {
        int code = 0;
        for (int i = 0; i < length; ++i) {
            code <<= 8;
            code |= (data[offset + i] + 256) % 256;
        }
        return code;
    }

    protected float getFontWidthFromAFMFile(int code) throws IOException {
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            Encoding encoding = this.getEncoding();
            String characterName = encoding.getName(code);
            retval = metric.getCharacterWidth(characterName);
        }
        return retval;
    }

    protected float getAverageFontWidthFromAFMFile() throws IOException {
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            retval = metric.getAverageCharacterWidth();
        }
        return retval;
    }

    protected FontMetric getAFM() {
        if (this.afm == null) {
            COSBase baseFont = this.font.getDictionaryObject(COSName.BASE_FONT);
            String name = null;
            if (baseFont instanceof COSName) {
                name = ((COSName)baseFont).getName();
                if (name.indexOf("+") > -1) {
                    name = name.substring(name.indexOf("+") + 1);
                }
            } else if (baseFont instanceof COSString) {
                COSString string = (COSString)baseFont;
                name = string.getString();
            }
            if (name != null) {
                this.afm = afmObjects.get(name);
            }
        }
        return this.afm;
    }

    private COSBase getEncodingObject() {
        if (this.encodingObject == null) {
            this.encodingObject = this.font.getDictionaryObject(COSName.ENCODING);
        }
        return this.encodingObject;
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        String retval = null;
        if (this.cmap != null) {
            if (length == 1 && this.cmap.hasOneByteMappings()) {
                retval = this.cmap.lookup(c, offset, length);
            } else if (length == 2 && this.cmap.hasTwoByteMappings()) {
                retval = this.cmap.lookup(c, offset, length);
            }
        }
        if (retval == null) {
            Encoding encoding = this.getEncoding();
            if (encoding != null) {
                retval = encoding.getCharacter(this.getCodeFromArray(c, offset, length));
            }
            if (retval == null && (this.cmap == null || length == 2)) {
                retval = PDFont.getStringFromArray(c, offset, length);
            }
        }
        return retval;
    }

    private static String getStringFromArray(byte[] c, int offset, int length) throws IOException {
        String retval = null;
        if (length == 1) {
            retval = SINGLE_CHAR_STRING[(c[offset] + 256) % 256];
        } else if (length == 2) {
            retval = DOUBLE_CHAR_STRING[(c[offset] + 256) % 256][(c[offset + 1] + 256) % 256];
        } else {
            throw new IOException("Error:Unknown character length:" + length);
        }
        return retval;
    }

    private void parseCmap(String cmapRoot, InputStream cmapStream, COSName encodingName) {
        if (cmapStream != null) {
            CMapParser parser = new CMapParser();
            try {
                this.cmap = parser.parse(cmapRoot, cmapStream);
                if (encodingName != null) {
                    cmapObjects.put(encodingName.getName(), this.cmap);
                }
            }
            catch (IOException exception) {
                // empty catch block
            }
        }
    }

    public void setEncoding(Encoding enc) {
        this.font.setItem(COSName.ENCODING, (COSObjectable)enc);
        this.fontEncoding = enc;
    }

    public Encoding getEncoding() throws IOException {
        return this.fontEncoding;
    }

    public String getType() {
        return this.font.getNameAsString(COSName.TYPE);
    }

    public String getSubType() {
        if (this.subtype == null) {
            this.subtype = this.font.getNameAsString(COSName.SUBTYPE);
            this.type1Font = "Type1".equals(this.subtype);
            this.trueTypeFont = "TrueType".equals(this.subtype);
            this.typeFont = this.type1Font || "Type0".equals(this.subtype) || this.trueTypeFont;
        }
        return this.subtype;
    }

    private boolean isType1Font() {
        this.getSubType();
        return this.type1Font;
    }

    private boolean isTrueTypeFont() {
        this.getSubType();
        return this.trueTypeFont;
    }

    private boolean isTypeFont() {
        this.getSubType();
        return this.typeFont;
    }

    public String getBaseFont() {
        return this.font.getNameAsString(COSName.BASE_FONT);
    }

    public void setBaseFont(String baseFont) {
        this.font.setName(COSName.BASE_FONT, baseFont);
    }

    public int getFirstChar() {
        return this.font.getInt(COSName.FIRST_CHAR, -1);
    }

    public void setFirstChar(int firstChar) {
        this.font.setInt(COSName.FIRST_CHAR, firstChar);
    }

    public int getLastChar() {
        return this.font.getInt(COSName.LAST_CHAR, -1);
    }

    public void setLastChar(int lastChar) {
        this.font.setInt(COSName.LAST_CHAR, lastChar);
    }

    public List getWidths() {
        COSArray array = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS);
        return COSArrayList.convertFloatCOSArrayToList(array);
    }

    public void setWidths(List widths) {
        this.font.setItem(COSName.WIDTHS, (COSBase)COSArrayList.converterToCOSArray(widths));
    }

    public PDMatrix getFontMatrix() {
        PDMatrix matrix = null;
        COSArray array = (COSArray)this.font.getDictionaryObject(COSName.FONT_MATRIX);
        if (array == null) {
            array = new COSArray();
            array.add(new COSFloat(0.001f));
            array.add(COSInteger.ZERO);
            array.add(COSInteger.ZERO);
            array.add(new COSFloat(0.001f));
            array.add(COSInteger.ZERO);
            array.add(COSInteger.ZERO);
        }
        matrix = new PDMatrix(array);
        return matrix;
    }

    private void getEncodingFromFont() {
        COSStream fontFile;
        COSDictionary fontDescriptor;
        if (this.isType1Font() && (fontDescriptor = (COSDictionary)this.font.getDictionaryObject(COSName.FONT_DESC)) != null && (fontFile = (COSStream)fontDescriptor.getDictionaryObject(COSName.FONT_FILE)) != null) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(fontFile.getUnfilteredStream()));
                String line = "";
                Type1Encoding encoding = null;
                while ((line = in.readLine()) != null) {
                    StringTokenizer st;
                    if (line.startsWith("currentdict end")) {
                        if (encoding == null) break;
                        this.fontEncoding = encoding;
                        break;
                    }
                    if (line.startsWith("/Encoding")) {
                        if (line.endsWith("array")) {
                            st = new StringTokenizer(line);
                            st.nextElement();
                            int arraySize = Integer.parseInt(st.nextToken());
                            encoding = new Type1Encoding(arraySize);
                            continue;
                        }
                        if (this.fontEncoding != null) continue;
                        st = new StringTokenizer(line);
                        st.nextElement();
                        String type1Encoding = st.nextToken();
                        this.fontEncoding = EncodingManager.INSTANCE.getEncoding(COSName.getPDFName(type1Encoding));
                        break;
                    }
                    if (!line.startsWith("dup")) continue;
                    st = new StringTokenizer(line);
                    st.nextElement();
                    int index = Integer.parseInt(st.nextToken());
                    String name = st.nextToken();
                    encoding.addCharacterEncoding(index, name.replace("/", ""));
                }
                in.close();
            }
            catch (IOException exception) {
                log.error("Error: Could not extract the encoding from the embedded type1 font.");
            }
        }
    }

    public abstract PDRectangle getFontBoundingBox() throws IOException;

    public boolean equals(Object other) {
        return other instanceof PDFont && ((PDFont)other).getCOSObject() == this.getCOSObject();
    }

    public int hashCode() {
        return this.getCOSObject().hashCode();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            PDFont.SINGLE_CHAR_STRING[i] = new String(new byte[]{(byte)i});
            for (int j = 0; j < 256; ++j) {
                try {
                    PDFont.DOUBLE_CHAR_STRING[i][j] = new String(new byte[]{(byte)i, (byte)j}, "UTF-16BE");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

